/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.core.IntervalBiFunction;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.core.predicate.PredicateCreator;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class RetryConfig
implements Serializable {
    private static final long serialVersionUID = 3522903275067138911L;
    public static final long DEFAULT_WAIT_DURATION = 500L;
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private static final IntervalFunction DEFAULT_INTERVAL_FUNCTION = numOfAttempts -> 500L;
    private static final IntervalBiFunction DEFAULT_INTERVAL_BI_FUNCTION = IntervalBiFunction.ofIntervalFunction((IntervalFunction)DEFAULT_INTERVAL_FUNCTION);
    private static final Predicate<Throwable> DEFAULT_RECORD_FAILURE_PREDICATE = throwable -> true;
    private Class<? extends Throwable>[] retryExceptions = new Class[0];
    private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
    @Nullable
    private transient Predicate<Throwable> retryOnExceptionPredicate;
    @Nullable
    private transient Predicate retryOnResultPredicate;
    @Nullable
    private BiConsumer consumeResultBeforeRetryAttempt;
    private int maxAttempts = 3;
    private boolean failAfterMaxAttempts = false;
    private boolean writableStackTraceEnabled = true;
    @Nullable
    private transient IntervalFunction intervalFunction;
    private transient IntervalBiFunction intervalBiFunction = DEFAULT_INTERVAL_BI_FUNCTION;
    private transient Predicate<Throwable> exceptionPredicate;

    private RetryConfig() {
    }

    public static <T> Builder<T> custom() {
        return new Builder();
    }

    public static <T> Builder<T> from(RetryConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static RetryConfig ofDefaults() {
        return new Builder().build();
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public boolean isFailAfterMaxAttempts() {
        return this.failAfterMaxAttempts;
    }

    public boolean isWritableStackTraceEnabled() {
        return this.writableStackTraceEnabled;
    }

    @Deprecated
    @Nullable
    public Function<Integer, Long> getIntervalFunction() {
        return this.intervalFunction;
    }

    public <T> IntervalBiFunction<T> getIntervalBiFunction() {
        return this.intervalBiFunction;
    }

    public Predicate<Throwable> getExceptionPredicate() {
        return this.exceptionPredicate;
    }

    @Nullable
    public <T> Predicate<T> getResultPredicate() {
        return this.retryOnResultPredicate;
    }

    public <T> BiConsumer<Integer, T> getConsumeResultBeforeRetryAttempt() {
        return this.consumeResultBeforeRetryAttempt;
    }

    public String toString() {
        StringBuilder retryConfig = new StringBuilder("RetryConfig {");
        retryConfig.append("maxAttempts=");
        retryConfig.append(this.maxAttempts);
        retryConfig.append(", failAfterMaxAttempts=");
        retryConfig.append(this.failAfterMaxAttempts);
        retryConfig.append(", writableStackTraceEnabled=");
        retryConfig.append(this.writableStackTraceEnabled);
        retryConfig.append(", intervalFunction=");
        retryConfig.append(this.intervalFunction);
        retryConfig.append(", retryOnExceptionPredicate=");
        retryConfig.append(this.retryOnExceptionPredicate);
        retryConfig.append(", retryOnResultPredicate=");
        retryConfig.append(this.retryOnResultPredicate);
        retryConfig.append(", intervalBiFunction=");
        retryConfig.append(this.intervalBiFunction);
        retryConfig.append(", consumeResultBeforeRetryAttempt=");
        retryConfig.append(this.consumeResultBeforeRetryAttempt);
        retryConfig.append(", retryExceptions=");
        retryConfig.append(Arrays.toString(this.retryExceptions));
        retryConfig.append(", ignoreExceptions=");
        retryConfig.append(Arrays.toString(this.ignoreExceptions));
        retryConfig.append("}");
        return retryConfig.toString();
    }

    public static class Builder<T> {
        private int maxAttempts = 3;
        private boolean failAfterMaxAttempts = false;
        private boolean writableStackTraceEnabled = true;
        @Nullable
        private IntervalFunction intervalFunction;
        @Nullable
        private Predicate<Throwable> retryOnExceptionPredicate;
        @Nullable
        private Predicate<T> retryOnResultPredicate;
        @Nullable
        private IntervalBiFunction<T> intervalBiFunction;
        @Nullable
        BiConsumer<Integer, T> consumeResultBeforeRetryAttempt;
        private Class<? extends Throwable>[] retryExceptions = new Class[0];
        private Class<? extends Throwable>[] ignoreExceptions = new Class[0];

        public Builder() {
        }

        public Builder(RetryConfig baseConfig) {
            this.maxAttempts = baseConfig.maxAttempts;
            this.retryOnExceptionPredicate = baseConfig.retryOnExceptionPredicate;
            this.retryOnResultPredicate = baseConfig.retryOnResultPredicate;
            this.consumeResultBeforeRetryAttempt = baseConfig.consumeResultBeforeRetryAttempt;
            this.failAfterMaxAttempts = baseConfig.failAfterMaxAttempts;
            this.writableStackTraceEnabled = baseConfig.writableStackTraceEnabled;
            this.retryExceptions = baseConfig.retryExceptions;
            this.ignoreExceptions = baseConfig.ignoreExceptions;
            if (baseConfig.intervalFunction != null) {
                this.intervalFunction = baseConfig.intervalFunction;
            } else {
                this.intervalBiFunction = baseConfig.intervalBiFunction;
            }
        }

        public Builder<T> maxAttempts(int maxAttempts) {
            if (maxAttempts < 1) {
                throw new IllegalArgumentException("maxAttempts must be greater than or equal to 1");
            }
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder<T> waitDuration(Duration waitDuration) {
            if (waitDuration.toMillis() < 0L) {
                throw new IllegalArgumentException("waitDuration must be a positive value");
            }
            this.intervalBiFunction = (attempt, either) -> waitDuration.toMillis();
            return this;
        }

        public Builder<T> retryOnResult(Predicate<T> predicate) {
            this.retryOnResultPredicate = predicate;
            return this;
        }

        public Builder<T> consumeResultBeforeRetryAttempt(BiConsumer<Integer, T> consumeResultBeforeRetryAttempt) {
            this.consumeResultBeforeRetryAttempt = consumeResultBeforeRetryAttempt;
            return this;
        }

        public Builder<T> failAfterMaxAttempts(boolean bool) {
            this.failAfterMaxAttempts = bool;
            return this;
        }

        public Builder<T> writableStackTraceEnabled(boolean bool) {
            this.writableStackTraceEnabled = bool;
            return this;
        }

        public Builder<T> intervalFunction(IntervalFunction f) {
            this.intervalFunction = f;
            return this;
        }

        public Builder<T> intervalBiFunction(IntervalBiFunction<T> f) {
            this.intervalBiFunction = f;
            return this;
        }

        public Builder<T> retryOnException(Predicate<Throwable> predicate) {
            this.retryOnExceptionPredicate = predicate;
            return this;
        }

        @SafeVarargs
        public final Builder<T> retryExceptions(Class<? extends Throwable> ... errorClasses) {
            this.retryExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        @SafeVarargs
        public final Builder<T> ignoreExceptions(Class<? extends Throwable> ... errorClasses) {
            this.ignoreExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        public RetryConfig build() {
            if (this.intervalFunction != null && this.intervalBiFunction != null) {
                throw new IllegalStateException("The intervalFunction was configured twice which could result in an undesired state. Please use either intervalFunction or intervalBiFunction.");
            }
            RetryConfig config = new RetryConfig();
            config.maxAttempts = this.maxAttempts;
            config.failAfterMaxAttempts = this.failAfterMaxAttempts;
            config.writableStackTraceEnabled = this.writableStackTraceEnabled;
            config.retryOnExceptionPredicate = this.retryOnExceptionPredicate;
            config.retryOnResultPredicate = this.retryOnResultPredicate;
            config.consumeResultBeforeRetryAttempt = this.consumeResultBeforeRetryAttempt;
            config.retryExceptions = this.retryExceptions;
            config.ignoreExceptions = this.ignoreExceptions;
            config.exceptionPredicate = this.createExceptionPredicate();
            config.intervalFunction = this.createIntervalFunction();
            config.intervalBiFunction = Optional.ofNullable(this.intervalBiFunction).orElse(IntervalBiFunction.ofIntervalFunction((IntervalFunction)config.intervalFunction));
            return config;
        }

        @Nullable
        private IntervalFunction createIntervalFunction() {
            if (this.intervalFunction == null && this.intervalBiFunction == null) {
                return IntervalFunction.ofDefaults();
            }
            return this.intervalFunction;
        }

        private Predicate<Throwable> createExceptionPredicate() {
            return this.createRetryOnExceptionPredicate().and(PredicateCreator.createNegatedExceptionsPredicate((Class[])this.ignoreExceptions).orElse(DEFAULT_RECORD_FAILURE_PREDICATE));
        }

        private Predicate<Throwable> createRetryOnExceptionPredicate() {
            return PredicateCreator.createExceptionsPredicate(this.retryOnExceptionPredicate, (Class[])this.retryExceptions).orElse(DEFAULT_RECORD_FAILURE_PREDICATE);
        }
    }
}

