/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.jcache.Expiration;

public class Durations {
    public static final MetaParam.MetaLifespan ETERNAL = new MetaParam.MetaLifespan(-1L);

    public static long toMs(Duration duration) {
        if (duration.isEternal()) {
            return -1L;
        }
        return duration.getTimeUnit().toMillis(duration.getDurationAmount());
    }

    public static <K, V> void setWithTtl(EntryView.ReadWriteEntryView<K, V> view, V value, ExpiryPolicy expiryPolicy, Expiration.Operation operation) {
        Duration ttl = Expiration.getExpiry((ExpiryPolicy)expiryPolicy, (Expiration.Operation)operation);
        if (ttl == null) {
            view.set(value, new MetaParam.Writable[0]);
        } else if (ttl.isEternal()) {
            view.set(value, new MetaParam.Writable[]{ETERNAL});
        } else if (ttl.isZero()) {
            view.remove();
        } else {
            view.set(value, new MetaParam.Writable[]{new MetaParam.MetaLifespan(Durations.toMs(ttl))});
        }
    }

    public static <K, V> void updateTtl(EntryView.ReadWriteEntryView<K, V> view, ExpiryPolicy expiryPolicy) {
        Durations.updateTtl(view, expiryPolicy, Expiration.Operation.ACCESS);
    }

    public static <K, V> void updateTtl(EntryView.ReadWriteEntryView<K, V> view, ExpiryPolicy expiryPolicy, Expiration.Operation operation) {
        if (!view.find().isPresent()) {
            return;
        }
        Duration ttl = Expiration.getExpiry((ExpiryPolicy)expiryPolicy, (Expiration.Operation)operation);
        if (ttl != null) {
            if (ttl.isEternal()) {
                if (view.findMetaParam(MetaParam.MetaLifespan.class).filter(lifespan -> lifespan.get() >= 0L).isPresent()) {
                    view.set(view.get(), new MetaParam.Writable[]{ETERNAL});
                }
            } else if (ttl.isZero()) {
                view.remove();
            } else {
                view.set(view.get(), new MetaParam.Writable[]{new MetaParam.MetaLifespan(Durations.toMs(ttl))});
            }
        }
    }
}

