/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.AddressFromURIString$;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException;
import org.apache.pekko.remote.Ack;
import org.apache.pekko.remote.ByteStringUtils$;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.SeqNo;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.AssociationHandle$Quarantined$;
import org.apache.pekko.remote.transport.AssociationHandle$Shutdown$;
import org.apache.pekko.remote.transport.AssociationHandle$Unknown$;
import org.apache.pekko.remote.transport.HandshakeInfo;
import org.apache.pekko.remote.transport.PduCodecException;
import org.apache.pekko.remote.transport.PekkoPduCodec;
import org.apache.pekko.remote.transport.PekkoPduCodec$Heartbeat$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.CompactByteString$;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class PekkoPduProtobufCodec$
implements PekkoPduCodec {
    public static final PekkoPduProtobufCodec$ MODULE$ = new PekkoPduProtobufCodec$();
    private static final ByteString DISASSOCIATE = MODULE$.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE, (Option<WireFormats.PekkoHandshakeInfo.Builder>)None$.MODULE$);
    private static final ByteString DISASSOCIATE_SHUTTING_DOWN = MODULE$.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE_SHUTTING_DOWN, (Option<WireFormats.PekkoHandshakeInfo.Builder>)None$.MODULE$);
    private static final ByteString DISASSOCIATE_QUARANTINED = MODULE$.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE_QUARANTINED, (Option<WireFormats.PekkoHandshakeInfo.Builder>)None$.MODULE$);
    private static final ByteString constructHeartbeat = MODULE$.constructControlMessagePdu(WireFormats.CommandType.HEARTBEAT, (Option<WireFormats.PekkoHandshakeInfo.Builder>)None$.MODULE$);

    @Override
    public ByteString encodePdu(PekkoPduCodec.PekkoPdu pdu) {
        return PekkoPduCodec.encodePdu$(this, pdu);
    }

    private WireFormats.AcknowledgementInfo.Builder ackBuilder(Ack ack) {
        WireFormats.AcknowledgementInfo.Builder ackBuilder = WireFormats.AcknowledgementInfo.newBuilder();
        ackBuilder.setCumulativeAck(ack.cumulativeAck().rawValue());
        ack.nacks().foreach((Function1 & Serializable)nack -> ackBuilder.addNacks(nack.rawValue()));
        return ackBuilder;
    }

    @Override
    public ByteString constructMessage(Address localAddress, ActorRef recipient, WireFormats.SerializedMessage serializedMessage, ActorRef senderOption, Option<SeqNo> seqOption, Option<Ack> ackOption) {
        WireFormats.AckAndEnvelopeContainer.Builder ackAndEnvelopeBuilder = WireFormats.AckAndEnvelopeContainer.newBuilder();
        WireFormats.RemoteEnvelope.Builder envelopeBuilder = WireFormats.RemoteEnvelope.newBuilder();
        envelopeBuilder.setRecipient(this.serializeActorRef(recipient.path().address(), recipient));
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)senderOption)) {
            ActorRef sender = (ActorRef)OptionVal$.MODULE$.get$extension((Object)senderOption);
            envelopeBuilder.setSender(this.serializeActorRef(localAddress, sender));
        }
        seqOption.foreach((Function1 & Serializable)seq -> envelopeBuilder.setSeq(seq.rawValue()));
        ackOption.foreach((Function1 & Serializable)ack -> ackAndEnvelopeBuilder.setAck(MODULE$.ackBuilder((Ack)ack)));
        envelopeBuilder.setMessage(serializedMessage);
        ackAndEnvelopeBuilder.setEnvelope(envelopeBuilder);
        byte[] fromArrayUnsafe_array = ackAndEnvelopeBuilder.build().toByteArray();
        return new ByteString.ByteString1C(fromArrayUnsafe_array);
    }

    @Override
    public Option<SeqNo> constructMessage$default$5() {
        return None$.MODULE$;
    }

    @Override
    public Option<Ack> constructMessage$default$6() {
        return None$.MODULE$;
    }

    @Override
    public ByteString constructPureAck(Ack ack) {
        byte[] fromArrayUnsafe_array = WireFormats.AckAndEnvelopeContainer.newBuilder().setAck(this.ackBuilder(ack)).build().toByteArray();
        return new ByteString.ByteString1C(fromArrayUnsafe_array);
    }

    @Override
    public ByteString constructPayload(ByteString payload) {
        byte[] fromArrayUnsafe_array = WireFormats.PekkoProtocolMessage.newBuilder().setPayload(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(payload)).build().toByteArray();
        return new ByteString.ByteString1C(fromArrayUnsafe_array);
    }

    @Override
    public ByteString constructAssociate(HandshakeInfo info) {
        WireFormats.PekkoHandshakeInfo.Builder handshakeInfo = WireFormats.PekkoHandshakeInfo.newBuilder().setOrigin(this.serializeAddress(info.origin())).setUid(info.uid());
        return this.constructControlMessagePdu(WireFormats.CommandType.ASSOCIATE, (Option<WireFormats.PekkoHandshakeInfo.Builder>)new Some((Object)handshakeInfo));
    }

    private ByteString DISASSOCIATE() {
        return DISASSOCIATE;
    }

    private ByteString DISASSOCIATE_SHUTTING_DOWN() {
        return DISASSOCIATE_SHUTTING_DOWN;
    }

    private ByteString DISASSOCIATE_QUARANTINED() {
        return DISASSOCIATE_QUARANTINED;
    }

    @Override
    public ByteString constructDisassociate(AssociationHandle.DisassociateInfo info) {
        if (AssociationHandle$Unknown$.MODULE$.equals(info)) {
            return this.DISASSOCIATE();
        }
        if (AssociationHandle$Shutdown$.MODULE$.equals(info)) {
            return this.DISASSOCIATE_SHUTTING_DOWN();
        }
        if (AssociationHandle$Quarantined$.MODULE$.equals(info)) {
            return this.DISASSOCIATE_QUARANTINED();
        }
        throw new MatchError((Object)info);
    }

    @Override
    public ByteString constructHeartbeat() {
        return constructHeartbeat;
    }

    @Override
    public PekkoPduCodec.PekkoPdu decodePdu(ByteString raw) {
        PekkoPduCodec.PekkoPdu pekkoPdu;
        block4: {
            try {
                WireFormats.PekkoProtocolMessage pdu = WireFormats.PekkoProtocolMessage.parseFrom(raw.toArrayUnsafe());
                if (pdu.hasPayload()) {
                    ByteBuffer fromByteBuffer_buffer = pdu.getPayload().asReadOnlyByteBuffer();
                    Object var4_3 = null;
                    PekkoPduCodec.Payload payload = new PekkoPduCodec.Payload((ByteString)CompactByteString$.MODULE$.apply(fromByteBuffer_buffer));
                    pekkoPdu = payload;
                    break block4;
                }
                if (pdu.hasInstruction()) {
                    pekkoPdu = this.decodeControlPdu(pdu.getInstruction());
                    break block4;
                }
                throw new PduCodecException("Error decoding Pekko PDU: Neither message nor control message were contained", null);
            }
            catch (InvalidProtocolBufferException e) {
                throw new PduCodecException("Decoding PDU failed.", e);
            }
        }
        return pekkoPdu;
    }

    @Override
    public Tuple2<Option<Ack>, Option<PekkoPduCodec.Message>> decodeMessage(ByteString raw, RemoteActorRefProvider provider, Address localAddress) {
        None$ none$;
        None$ ackOption;
        WireFormats.AckAndEnvelopeContainer ackAndEnvelope = WireFormats.AckAndEnvelopeContainer.parseFrom(raw.toArrayUnsafe());
        Object object = ackOption = ackAndEnvelope.hasAck() ? new Some((Object)new Ack(new SeqNo(ackAndEnvelope.getAck().getCumulativeAck()), (Set<SeqNo>)((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, ackAndEnvelope.getAck().getNacksList()).asScala().map((Function1 & Serializable)x$1 -> new SeqNo(Predef$.MODULE$.Long2long(x$1)))).toSet())) : None$.MODULE$;
        if (ackAndEnvelope.hasEnvelope()) {
            InternalActorRef internalActorRef;
            WireFormats.RemoteEnvelope msgPdu = ackAndEnvelope.getEnvelope();
            InternalActorRef internalActorRef2 = provider.resolveActorRefWithLocalAddress(msgPdu.getRecipient().getPath(), localAddress);
            Address address = AddressFromURIString$.MODULE$.apply(msgPdu.getRecipient().getPath());
            WireFormats.SerializedMessage serializedMessage = msgPdu.getMessage();
            if (msgPdu.hasSender()) {
                internalActorRef = provider.resolveActorRefWithLocalAddress(msgPdu.getSender().getPath(), localAddress);
            } else {
                OptionVal$.MODULE$.None();
                internalActorRef = null;
            }
            none$ = new Some((Object)new PekkoPduCodec.Message(internalActorRef2, address, serializedMessage, (ActorRef)internalActorRef, (Option<SeqNo>)(msgPdu.hasSeq() ? new Some((Object)new SeqNo(msgPdu.getSeq())) : None$.MODULE$)));
        } else {
            none$ = None$.MODULE$;
        }
        None$ messageOption = none$;
        return new Tuple2((Object)ackOption, (Object)messageOption);
    }

    /*
     * WARNING - void declaration
     */
    private PekkoPduCodec.PekkoPdu decodeControlPdu(WireFormats.PekkoControlMessage controlPdu) {
        WireFormats.CommandType commandType = controlPdu.getCommandType();
        if (((Object)((Object)WireFormats.CommandType.ASSOCIATE)).equals((Object)commandType) && controlPdu.hasHandshakeInfo()) {
            void apply_uid;
            WireFormats.PekkoHandshakeInfo handshakeInfo = controlPdu.getHandshakeInfo();
            int n = (int)handshakeInfo.getUid();
            Address apply_origin = this.decodeAddress(handshakeInfo.getOrigin());
            Object var4_5 = null;
            return new PekkoPduCodec.Associate(new HandshakeInfo(apply_origin, (int)apply_uid, (Option<String>)None$.MODULE$));
        }
        if (((Object)((Object)WireFormats.CommandType.DISASSOCIATE)).equals((Object)commandType)) {
            return new PekkoPduCodec.Disassociate(AssociationHandle$Unknown$.MODULE$);
        }
        if (((Object)((Object)WireFormats.CommandType.DISASSOCIATE_SHUTTING_DOWN)).equals((Object)commandType)) {
            return new PekkoPduCodec.Disassociate(AssociationHandle$Shutdown$.MODULE$);
        }
        if (((Object)((Object)WireFormats.CommandType.DISASSOCIATE_QUARANTINED)).equals((Object)commandType)) {
            return new PekkoPduCodec.Disassociate(AssociationHandle$Quarantined$.MODULE$);
        }
        if (((Object)((Object)WireFormats.CommandType.HEARTBEAT)).equals((Object)commandType)) {
            return PekkoPduCodec$Heartbeat$.MODULE$;
        }
        throw new PduCodecException(new StringBuilder(62).append("Decoding of control PDU failed, invalid format, unexpected: [").append((Object)commandType).append("]").toString(), null);
    }

    private Address decodeAddress(WireFormats.AddressData encodedAddress) {
        return Address$.MODULE$.apply(encodedAddress.getProtocol(), encodedAddress.getSystem(), encodedAddress.getHostname(), encodedAddress.getPort());
    }

    private ByteString constructControlMessagePdu(WireFormats.CommandType code, Option<WireFormats.PekkoHandshakeInfo.Builder> handshakeInfo) {
        WireFormats.PekkoControlMessage.Builder controlMessageBuilder = WireFormats.PekkoControlMessage.newBuilder();
        controlMessageBuilder.setCommandType(code);
        handshakeInfo.foreach((Function1 & Serializable)builderForValue -> controlMessageBuilder.setHandshakeInfo((WireFormats.PekkoHandshakeInfo.Builder)builderForValue));
        byte[] apply_bytes = WireFormats.PekkoProtocolMessage.newBuilder().setInstruction(controlMessageBuilder.build()).build().toByteArray();
        return new ByteString.ByteString1C(apply_bytes);
    }

    private WireFormats.ActorRefData serializeActorRef(Address defaultAddress, ActorRef ref) {
        return WireFormats.ActorRefData.newBuilder().setPath(ref.path().address().host().isDefined() ? ref.path().toSerializationFormat() : ref.path().toSerializationFormatWithAddress(defaultAddress)).build();
    }

    private WireFormats.AddressData serializeAddress(Address address) {
        if (address != null) {
            String protocol = address.protocol();
            String system = address.system();
            Option option = address.host();
            Option option2 = address.port();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return WireFormats.AddressData.newBuilder().setHostname(host).setPort(port).setSystem(system).setProtocol(protocol).build();
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Address [").append(address).append("] could not be serialized: host or port missing.").toString());
    }

    private PekkoPduProtobufCodec$() {
    }
}

