/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.database.statement.AbstractBatchStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchStatement
extends AbstractBatchStatement {
    private static final Logger logger = LoggerFactory.getLogger(BatchStatement.class);

    BatchStatement(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        logger.debug("addBatch(sql={}) - start", (Object)sql);
        this._statement.addBatch(sql);
    }

    @Override
    public int executeBatch() throws SQLException {
        logger.debug("executeBatch() - start");
        int[] results = this._statement.executeBatch();
        int result = 0;
        for (int i = 0; i < results.length; ++i) {
            result += results[i];
        }
        return result;
    }

    @Override
    public void clearBatch() throws SQLException {
        logger.debug("clearBatch() - start");
        this._statement.clearBatch();
    }
}

