/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.datatype.IDbProductRelatable;
import org.dbunit.dataset.filter.IColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableMetaData
implements ITableMetaData {
    private Map _columnsToIndexes;
    private static final Logger logger = LoggerFactory.getLogger(AbstractTableMetaData.class);

    protected static Column[] getPrimaryKeys(Column[] columns, String[] keyNames) {
        logger.debug("getPrimaryKeys(columns={}, keyNames={}) - start", (Object)columns, (Object)keyNames);
        return Columns.getColumns(keyNames, columns);
    }

    protected static Column[] getPrimaryKeys(String tableName, Column[] columns, IColumnFilter columnFilter) {
        if (logger.isDebugEnabled()) {
            logger.debug("getPrimaryKeys(tableName={}, columns={}, columnFilter={}) - start", new Object[]{tableName, columns, columnFilter});
        }
        return Columns.getColumns(tableName, columns, columnFilter);
    }

    @Override
    public int getColumnIndex(String columnName) throws DataSetException {
        String columnNameUpperCase;
        Integer colIndex;
        logger.debug("getColumnIndex(columnName={}) - start", (Object)columnName);
        if (this._columnsToIndexes == null) {
            this._columnsToIndexes = this.createColumnIndexesMap(this.getColumns());
        }
        if ((colIndex = (Integer)this._columnsToIndexes.get(columnNameUpperCase = columnName.toUpperCase())) != null) {
            return colIndex;
        }
        throw new NoSuchColumnException(this.getTableName(), columnNameUpperCase, " (Non-uppercase input column: " + columnName + ") in ColumnNameToIndexes cache map. Note that the map's column names are NOT case sensitive.");
    }

    private Map createColumnIndexesMap(Column[] columns) {
        HashMap<String, Integer> colsToIndexes = new HashMap<String, Integer>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            colsToIndexes.put(columns[i].getColumnName().toUpperCase(), new Integer(i));
        }
        return colsToIndexes;
    }

    public IDataTypeFactory getDataTypeFactory(IDatabaseConnection connection) throws SQLException {
        DatabaseConfig config = connection.getConfig();
        Object factoryObj = config.getProperty("http://www.dbunit.org/properties/datatypeFactory");
        if (!IDataTypeFactory.class.isAssignableFrom(factoryObj.getClass())) {
            String msg = "Invalid datatype factory configured. Class '" + factoryObj.getClass() + "' does not implement '" + IDataTypeFactory.class + "'.";
            if (factoryObj instanceof String) {
                msg = msg + " Ensure not to specify the fully qualified class name as String but the concrete instance of the datatype factory (for example 'new OracleDataTypeFactory()').";
            }
            throw new DatabaseUnitRuntimeException(msg);
        }
        IDataTypeFactory dataTypeFactory = (IDataTypeFactory)factoryObj;
        Connection jdbcConnection = connection.getConnection();
        DatabaseMetaData metaData = jdbcConnection.getMetaData();
        String validationMessage = this.validateDataTypeFactory(dataTypeFactory, metaData);
        if (validationMessage != null) {
            logger.warn("Potential problem found: " + validationMessage);
        }
        return dataTypeFactory;
    }

    String validateDataTypeFactory(IDataTypeFactory dataTypeFactory, DatabaseMetaData metaData) throws SQLException {
        if (!(dataTypeFactory instanceof IDbProductRelatable)) {
            return null;
        }
        IDbProductRelatable productRelatable = (IDbProductRelatable)((Object)dataTypeFactory);
        String databaseProductName = metaData.getDatabaseProductName();
        Collection validDbProductCollection = productRelatable.getValidDbProducts();
        if (validDbProductCollection != null) {
            String lowerCaseDbProductName = databaseProductName.toLowerCase();
            Iterator iterator = validDbProductCollection.iterator();
            while (iterator.hasNext()) {
                String validDbProduct = ((String)iterator.next()).toLowerCase();
                if (lowerCaseDbProductName.indexOf(validDbProduct) <= -1) continue;
                logger.debug("The current database '{}' fits to the configured data type factory '{}'. Validation successful.", (Object)databaseProductName, (Object)dataTypeFactory);
                return null;
            }
        }
        String validationMessage = "The configured data type factory '" + dataTypeFactory.getClass() + "' might cause problems with the current database '" + databaseProductName + "' (e.g. some datatypes may not be supported properly). In rare cases you might see this message because the list of supported database products is incomplete (list=" + validDbProductCollection + "). If so please request a java-class update via the forums.If you are using your own IDataTypeFactory extending DefaultDataTypeFactory, ensure that you override getValidDbProducts() to specify the supported database products.";
        return validationMessage;
    }
}

