/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsDataSetWriter {
    private static final Logger logger = LoggerFactory.getLogger(XlsDataSetWriter.class);
    public static final String ZEROS = "0000000000000000000000000000000000000000000000000000";
    public static final String DATE_FORMAT_AS_NUMBER_DBUNIT = "####################";
    private static final Map<Workbook, Map> cellStyleMap = new HashMap<Workbook, Map>();
    private CellStyle dateCellStyle;

    public void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        logger.debug("write(dataSet={}, out={}) - start", (Object)dataSet, (Object)out);
        Workbook workbook = this.createWorkbook();
        this.dateCellStyle = XlsDataSetWriter.createDateCellStyle(workbook);
        int index = 0;
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            int j;
            ITable table = iterator.getTable();
            ITableMetaData metaData = table.getTableMetaData();
            Sheet sheet = workbook.createSheet(metaData.getTableName());
            workbook.setSheetName(index, metaData.getTableName());
            Row headerRow = sheet.createRow(0);
            Column[] columns = metaData.getColumns();
            for (j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                Cell cell = headerRow.createCell(j);
                cell.setCellValue(column.getColumnName());
            }
            for (j = 0; j < table.getRowCount(); ++j) {
                Row row = sheet.createRow(j + 1);
                for (int k = 0; k < columns.length; ++k) {
                    Column column = columns[k];
                    Object value = table.getValue(j, column.getColumnName());
                    if (value == null) continue;
                    Cell cell = row.createCell(k);
                    if (value instanceof Date) {
                        this.setDateCell(cell, (Date)value, workbook);
                        continue;
                    }
                    if (value instanceof BigDecimal) {
                        this.setNumericCell(cell, (BigDecimal)value, workbook);
                        continue;
                    }
                    if (value instanceof Long) {
                        this.setDateCell(cell, new Date((Long)value), workbook);
                        continue;
                    }
                    cell.setCellValue(DataType.asString(value));
                }
            }
            ++index;
        }
        workbook.write(out);
        out.flush();
    }

    protected static CellStyle createDateCellStyle(Workbook workbook) {
        DataFormat format = workbook.createDataFormat();
        short dateFormatCode = format.getFormat(DATE_FORMAT_AS_NUMBER_DBUNIT);
        return XlsDataSetWriter.getCellStyle(workbook, dateFormatCode);
    }

    protected static CellStyle getCellStyle(Workbook workbook, short formatCode) {
        Map<Short, CellStyle> map = XlsDataSetWriter.findWorkbookCellStyleMap(workbook);
        CellStyle cellStyle = XlsDataSetWriter.findCellStyle(workbook, formatCode, map);
        return cellStyle;
    }

    protected static Map<Short, CellStyle> findWorkbookCellStyleMap(Workbook workbook) {
        HashMap map = cellStyleMap.get(workbook);
        if (map == null) {
            map = new HashMap();
            cellStyleMap.put(workbook, map);
        }
        return map;
    }

    protected static CellStyle findCellStyle(Workbook workbook, Short formatCode, Map<Short, CellStyle> map) {
        CellStyle cellStyle = map.get(formatCode);
        if (cellStyle == null) {
            cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat(formatCode.shortValue());
            map.put(formatCode, cellStyle);
        }
        return cellStyle;
    }

    protected void setDateCell(Cell cell, Date value, Workbook workbook) {
        long timeMillis = value.getTime();
        cell.setCellValue((double)timeMillis);
        cell.setCellType(CellType.NUMERIC);
        cell.setCellStyle(this.dateCellStyle);
    }

    protected void setNumericCell(Cell cell, BigDecimal value, Workbook workbook) {
        short format;
        if (logger.isDebugEnabled()) {
            logger.debug("setNumericCell(cell={}, value={}, workbook={}) - start", new Object[]{cell, value, workbook});
        }
        cell.setCellValue(value.doubleValue());
        DataFormat df = workbook.createDataFormat();
        int scale = value.scale();
        if (scale <= 0) {
            format = df.getFormat("####");
        } else {
            String zeros = XlsDataSetWriter.createZeros(value.scale());
            format = df.getFormat("####." + zeros);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using format '{}' for value '{}'.", (Object)String.valueOf(format), (Object)value);
        }
        CellStyle cellStyleNumber = XlsDataSetWriter.getCellStyle(workbook, format);
        cell.setCellStyle(cellStyleNumber);
    }

    private static String createZeros(int count) {
        return ZEROS.substring(0, count);
    }

    protected Workbook createWorkbook() {
        return new HSSFWorkbook();
    }
}

