/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.search;

import java.util.HashSet;
import java.util.Set;
import org.dbunit.util.search.ISearchCallback;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodesFilterSearchCallback
implements ISearchCallback {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final int NO_MODE = 0;
    protected static final int ALLOW_MODE = 1;
    protected static final int DENY_MODE = 2;
    private int filteringMode = 0;
    private Set filteredNodes = new HashSet();

    protected Set getFilteredNodes() {
        return this.filteredNodes;
    }

    protected int getFilteringMode() {
        return this.filteringMode;
    }

    protected void setAllowedNodes(Set filteredNodes) {
        this.logger.debug("setAllowedNodes(filteredNodes=" + filteredNodes + ") - start");
        this.setFilteredNodes(filteredNodes);
        this.filteringMode = 1;
    }

    protected void setAllowedNodes(Object[] filteredNodes) {
        this.logger.debug("setAllowedNodes(filteredNodes=" + filteredNodes + ") - start");
        this.setFilteredNodes(filteredNodes);
        this.filteringMode = 1;
    }

    protected void setDeniedNodes(Set filteredNodes) {
        this.logger.debug("setDeniedNodes(filteredNodes=" + filteredNodes + ") - start");
        this.setFilteredNodes(filteredNodes);
        this.filteringMode = 2;
    }

    protected void setDeniedNodes(Object[] filteredNodes) {
        this.logger.debug("setDeniedNodes(filteredNodes=" + filteredNodes + ") - start");
        this.setFilteredNodes(filteredNodes);
        this.filteringMode = 2;
    }

    @Override
    public void nodeAdded(Object fromNode) throws SearchException {
    }

    @Override
    public boolean searchNode(Object node) throws SearchException {
        this.logger.debug("searchNode(node=" + node + ") - start");
        switch (this.filteringMode) {
            case 1: {
                return this.getFilteredNodes().contains(node);
            }
            case 2: {
                return !this.getFilteredNodes().contains(node);
            }
        }
        return true;
    }

    private void setFilteredNodes(Set filteredNodes) {
        this.logger.debug("setFilteredNodes(filteredNodes=" + filteredNodes + ") - start");
        this.filteredNodes = new HashSet(filteredNodes);
    }

    private void setFilteredNodes(Object[] filteredNodes) {
        this.logger.debug("setFilteredNodes(filteredNodes=" + filteredNodes + ") - start");
        this.filteredNodes = new HashSet(filteredNodes.length);
        for (int i = 0; i < filteredNodes.length; ++i) {
            this.filteredNodes.add(filteredNodes[i]);
        }
    }
}

