/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.profile;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.model.XldUserProfile;
import com.xebialabs.deployit.security.model.XldUserProfile$;
import com.xebialabs.deployit.security.repository.XldUserProfileRepository;
import com.xebialabs.deployit.security.sql.SqlUserService;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\u0007\u000e\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0004?\u0001\t\u0007I\u0011B \t\r!\u0003\u0001\u0015!\u0003A\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u00151\u0007\u0001\"\u0003h\u0011\u0015y\u0007\u0001\"\u0003q\u0005UAF\u000eZ+tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016T!AD\b\u0002\u000fA\u0014xNZ5mK*\u0011\u0001#E\u0001\bg\u0016\u0014h/[2f\u0015\t\u00112#\u0001\u0005eKBdw._5u\u0015\t!R#A\u0005yK\nL\u0017\r\\1cg*\ta#A\u0002d_6\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\f\u0001\u0004\u001f7e+N,'\u000f\u0015:pM&dWMU3q_NLGo\u001c:z!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0006sKB|7/\u001b;pefT!!J\t\u0002\u0011M,7-\u001e:jifL!a\n\u0012\u00031acG-V:feB\u0013xNZ5mKJ+\u0007o\\:ji>\u0014\u00180A\u0006vg\u0016\u00148+\u001a:wS\u000e,\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017%\u0003\r\u0019\u0018\u000f\\\u0005\u0003]-\u0012abU9m+N,'oU3sm&\u001cW-\u0001\bmS\u000e,gn]3TKJ4\u0018nY3\u0011\u0005E*T\"\u0001\u001a\u000b\u0005A\u0019$B\u0001\u001b\u0014\u0003\u001da\u0017nY3og\u0016L!A\u000e\u001a\u0003\u001d1K7-\u001a8tKN+'O^5dK\u00061A(\u001b8jiz\"B!O\u001e={A\u0011!\bA\u0007\u0002\u001b!)q\u0004\u0002a\u0001A!)\u0001\u0006\u0002a\u0001S!)q\u0006\u0002a\u0001a\u00051An\\4hKJ,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bQa\u001d7gi)T\u0011!R\u0001\u0004_J<\u0017BA$C\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013A\u00067pO&t\u0017\t\u001c7po\u0016$Wk]3s'R\fG/^:\u0015\u0005-s\u0005C\u0001\u000eM\u0013\ti5D\u0001\u0003V]&$\b\"B(\b\u0001\u0004\u0001\u0016\u0001C;tKJt\u0015-\\3\u0011\u0005ECfB\u0001*W!\t\u00196$D\u0001U\u0015\t)v#\u0001\u0004=e>|GOP\u0005\u0003/n\ta\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011qkG\u0001\u0012e\u0016<\u0017n\u001d;fe2{w-\u001b8US6,GCA&^\u0011\u0015q\u0006\u00021\u0001Q\u0003!)8/\u001a:oC6,\u0017!G2sK\u0006$Xm\u0014:Va\u0012\fG/Z+tKJ\u0004&o\u001c4jY\u0016$BaS1dK\")!-\u0003a\u0001!\u0006Aa-\u001e7m\u001d\u0006lW\rC\u0003e\u0013\u0001\u0007\u0001+A\u0003f[\u0006LG\u000eC\u0003P\u0013\u0001\u0007\u0001+\u0001\u0004fcV\fGn\u001d\u000b\u0004Q.l\u0007C\u0001\u000ej\u0013\tQ7DA\u0004C_>dW-\u00198\t\u000b1T\u0001\u0019\u0001)\u0002\tM$(/\r\u0005\u0006]*\u0001\r\u0001U\u0001\u0005gR\u0014('A\u0011iCNd\u0015nY3og\u0016$vn\u0011:fCR,g*Z<FqR,'O\\1m+N,'/F\u0001iQ\t\u0001!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006Q1\u000f^3sK>$\u0018\u0010]3\u000b\u0005]$\u0015aD:qe&twM\u001a:b[\u0016<xN]6\n\u0005e$(aB*feZL7-\u001a\u0015\u0003\u0001m\u00042\u0001`A\u0004\u001b\u0005i(B\u0001@\u0000\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u0003\t\u0019!A\u0004gC\u000e$xN]=\u000b\u0007\u0005\u0015a/A\u0003cK\u0006t7/C\u0002\u0002\nu\u0014\u0011\"Q;u_^L'/\u001a3")
public class XldUserProfileService {
    private final XldUserProfileRepository xldUserProfileRepository;
    private final SqlUserService userService;
    private final LicenseService licenseService;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public void loginAllowedUserStatus(String userName) {
        XldUserProfile profile = (XldUserProfile)this.xldUserProfileRepository.findOne(userName, this.xldUserProfileRepository.findOne$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("User " + userName + " does not exist", new Object[0]);
        });
        if (!profile.loginAllowed()) {
            throw new DisabledException("Your account is currently disabled. Please contact your Deploy administrator for further assistance.");
        }
    }

    public void registerLoginTime(String username) {
        this.xldUserProfileRepository.updateLastActive(username, new Date());
    }

    public void createOrUpdateUserProfile(String fullName, String email, String userName) {
        try {
            this.userService.read(userName);
            this.logger().info("Unable to create profile for user [{}]. A local account exists.", (Object)userName);
            throw new BadCredentialsException(String.format("An internal user is available with this username; therefore, login using the identity provider is not allowed. Please use your username and password to log in.", new Object[0]));
        }
        catch (NotFoundException notFoundException) {
            Option profile = this.xldUserProfileRepository.findOne(userName, this.xldUserProfileRepository.findOne$default$2());
            if (profile.isEmpty()) {
                if (!this.hasLicenseToCreateNewExternalUser()) {
                    this.logger().info("Maximum number of users allowed by license has been reached. Cannot create external user profile for user [{}]", (Object)userName);
                    throw new DisabledException(String.format("There are no available seats left under your Deploy license. Please contact your Deploy administrator for further assistance.", new Object[0]));
                }
                XldUserProfile userProfile = new XldUserProfile(userName.toLowerCase(), true, Predef$.MODULE$.Set().empty(), fullName, email, true, new Date(), false, XldUserProfile$.MODULE$.$lessinit$greater$default$9());
                this.xldUserProfileRepository.createUserProfile(userProfile, true);
            } else {
                XldUserProfile existingProfile = (XldUserProfile)profile.get();
                if (!existingProfile.loginAllowed()) {
                    this.logger().info("User [{}] account is currently disabled. Please contact your Deploy administrator for further assistance.", (Object)userName);
                    throw new DisabledException("Your account is currently disabled. Please contact your Deploy administrator for further assistance.");
                }
                if (!this.equals(existingProfile.email(), email) || !this.equals(existingProfile.fullName(), fullName)) {
                    this.xldUserProfileRepository.updateExternalUserProfile(fullName, email, new Date(), userName);
                } else {
                    this.xldUserProfileRepository.updateLastActive(userName, new Date());
                }
            }
            return;
        }
    }

    private boolean equals(String str1, String str2) {
        Option option = Option$.MODULE$.apply((Object)str1);
        Option option2 = Option$.MODULE$.apply((Object)str2);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    private boolean hasLicenseToCreateNewExternalUser() {
        String maxNumberOfUsers = this.licenseService.getLicense().getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS);
        if (maxNumberOfUsers != null) {
            int countUserWithLoginAllowed = this.xldUserProfileRepository.countUserWithLoginAllowed();
            return Integer.parseInt(maxNumberOfUsers) > countUserWithLoginAllowed;
        }
        return true;
    }

    public XldUserProfileService(XldUserProfileRepository xldUserProfileRepository, SqlUserService userService, LicenseService licenseService) {
        this.xldUserProfileRepository = xldUserProfileRepository;
        this.userService = userService;
        this.licenseService = licenseService;
        this.logger = LoggerFactory.getLogger(XldUserProfileService.class);
    }
}

