/*
 * Decompiled with CFR 0.152.
 */
package kamon.context.generated.binary.span;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Arrays;
import java.util.InputMismatchException;

public class Span
implements Serializable {
    public static int colferSizeMax = 0x1000000;
    public byte[] traceID;
    public byte[] spanID;
    public byte[] parentID;
    public byte samplingDecision;
    private static final byte[] _zeroBytes = new byte[0];
    private static final long serialVersionUID = 4L;

    public Span() {
        this.init();
    }

    private void init() {
        this.traceID = _zeroBytes;
        this.spanID = _zeroBytes;
        this.parentID = _zeroBytes;
    }

    public byte[] marshal(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[Math.min(colferSizeMax, 2048)];
        }
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferOverflowException bufferOverflowException) {
                byArray = new byte[Math.min(colferSizeMax, byArray.length * 4)];
                continue;
            }
            break;
        }
        outputStream.write(byArray, 0, n);
        return byArray;
    }

    public int marshal(byte[] byArray, int n) {
        int n2 = n;
        try {
            int n3;
            int n4;
            int n5;
            if (this.traceID.length != 0) {
                byArray[n2++] = 0;
                n5 = this.traceID.length;
                if (n5 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/span.Span.traceID size %d exceeds %d bytes", n5, colferSizeMax));
                }
                for (n4 = n5; n4 > 127; n4 >>>= 7) {
                    byArray[n2++] = (byte)(n4 | 0x80);
                }
                byArray[n2++] = (byte)n4;
                n3 = n2;
                n2 += n5;
                System.arraycopy(this.traceID, 0, byArray, n3, n5);
            }
            if (this.spanID.length != 0) {
                byArray[n2++] = 1;
                n5 = this.spanID.length;
                if (n5 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/span.Span.spanID size %d exceeds %d bytes", n5, colferSizeMax));
                }
                for (n4 = n5; n4 > 127; n4 >>>= 7) {
                    byArray[n2++] = (byte)(n4 | 0x80);
                }
                byArray[n2++] = (byte)n4;
                n3 = n2;
                n2 += n5;
                System.arraycopy(this.spanID, 0, byArray, n3, n5);
            }
            if (this.parentID.length != 0) {
                byArray[n2++] = 2;
                n5 = this.parentID.length;
                if (n5 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/span.Span.parentID size %d exceeds %d bytes", n5, colferSizeMax));
                }
                for (n4 = n5; n4 > 127; n4 >>>= 7) {
                    byArray[n2++] = (byte)(n4 | 0x80);
                }
                byArray[n2++] = (byte)n4;
                n3 = n2;
                n2 += n5;
                System.arraycopy(this.parentID, 0, byArray, n3, n5);
            }
            if (this.samplingDecision != 0) {
                byArray[n2++] = 3;
                byArray[n2++] = this.samplingDecision;
            }
            byArray[n2++] = 127;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 - n > colferSizeMax) {
                throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/span.Span exceeds %d bytes", colferSizeMax));
            }
            if (n2 > byArray.length) {
                throw new BufferOverflowException();
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int unmarshal(byte[] byArray, int n) {
        return this.unmarshal(byArray, n, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unmarshal(byte[] byArray, int n, int n2) {
        int n3;
        block19: {
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            n3 = n;
            try {
                byte by;
                int n4;
                int n5;
                byte by2 = byArray[n3++];
                if (by2 == 0) {
                    n5 = 0;
                    n4 = 0;
                    while (true) {
                        by = byArray[n3++];
                        n5 |= (by & 0x7F) << n4;
                        if (n4 == 28 || by >= 0) break;
                        n4 += 7;
                    }
                    if (n5 < 0 || n5 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/span.Span.traceID size %d exceeds %d bytes", n5, colferSizeMax));
                    }
                    this.traceID = new byte[n5];
                    n4 = n3;
                    n3 += n5;
                    System.arraycopy(byArray, n4, this.traceID, 0, n5);
                    by2 = byArray[n3++];
                }
                if (by2 == 1) {
                    n5 = 0;
                    n4 = 0;
                    while (true) {
                        by = byArray[n3++];
                        n5 |= (by & 0x7F) << n4;
                        if (n4 == 28 || by >= 0) break;
                        n4 += 7;
                    }
                    if (n5 < 0 || n5 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/span.Span.spanID size %d exceeds %d bytes", n5, colferSizeMax));
                    }
                    this.spanID = new byte[n5];
                    n4 = n3;
                    n3 += n5;
                    System.arraycopy(byArray, n4, this.spanID, 0, n5);
                    by2 = byArray[n3++];
                }
                if (by2 == 2) {
                    n5 = 0;
                    n4 = 0;
                    while (true) {
                        by = byArray[n3++];
                        n5 |= (by & 0x7F) << n4;
                        if (n4 == 28 || by >= 0) break;
                        n4 += 7;
                    }
                    if (n5 < 0 || n5 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/span.Span.parentID size %d exceeds %d bytes", n5, colferSizeMax));
                    }
                    this.parentID = new byte[n5];
                    n4 = n3;
                    n3 += n5;
                    System.arraycopy(byArray, n4, this.parentID, 0, n5);
                    by2 = byArray[n3++];
                }
                if (by2 == 3) {
                    this.samplingDecision = byArray[n3++];
                    by2 = byArray[n3++];
                }
                if (by2 != 127) {
                    throw new InputMismatchException(String.format("colfer: unknown header at byte %d", n3 - 1));
                }
                if (n3 <= n2 || n2 - n >= colferSizeMax) break block19;
            }
            catch (Throwable throwable) {
                if (n3 > n2 && n2 - n < colferSizeMax) {
                    throw new BufferUnderflowException();
                }
                if (n3 < 0 || n3 - n > colferSizeMax) {
                    throw new SecurityException(String.format("colfer: kamon/context/generated/binary/span.Span exceeds %d bytes", colferSizeMax));
                }
                if (n3 > n2) {
                    throw new BufferUnderflowException();
                }
                throw throwable;
            }
            throw new BufferUnderflowException();
        }
        if (n3 < 0 || n3 - n > colferSizeMax) {
            throw new SecurityException(String.format("colfer: kamon/context/generated/binary/span.Span exceeds %d bytes", colferSizeMax));
        }
        if (n3 > n2) {
            throw new BufferUnderflowException();
        }
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                byArray = new byte[4 * byArray.length];
                continue;
            }
            break;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray, 0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.init();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.unmarshal(byArray, 0);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init();
    }

    public byte[] getTraceID() {
        return this.traceID;
    }

    public void setTraceID(byte[] byArray) {
        this.traceID = byArray;
    }

    public Span withTraceID(byte[] byArray) {
        this.traceID = byArray;
        return this;
    }

    public byte[] getSpanID() {
        return this.spanID;
    }

    public void setSpanID(byte[] byArray) {
        this.spanID = byArray;
    }

    public Span withSpanID(byte[] byArray) {
        this.spanID = byArray;
        return this;
    }

    public byte[] getParentID() {
        return this.parentID;
    }

    public void setParentID(byte[] byArray) {
        this.parentID = byArray;
    }

    public Span withParentID(byte[] byArray) {
        this.parentID = byArray;
        return this;
    }

    public byte getSamplingDecision() {
        return this.samplingDecision;
    }

    public void setSamplingDecision(byte by) {
        this.samplingDecision = by;
    }

    public Span withSamplingDecision(byte by) {
        this.samplingDecision = by;
        return this;
    }

    public final int hashCode() {
        int n = 1;
        for (byte by : this.traceID) {
            n = 31 * n + by;
        }
        for (byte by : this.spanID) {
            n = 31 * n + by;
        }
        for (byte by : this.parentID) {
            n = 31 * n + by;
        }
        n = 31 * n + (this.samplingDecision & 0xFF);
        return n;
    }

    public final boolean equals(Object object) {
        return object instanceof Span && this.equals((Span)object);
    }

    public final boolean equals(Span span) {
        if (span == null) {
            return false;
        }
        if (span == this) {
            return true;
        }
        return span.getClass() == Span.class && Arrays.equals(this.traceID, span.traceID) && Arrays.equals(this.spanID, span.spanID) && Arrays.equals(this.parentID, span.parentID) && this.samplingDecision == span.samplingDecision;
    }

    public static class Unmarshaller {
        protected InputStream in;
        public byte[] buf;
        protected int offset;
        protected int i;

        public Unmarshaller(InputStream inputStream, byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                byArray = new byte[Math.min(colferSizeMax, 2048)];
            }
            this.buf = byArray;
            this.reset(inputStream);
        }

        public void reset(InputStream inputStream) {
            if (this.i != this.offset) {
                throw new IllegalStateException("colfer: pending data");
            }
            this.in = inputStream;
            this.offset = 0;
            this.i = 0;
        }

        public Span next() throws IOException {
            if (this.in == null) {
                return null;
            }
            while (true) {
                if (this.i > this.offset) {
                    try {
                        Span span = new Span();
                        this.offset = span.unmarshal(this.buf, this.offset, this.i);
                        return span;
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (this.i == this.buf.length) {
                    byte[] byArray = this.buf;
                    if (this.offset == 0) {
                        this.buf = new byte[Math.min(colferSizeMax, this.buf.length * 4)];
                    }
                    System.arraycopy(byArray, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert (this.i < this.buf.length);
                int n = this.in.read(this.buf, this.i, this.buf.length - this.i);
                if (n < 0) {
                    if (this.i > this.offset) {
                        throw new InputMismatchException("colfer: pending data with EOF");
                    }
                    return null;
                }
                assert (n > 0);
                this.i += n;
            }
        }
    }
}

