/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.sbom;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.sbom.SbomEndpoint;
import org.springframework.boot.actuate.sbom.SbomProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.MimeType;

@EndpointWebExtension(endpoint=SbomEndpoint.class)
public class SbomEndpointWebExtension {
    private final SbomEndpoint sbomEndpoint;
    private final SbomProperties properties;
    private final Map<String, SbomType> detectedMediaTypeCache = new ConcurrentHashMap<String, SbomType>();

    public SbomEndpointWebExtension(SbomEndpoint sbomEndpoint, SbomProperties properties) {
        this.sbomEndpoint = sbomEndpoint;
        this.properties = properties;
    }

    @ReadOperation
    WebEndpointResponse<Resource> sbom(@Selector String id) {
        Resource resource = this.sbomEndpoint.sbom(id);
        if (resource == null) {
            return new WebEndpointResponse<int>(404);
        }
        MimeType type = this.getMediaType(id, resource);
        return type != null ? new WebEndpointResponse<Resource>(resource, type) : new WebEndpointResponse<Resource>(resource);
    }

    private MimeType getMediaType(String id, Resource resource) {
        if ("application".equals(id) && this.properties.getApplication().getMediaType() != null) {
            return this.properties.getApplication().getMediaType();
        }
        SbomProperties.Sbom sbomProperties = this.properties.getAdditional().get(id);
        if (sbomProperties != null && sbomProperties.getMediaType() != null) {
            return sbomProperties.getMediaType();
        }
        return this.detectedMediaTypeCache.computeIfAbsent(id, ignored -> {
            try {
                return this.detectSbomType(resource);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to detect type of resource '%s'".formatted(resource), ex);
            }
        }).getMediaType();
    }

    private SbomType detectSbomType(Resource resource) throws IOException {
        String content = resource.getContentAsString(StandardCharsets.UTF_8);
        for (SbomType candidate : SbomType.values()) {
            if (!candidate.matches(content)) continue;
            return candidate;
        }
        return SbomType.UNKNOWN;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum SbomType {
        CYCLONE_DX(MimeType.valueOf((String)"application/vnd.cyclonedx+json")){

            @Override
            boolean matches(String content) {
                return content.replaceAll("\\s", "").contains("\"bomFormat\":\"CycloneDX\"");
            }
        }
        ,
        SPDX(MimeType.valueOf((String)"application/spdx+json")){

            @Override
            boolean matches(String content) {
                return content.contains("\"spdxVersion\"");
            }
        }
        ,
        SYFT(MimeType.valueOf((String)"application/vnd.syft+json")){

            @Override
            boolean matches(String content) {
                return content.contains("\"FoundBy\"") || content.contains("\"foundBy\"");
            }
        }
        ,
        UNKNOWN(null){

            @Override
            boolean matches(String content) {
                return false;
            }
        };

        private final MimeType mediaType;

        private SbomType(MimeType mediaType) {
            this.mediaType = mediaType;
        }

        MimeType getMediaType() {
            return this.mediaType;
        }

        abstract boolean matches(String var1);
    }
}

