/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceType;
import com.openhtmltopdf.pdfboxout.AnnotationContainer;
import com.openhtmltopdf.pdfboxout.PdfBoxAccessibilityHelper;
import com.openhtmltopdf.pdfboxout.PdfBoxBookmarkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxFastOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.pdfboxout.quads.KongAlgo;
import com.openhtmltopdf.pdfboxout.quads.Triangle;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.PagedBoxCollector;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.w3c.dom.Element;

public class PdfBoxFastLinkManager {
    private final Map<PDPage, Set<String>> _linkTargetAreas;
    private final SharedContext _sharedContext;
    private final float _dotsPerPoint;
    private final Box _root;
    private final PdfBoxFastOutputDevice _od;
    private final List<LinkDetails> _links;
    private PdfBoxAccessibilityHelper _pdfUa;
    private final Map<String, PDComplexFileSpecification> _embeddedFiles;
    private PDAppearanceDictionary _embeddedFileAppearance;

    public PdfBoxFastLinkManager(SharedContext ctx, float dotsPerPoint, Box root, PdfBoxFastOutputDevice od) {
        this._sharedContext = ctx;
        this._dotsPerPoint = dotsPerPoint;
        this._root = root;
        this._od = od;
        this._linkTargetAreas = new HashMap<PDPage, Set<String>>();
        this._links = new ArrayList<LinkDetails>();
        this._embeddedFiles = new HashMap<String, PDComplexFileSpecification>();
    }

    private Rectangle2D calcTotalLinkArea(RenderingContext c, Box box, float pageHeight, AffineTransform transform) {
        Box prev;
        if (this._pdfUa != null) {
            return PdfBoxFastLinkManager.createTargetArea(c, box, pageHeight, transform, this._root, this._od);
        }
        Box current = box;
        while ((prev = current.getPreviousSibling()) != null && prev.getElement() == box.getElement()) {
            current = prev;
        }
        Rectangle2D result = PdfBoxFastLinkManager.createTargetArea(c, current, pageHeight, transform, this._root, this._od);
        for (current = current.getNextSibling(); current != null && current.getElement() == box.getElement(); current = current.getNextSibling()) {
            result = this.add(result, PdfBoxFastLinkManager.createTargetArea(c, current, pageHeight, transform, this._root, this._od));
        }
        return result;
    }

    private Rectangle2D add(Rectangle2D r1, Rectangle2D r2) {
        return r1.createUnion(r2);
    }

    private String createRectKey(Rectangle2D rect, Shape linkShape, AffineTransform transform) {
        StringBuilder key = new StringBuilder(rect.getMinX() + ":" + rect.getMaxY() + ":" + rect.getMaxX() + ":" + rect.getMinY());
        if (linkShape != null) {
            PathIterator pathIterator = linkShape.getPathIterator(transform);
            double[] vals = new double[6];
            while (!pathIterator.isDone()) {
                int type = pathIterator.currentSegment(vals);
                switch (type) {
                    case 3: {
                        key.append("C");
                        key.append(vals[0]).append(":").append(vals[1]).append(":").append(vals[2]).append(":").append(vals[3]).append(":").append(vals[4]).append(":").append(vals[5]);
                        break;
                    }
                    case 1: {
                        key.append("L");
                        key.append(vals[0]).append(":").append(vals[1]).append(":");
                        break;
                    }
                    case 0: {
                        key.append("M");
                        key.append(vals[0]).append(":").append(vals[1]).append(":");
                        break;
                    }
                    case 2: {
                        key.append("Q");
                        key.append(vals[0]).append(":").append(vals[1]).append(":").append(vals[2]).append(":").append(vals[3]);
                        break;
                    }
                    case 4: {
                        key.append("cp");
                        break;
                    }
                }
                pathIterator.next();
            }
        }
        return key.toString();
    }

    private Rectangle2D checkLinkArea(PDPage page, RenderingContext c, Box box, float pageHeight, AffineTransform transform, Shape linkShape) {
        Rectangle2D targetArea = this.calcTotalLinkArea(c, box, pageHeight, transform);
        String key = this.createRectKey(targetArea, linkShape, transform);
        Set<String> keys = this._linkTargetAreas.get(page);
        if (keys == null) {
            keys = new HashSet<String>();
            this._linkTargetAreas.put(page, keys);
        }
        if (keys.contains(key)) {
            return null;
        }
        keys.add(key);
        return targetArea;
    }

    private void processLink(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform) {
        Map<Shape, String> linkMap;
        ReplacedElement element;
        NamespaceHandler handler;
        String uri;
        Element elem = box.getElement();
        if (elem != null && (uri = (handler = this._sharedContext.getNamespaceHandler()).getLinkUri(elem)) != null) {
            this.addUriAsLink(c, box, page, pageHeight, transform, elem, handler, uri, null);
        }
        if (box instanceof BlockBox && (element = ((BlockBox)box).getReplacedElement()) instanceof PdfBoxLinkManager.IPdfBoxElementWithShapedLinks && (linkMap = ((PdfBoxLinkManager.IPdfBoxElementWithShapedLinks)element).getLinkMap()) != null) {
            for (Map.Entry<Shape, String> shapeStringEntry : linkMap.entrySet()) {
                Shape shape = shapeStringEntry.getKey();
                String shapeUri = shapeStringEntry.getValue();
                NamespaceHandler handler2 = this._sharedContext.getNamespaceHandler();
                this.addUriAsLink(c, box, page, pageHeight, transform, elem, handler2, shapeUri, shape);
            }
        }
    }

    private static boolean isPointEqual(Point2D.Float p1, Point2D.Float p2) {
        double epsilon = 1.0E-6;
        return (double)Math.abs(p1.x - p2.x) < 1.0E-6 && (double)Math.abs(p1.y - p2.y) < 1.0E-6;
    }

    private static void removeDoublicatePoints(List<Point2D.Float> points) {
        boolean rerun;
        do {
            Point2D.Float p2;
            Point2D.Float p1;
            int i;
            rerun = false;
            for (i = 0; i < points.size() - 1; ++i) {
                p1 = points.get(i);
                if (!PdfBoxFastLinkManager.isPointEqual(p1, p2 = points.get(i + 1))) continue;
                points.remove(i);
                rerun = true;
            }
            for (i = 0; i < points.size() - 2; ++i) {
                p1 = points.get(i);
                if (!PdfBoxFastLinkManager.isPointEqual(p1, p2 = points.get(i + 2))) continue;
                points.remove(i);
                rerun = true;
            }
        } while (rerun);
    }

    private void addUriAsLink(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform, Element elem, NamespaceHandler handler, String uri, Shape linkShape) {
        if (uri.length() > 1 && uri.charAt(0) == '#') {
            String anchor = uri.substring(1);
            Box target = this._sharedContext.getBoxById(anchor);
            if (target != null) {
                PDActionGoTo action;
                PDPageXYZDestination dest = this.createDestination(c, target);
                if (handler.getAttributeValue(elem, "onclick") != null && !"".equals(handler.getAttributeValue(elem, "onclick"))) {
                    action = new PDActionJavaScript(handler.getAttributeValue(elem, "onclick"));
                } else {
                    PDActionGoTo go = new PDActionGoTo();
                    go.setDestination((PDDestination)dest);
                    action = go;
                }
                Rectangle2D targetArea = this.checkLinkArea(page, c, box, pageHeight, transform, linkShape);
                if (targetArea == null) {
                    return;
                }
                PDAnnotationLink annot = new PDAnnotationLink();
                annot.setAction((PDAction)action);
                AnnotationContainer.PDAnnotationLinkContainer annotContainer = new AnnotationContainer.PDAnnotationLinkContainer(annot);
                if (!this.placeAnnotation(transform, linkShape, targetArea, annotContainer)) {
                    return;
                }
                this.addLinkToPage(page, annotContainer, box, target);
            } else {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.GENERAL_PDF_COULD_NOT_FIND_VALID_TARGET_FOR_LINK, (Object)uri);
            }
        } else if (PdfBoxFastLinkManager.isURI(uri)) {
            AnnotationContainer annotContainer = null;
            if (!elem.hasAttribute("download")) {
                PDActionURI uriAct = new PDActionURI();
                uriAct.setURI(uri);
                PDAnnotationLink annot = new PDAnnotationLink();
                annot.setAction((PDAction)uriAct);
                annotContainer = new AnnotationContainer.PDAnnotationLinkContainer(annot);
            } else {
                annotContainer = this.createFileEmbedLinkAnnotation(elem, uri);
            }
            if (annotContainer != null) {
                Rectangle2D targetArea = this.checkLinkArea(page, c, box, pageHeight, transform, linkShape);
                if (targetArea == null) {
                    return;
                }
                if (!this.placeAnnotation(transform, linkShape, targetArea, annotContainer)) {
                    return;
                }
                this.addLinkToPage(page, annotContainer, box, null);
            }
        }
    }

    private AnnotationContainer createFileEmbedLinkAnnotation(Element elem, String uri) {
        PDComplexFileSpecification fs = this._embeddedFiles.get(uri);
        if (fs != null) {
            PDAnnotationFileAttachment annotationFileAttachment = new PDAnnotationFileAttachment();
            annotationFileAttachment.setFile((PDFileSpecification)fs);
            annotationFileAttachment.setAppearance(this._embeddedFileAppearance);
            return new AnnotationContainer.PDAnnotationFileAttachmentContainer(annotationFileAttachment);
        }
        byte[] file = this._sharedContext.getUserAgentCallback().getBinaryResource(uri, ExternalResourceType.FILE_EMBED);
        if (file != null) {
            try {
                String contentType = elem.getAttribute("data-content-type").isEmpty() ? "application/octet-stream" : elem.getAttribute("data-content-type");
                PDEmbeddedFile embeddedFile = new PDEmbeddedFile(this._od.getWriter(), (InputStream)new ByteArrayInputStream(file));
                embeddedFile.setSubtype(contentType);
                embeddedFile.setSize(file.length);
                if (elem.hasAttribute("relationship")) {
                    embeddedFile.setModDate(Calendar.getInstance());
                }
                String fileName = elem.getAttribute("download");
                fs = new PDComplexFileSpecification();
                fs.setEmbeddedFile(embeddedFile);
                fs.setFile(fileName);
                fs.setFileUnicode(fileName);
                if (elem.hasAttribute("relationship") && Arrays.asList("Source", "Supplement", "Data", "Alternative", "Unspecified").contains(elem.getAttribute("relationship"))) {
                    fs.getCOSObject().setItem(COSName.getPDFName((String)"AFRelationship"), (COSBase)COSName.getPDFName((String)elem.getAttribute("relationship")));
                }
                if (elem.hasAttribute("title")) {
                    fs.setFileDescription(elem.getAttribute("title"));
                }
                this._embeddedFiles.put(uri, fs);
                if (this._embeddedFileAppearance == null) {
                    this._embeddedFileAppearance = this.createFileEmbedLinkAppearance();
                }
                PDAnnotationFileAttachment annotationFileAttachment = new PDAnnotationFileAttachment();
                annotationFileAttachment.setFile((PDFileSpecification)fs);
                annotationFileAttachment.setAppearance(this._embeddedFileAppearance);
                if (elem.hasAttribute("relationship")) {
                    COSArray fileRefArray = new COSArray();
                    fileRefArray.add((COSObjectable)fs);
                    annotationFileAttachment.getCOSObject().setItem(COSName.getPDFName((String)"AF"), (COSBase)fileRefArray);
                }
                return new AnnotationContainer.PDAnnotationFileAttachmentContainer(annotationFileAttachment);
            }
            catch (IOException e) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_COULD_NOT_LOAD_EMBEDDED_FILE, (Object)uri, (Throwable)e);
            }
        } else {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.LOAD_COULD_NOT_LOAD_EMBEDDED_FILE, (Object)uri);
        }
        return null;
    }

    private PDAppearanceDictionary createFileEmbedLinkAppearance() {
        PDAppearanceDictionary appearanceDictionary = new PDAppearanceDictionary();
        PDAppearanceStream appearanceStream = new PDAppearanceStream(this._od.getWriter());
        appearanceStream.setResources(new PDResources());
        appearanceDictionary.setNormalAppearance(appearanceStream);
        return appearanceDictionary;
    }

    private static boolean isURI(String uri) {
        try {
            return URI.create(uri) != null;
        }
        catch (IllegalArgumentException e) {
            XRLog.log((Level)Level.INFO, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.GENERAL_PDF_URI_IN_HREF_IS_NOT_A_VALID_URI, (Object)uri);
            return false;
        }
    }

    private boolean placeAnnotation(AffineTransform transform, Shape linkShape, Rectangle2D targetArea, AnnotationContainer annot) {
        annot.setRectangle(new PDRectangle((float)targetArea.getMinX(), (float)targetArea.getMinY(), (float)targetArea.getWidth(), (float)targetArea.getHeight()));
        annot.setPrinted(true);
        if (linkShape != null) {
            QuadPointShape quadPointsResult = PdfBoxFastLinkManager.mapShapeToQuadPoints(transform, linkShape, targetArea);
            if (quadPointsResult.quadPoints.length == 0) {
                return false;
            }
            annot.setQuadPoints(quadPointsResult.quadPoints);
            Rectangle2D reducedTarget = quadPointsResult.boundingBox;
            annot.setRectangle(new PDRectangle((float)reducedTarget.getMinX(), (float)reducedTarget.getMinY(), (float)reducedTarget.getWidth(), (float)reducedTarget.getHeight()));
        }
        return true;
    }

    static QuadPointShape mapShapeToQuadPoints(AffineTransform transform, Shape linkShape, Rectangle2D targetArea) {
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        AffineTransform transformForQuads = new AffineTransform();
        transformForQuads.translate(targetArea.getMinX(), targetArea.getMinY());
        transformForQuads.translate(0.0, targetArea.getHeight());
        transformForQuads.scale(1.0, -1.0);
        transformForQuads.concatenate(AffineTransform.getScaleInstance(transform.getScaleX(), transform.getScaleX()));
        Area area = new Area(linkShape);
        PathIterator pathIterator = area.getPathIterator(transformForQuads, 1.0);
        double[] vals = new double[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(vals);
            switch (type) {
                case 3: {
                    throw new RuntimeException("Invalid State, Area should never give us a curve here!");
                }
                case 1: {
                    points.add(new Point2D.Float((float)vals[0], (float)vals[1]));
                    break;
                }
                case 0: {
                    points.add(new Point2D.Float((float)vals[0], (float)vals[1]));
                    break;
                }
                case 2: {
                    throw new RuntimeException("Invalid State, Area should never give us a curve here!");
                }
                case 4: {
                    break;
                }
            }
            pathIterator.next();
        }
        PdfBoxFastLinkManager.removeDoublicatePoints(points);
        KongAlgo algo = new KongAlgo(points);
        algo.runKong();
        float minX = (float)targetArea.getMaxX();
        float maxX = (float)targetArea.getMinX();
        float minY = (float)targetArea.getMaxY();
        float maxY = (float)targetArea.getMinY();
        float[] ret = new float[algo.getTriangles().size() * 8];
        int i = 0;
        for (Triangle triangle : algo.getTriangles()) {
            ret[i++] = triangle.a.x;
            ret[i++] = triangle.a.y;
            ret[i++] = triangle.b.x;
            ret[i++] = triangle.b.y;
            ret[i++] = triangle.b.x + (triangle.c.x - triangle.b.x) / 2.0f;
            ret[i++] = triangle.b.y + (triangle.c.y - triangle.b.y) / 2.0f;
            ret[i++] = triangle.c.x;
            ret[i++] = triangle.c.y;
            for (Point2D.Float p : new Point2D.Float[]{triangle.a, triangle.b, triangle.c}) {
                float x = p.x;
                float y = p.y;
                minX = Math.min(x, minX);
                minY = Math.min(y, minY);
                maxX = Math.max(x, maxX);
                maxY = Math.max(y, maxY);
            }
        }
        if (ret.length % 8 != 0) {
            throw new IllegalStateException("Not exact 8xn QuadPoints!");
        }
        while (i < ret.length) {
            if ((double)ret[i] < targetArea.getMinX() || (double)ret[i] > targetArea.getMaxX()) {
                throw new IllegalStateException("Invalid rectangle calculation. Map shape is out of bound.");
            }
            if ((double)ret[i + 1] < targetArea.getMinY() || (double)ret[i + 1] > targetArea.getMaxY()) {
                throw new IllegalStateException("Invalid rectangle calculation. Map shape is out of bound.");
            }
            i += 2;
        }
        QuadPointShape result = new QuadPointShape();
        result.quadPoints = ret;
        Rectangle2D.Float boundingRectangle = new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
        Rectangle.intersect(targetArea, boundingRectangle, boundingRectangle);
        result.boundingBox = boundingRectangle;
        return result;
    }

    private void addLinkToPage(PDPage page, AnnotationContainer annot, Box anchor, Box target) {
        PDBorderStyleDictionary styleDict = new PDBorderStyleDictionary();
        styleDict.setWidth(0.0f);
        styleDict.setStyle("S");
        annot.setBorderStyle(styleDict);
        try {
            ArrayList<PDAnnotation> annots = page.getAnnotations();
            if (annots == null) {
                annots = new ArrayList<PDAnnotation>();
                page.setAnnotations(annots);
            }
            annots.add(annot.getPdAnnotation());
            if (this._pdfUa != null) {
                this._pdfUa.addLink(anchor, target, annot.getPdAnnotation(), page);
            }
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("processLink", e);
        }
    }

    private PDPageXYZDestination createDestination(RenderingContext c, Box box) {
        return PdfBoxBookmarkManager.createBoxDestination(c, this._od.getWriter(), this._od, this._dotsPerPoint, this._root, box);
    }

    public static Rectangle2D createTargetArea(RenderingContext c, Box box, float pageHeight, AffineTransform transform, Box _root, PdfBoxOutputDevice _od) {
        Rectangle bounds = PagedBoxCollector.findAdjustedBoundsForContentBox((CssContext)c, (Box)box);
        if (!c.isInPageMargins()) {
            int shadow = c.getShadowPageNumber();
            Rectangle pageBounds = shadow == -1 ? c.getPage().getDocumentCoordinatesContentBounds((CssContext)c) : c.getPage().getDocumentCoordinatesContentBoundsForInsertedPage((CssContext)c, shadow);
            bounds = bounds.intersection(pageBounds);
        }
        Point2D.Float pt = new Point2D.Float(bounds.x, (float)bounds.getMaxY());
        Point2D ptTransformed = transform.transform(pt, null);
        return new Rectangle2D.Float((float)ptTransformed.getX(), _od.normalizeY((float)ptTransformed.getY(), pageHeight), _od.getDeviceLength(bounds.width), _od.getDeviceLength(bounds.height));
    }

    public void processLinkLater(RenderingContext c, Box box, PDPage page, float pageHeight, AffineTransform transform) {
        if (box instanceof BlockBox && ((BlockBox)box).getReplacedElement() != null || box.getElement() != null && box.getElement().getNodeName().equals("a")) {
            LinkDetails link = new LinkDetails();
            link.c = (RenderingContext)c.clone();
            link.box = box;
            link.page = page;
            link.pageHeight = pageHeight;
            link.transform = (AffineTransform)transform.clone();
            this._links.add(link);
        }
    }

    public void processLinks(PdfBoxAccessibilityHelper pdfUa) {
        this._pdfUa = pdfUa;
        for (LinkDetails link : this._links) {
            this.processLink(link.c, link.box, link.page, link.pageHeight, link.transform);
        }
    }

    private static class LinkDetails {
        RenderingContext c;
        Box box;
        PDPage page;
        float pageHeight;
        AffineTransform transform;

        private LinkDetails() {
        }
    }

    static class QuadPointShape {
        float[] quadPoints;
        Rectangle2D boundingBox;

        QuadPointShape() {
        }
    }
}

