/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.pat;

import ai.digital.deploy.notification.XldNotificationStore;
import ai.digital.deploy.notification.events.UserTokenAboutToExpireEvent;
import ai.digital.deploy.settings.GeneralSettings;
import ai.digital.deploy.sql.model.UserTokens;
import com.xebialabs.deployit.core.service.GeneralSettingsService;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.service.UserTokenService;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001\u0002\b\u0010\u0001iA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005G!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003-\u0011!I\u0004A!b\u0001\n\u0003Q\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000b\r\u0003A\u0011\u0001#\t\u000fm\u0003!\u0019!C\u00019\"11\r\u0001Q\u0001\nuCQ\u0001\u001a\u0001\u0005\u0002\u0015Da!\u001b\u0001\u0005\u0002=Q\u0007bBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u0003S\u0001A\u0011BA\u0016\u0005Y\u0001\u0016\r\u001e(pi&4\u0017nY1uS>t7+\u001a:wS\u000e,'B\u0001\t\u0012\u0003\r\u0001\u0018\r\u001e\u0006\u0003%M\tAaY8sK*\u0011A#F\u0001\tI\u0016\u0004Hn\\=ji*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017AF4f]\u0016\u0014\u0018\r\\*fiRLgnZ:TKJ4\u0018nY3\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R!AJ\t\u0002\u000fM,'O^5dK&\u0011\u0001&\n\u0002\u0017\u000f\u0016tWM]1m'\u0016$H/\u001b8hgN+'O^5dK\u00069r-\u001a8fe\u0006d7+\u001a;uS:<7oU3sm&\u001cW\rI\u0001\u0015q2$gj\u001c;jM&\u001c\u0017\r^5p]N#xN]3\u0016\u00031\u0002\"!\f\u001c\u000e\u00039R!a\f\u0019\u0002\u00199|G/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005E\u0012\u0014A\u00023fa2|\u0017P\u0003\u00024i\u00059A-[4ji\u0006d'\"A\u001b\u0002\u0005\u0005L\u0017BA\u001c/\u0005QAF\u000e\u001a(pi&4\u0017nY1uS>t7\u000b^8sK\u0006)\u0002\u0010\u001c3O_RLg-[2bi&|gn\u0015;pe\u0016\u0004\u0013\u0001E;tKJ$vn[3o'\u0016\u0014h/[2f+\u0005Y\u0004C\u0001\u001fA\u001b\u0005i$B\u0001\u0014?\u0015\ty4#\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\tUH\u0001\tVg\u0016\u0014Hk\\6f]N+'O^5dK\u0006\tRo]3s)>\\WM\\*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\u0011)uiV-\u0011\u0005\u0019\u0003Q\"A\b\t\u000b\u0005:\u0001\u0019A\u0012)\u0005\u001dK\u0005C\u0001&V\u001b\u0005Y%B\u0001'N\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u001d>\u000bqAZ1di>\u0014\u0018P\u0003\u0002Q#\u0006)!-Z1og*\u0011!kU\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA+A\u0002pe\u001eL!AV&\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002\u0016\b\u0001\u0004a\u0003FA,J\u0011\u0015It\u00011\u0001<Q\tI\u0016*\u0001\u0004m_\u001e<WM]\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001mU\u0001\u0006g24GG[\u0005\u0003E~\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001%Q\u0006tG\r\\3QCRtu\u000e^5gS\u000e\fG/[8o\r>\u0014X\t\u001f9je\u0016$Gk\\6f]R\ta\r\u0005\u0002\u001dO&\u0011\u0001.\b\u0002\u0005+:LG/A\fhKR$vn[3og\u0016C\b/\u001b:j]\u001eLe\u000eR1zgR\u00191.\u001f@\u0011\u00071\f8/D\u0001n\u0015\tqw.\u0001\u0003vi&d'\"\u00019\u0002\t)\fg/Y\u0005\u0003e6\u0014A\u0001T5tiB\u0011Ao^\u0007\u0002k*\u0011aOP\u0001\u0006[>$W\r\\\u0005\u0003qV\u0014A\u0002\u00177e+N,'\u000fV8lK:DQA_\u0006A\u0002m\fAB\\8uS\u001aLW\r\u001a#bsN\u0004\"\u0001\b?\n\u0005ul\"aA%oi\"1qp\u0003a\u0001\u0003\u0003\ta\u0001]1hS:<\u0007\u0003BA\u0002\u0003#i!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0004IR|'\u0002BA\u0006\u0003\u001b\t1!\u00199j\u0015\r\tyaE\u0001\u0007K:<\u0017N\\3\n\t\u0005M\u0011Q\u0001\u0002\u0007!\u0006<\u0017N\\4\u00025U\u0004H-\u0019;f)>\\WM\\#ya&\u0014X\r\u001a(pi&4\u0017.\u001a3\u0015\u0007\u0019\fI\u0002C\u0004\u0002\u001c1\u0001\r!!\b\u0002\u0007\rLG\r\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019c\\\u0001\u0005Y\u0006tw-\u0003\u0003\u0002(\u0005\u0005\"aB%oi\u0016<WM]\u0001\u0018G>tg/\u001a:u+N,'\u000fV8lK:$v\u000eV8lK:$B!!\f\u0002<A!\u0011qFA\u001c\u001b\t\t\tDC\u0002w\u0003gQ1!!\u000e1\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003s\t\tD\u0001\u0006Vg\u0016\u0014Hk\\6f]NDq!!\u0010\u000e\u0001\u0004\ty$\u0001\u0004u_.,gn\u001d\t\u0004i\u0006\u0005\u0013bAA\"k\n1Ak\\6f]ND3\u0001AA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'#\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005E\u00131\n\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class PatNotificationService {
    private final GeneralSettingsService generalSettingsService;
    private final XldNotificationStore xldNotificationStore;
    private final UserTokenService userTokenService;
    private final Logger logger;

    public GeneralSettingsService generalSettingsService() {
        return this.generalSettingsService;
    }

    public XldNotificationStore xldNotificationStore() {
        return this.xldNotificationStore;
    }

    public UserTokenService userTokenService() {
        return this.userTokenService;
    }

    public Logger logger() {
        return this.logger;
    }

    public void handlePatNotificationForExpiredToken() {
        Instant startTime = Instant.now();
        this.logger().info("PAT :: Starting PAT notification job at " + startTime);
        GeneralSettings generalSettings = this.generalSettingsService().getGeneralSettings();
        if (generalSettings != null && generalSettings.patEmailNotificationEnabled()) {
            int page = 1;
            IntRef totalProcessed = IntRef.create((int)0);
            int pageSize = 100;
            boolean hasMorePages = true;
            while (hasMorePages) {
                List<XldUserToken> tokens = this.getTokensExpiringInDays(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(generalSettings.patEmailNotificationTriggerPeriod())), new Paging(page, pageSize));
                if (tokens == null || tokens.size() == 0) {
                    hasMorePages = false;
                    continue;
                }
                ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(tokens).asScala().flatMap((Function1 & Serializable)userToken -> userToken.tokens().map((Function1 & Serializable)token -> new Tuple2((Object)userToken.username(), token)))).foreach((Function1 & Serializable)x0$1 -> {
                    PatNotificationService.$anonfun$handlePatNotificationForExpiredToken$3(this, totalProcessed, x0$1);
                    return BoxedUnit.UNIT;
                });
                if (tokens.size() < pageSize) {
                    hasMorePages = false;
                    continue;
                }
                ++page;
            }
            this.logger().info("PAT :: Event triggered to send email notifications for " + totalProcessed.elem + " expiring tokens");
            Instant endTime = Instant.now();
            long durationMillis = Duration.between(startTime, endTime).toMillis();
            this.logger().info("PAT :: PAT notification job completed at " + endTime + ". Duration: " + durationMillis + "ms");
            return;
        }
        this.logger().info("PAT :: PAT notification is not enabled in configuration, skipping notification check");
    }

    public List<XldUserToken> getTokensExpiringInDays(int notifiedDays, Paging paging) {
        return this.userTokenService().listTokensExpiringInDays(notifiedDays, paging);
    }

    private void updateTokenExpiredNotified(Integer cid) {
        this.userTokenService().updateTokenExpiredNotified(Predef$.MODULE$.Integer2int(cid), (Date)Timestamp.from(Instant.now()), true);
    }

    private UserTokens convertUserTokenToToken(Tokens tokens) {
        return new UserTokens(tokens.createdDate(), tokens.lastUsedDate(), tokens.expiryDate(), tokens.tokenNote(), tokens.tokenHash(), tokens.ciId());
    }

    public static final /* synthetic */ void $anonfun$handlePatNotificationForExpiredToken$3(PatNotificationService $this, IntRef totalProcessed$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String username = (String)tuple2._1();
            Tokens token = (Tokens)tuple2._2();
            $this.xldNotificationStore().handlePatNotificationEvent(new UserTokenAboutToExpireEvent(username, $this.convertUserTokenToToken(token)));
            $this.updateTokenExpiredNotified(token.ciId());
            ++totalProcessed$1.elem;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public PatNotificationService(@Autowired GeneralSettingsService generalSettingsService, @Autowired XldNotificationStore xldNotificationStore, @Autowired UserTokenService userTokenService) {
        this.generalSettingsService = generalSettingsService;
        this.xldNotificationStore = xldNotificationStore;
        this.userTokenService = userTokenService;
        this.logger = LoggerFactory.getLogger(PatNotificationService.class);
    }
}

