/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.task.archive.SuccessfulDeploymentDurationReportLine;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.util.Collection;
import org.joda.time.DateTime;

public class DeploymentsDurationFrequencyWidget
extends DashboardWidgetBase {
    private static final String INTERVAL = "interval";
    private static final String DEPLOYMENT_PERCENT = "deploymentPercent";
    private static final String NUM_OF_DEPLOYMENT = "numOfDeployment";

    public DeploymentsDurationFrequencyWidget(TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime beginDate, DateTime endDate) {
        Collection searchResult = this.taskArchive.successfulDeploymentDurations(beginDate, endDate);
        return this.transformResult(searchResult);
    }

    private Report transformResult(Collection<SuccessfulDeploymentDurationReportLine> searchResult) {
        Report report = new Report();
        searchResult.forEach(result -> {
            ReportLine line = report.addLine();
            if (result.binStart().isEmpty() && result.binEnd().isEmpty()) {
                line.addValue(INTERVAL, (Object)"All");
            } else if (result.binStart().isEmpty()) {
                line.addValue(INTERVAL, (Object)("<" + DeploymentsDurationFrequencyWidget.formatToMinsAndSecs(((Integer)result.binEnd().get()).intValue())));
            } else if (result.binEnd().isEmpty()) {
                line.addValue(INTERVAL, (Object)(">" + DeploymentsDurationFrequencyWidget.formatToMinsAndSecs(((Integer)result.binStart().get()).intValue())));
            } else {
                line.addValue(INTERVAL, (Object)(DeploymentsDurationFrequencyWidget.formatToMinsAndSecs(((Integer)result.binStart().get()).intValue()) + " - " + DeploymentsDurationFrequencyWidget.formatToMinsAndSecs(((Integer)result.binEnd().get()).intValue())));
            }
            line.addValue(DEPLOYMENT_PERCENT, (Object)DeploymentsDurationFrequencyWidget.getFormattedPercentage(result.amount(), result.count()));
            line.addValue(NUM_OF_DEPLOYMENT, (Object)String.valueOf(result.amount()));
        });
        return report;
    }
}

