/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditOverrideData;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.mapping.PersistentClass;

public class ClassAuditingData
implements AuditedPropertiesHolder {
    private final PersistentClass persistentClass;
    private final Map<String, PropertyAuditingData> properties;
    private final Map<String, String> secondaryTableDictionary;
    private AuditTable auditTable;
    private boolean defaultAudited;

    public ClassAuditingData(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
        this.properties = new HashMap<String, PropertyAuditingData>();
        this.secondaryTableDictionary = new HashMap<String, String>();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public void addPropertyAuditingData(String propertyName, PropertyAuditingData auditingData) {
        this.properties.put(propertyName, auditingData);
    }

    @Override
    public PropertyAuditingData getPropertyAuditingData(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public List<AuditOverrideData> getAuditingOverrides() {
        return Collections.emptyList();
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public String getEntityName() {
        return this.persistentClass.getEntityName();
    }

    public Iterable<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Map<String, String> getSecondaryTableDictionary() {
        return this.secondaryTableDictionary;
    }

    public AuditTable getAuditTable() {
        return this.auditTable;
    }

    public void setAuditTable(AuditTable auditTable) {
        this.auditTable = auditTable;
    }

    public void setDefaultAudited(boolean defaultAudited) {
        this.defaultAudited = defaultAudited;
    }

    public boolean isAudited() {
        return this.defaultAudited || this.properties.size() > 0;
    }

    @Override
    public boolean contains(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public Iterable<String> getNonSyntheticPropertyNames() {
        return this.properties.entrySet().stream().filter(e -> !((PropertyAuditingData)e.getValue()).isSynthetic()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Iterable<PropertyAuditingData> getSyntheticProperties() {
        return this.properties.values().stream().filter(PropertyAuditingData::isSynthetic).collect(Collectors.toList());
    }
}

