/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractToOneMapper;
import org.hibernate.envers.internal.entities.mapper.relation.ToOneEntityLoader;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class ToOneIdMapper
extends AbstractToOneMapper {
    private static final Logger log = Logger.getLogger(ToOneIdMapper.class);
    private final IdMapper delegate;
    private final String referencedEntityName;
    private final boolean nonInsertableFake;
    private final boolean lazyMapping;

    public ToOneIdMapper(IdMapper delegate, PropertyData propertyData, String referencedEntityName, boolean nonInsertableFake, boolean lazyMapping) {
        super(delegate.getServiceRegistry(), propertyData);
        this.delegate = delegate;
        this.referencedEntityName = referencedEntityName;
        this.nonInsertableFake = nonInsertableFake;
        this.lazyMapping = lazyMapping;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        HashMap<String, Object> newData = new HashMap<String, Object>();
        Object entity = this.nonInsertableFake ? oldObj : newObj;
        this.delegate.mapToMapFromEntity(newData, entity);
        for (Map.Entry<String, Object> entry : newData.entrySet()) {
            data.put(entry.getKey(), entry.getValue());
        }
        return this.checkModified(session, newObj, oldObj);
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        if (this.getPropertyData().isUsingModifiedFlag()) {
            data.put(this.getPropertyData().getModifiedFlagPropertyName(), this.checkModified(session, newObj, oldObj));
        }
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        if (this.getPropertyData().isUsingModifiedFlag()) {
            data.put(this.getPropertyData().getModifiedFlagPropertyName(), collectionPropertyName.equals(this.getPropertyData().getName()));
        }
    }

    protected boolean checkModified(SessionImplementor session, Object newObj, Object oldObj) {
        if (this.nonInsertableFake) {
            return false;
        }
        if (newObj == null || oldObj == null || newObj.getClass().equals(oldObj.getClass())) {
            return !EntityTools.entitiesEqual(session, this.referencedEntityName, newObj, oldObj);
        }
        EntityPersister persister = session.getFactory().getMappingMetamodel().getEntityDescriptor(this.referencedEntityName);
        Object resolvedNewObjectId = newObj;
        if (!persister.getIdentifierType().getReturnedClass().isInstance(newObj)) {
            resolvedNewObjectId = EntityTools.getIdentifier(session, this.referencedEntityName, newObj);
        }
        Object resolvedOldObjectId = oldObj;
        if (!persister.getIdentifierType().getReturnedClass().isInstance(oldObj)) {
            resolvedOldObjectId = EntityTools.getIdentifier(session, this.referencedEntityName, oldObj);
        }
        return !Objects.deepEquals(resolvedNewObjectId, resolvedOldObjectId);
    }

    @Override
    public void nullSafeMapToEntityFromMap(EnversService enversService, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        Object value = this.nullSafeMapToEntityFromMap(enversService, data, primaryKey, versionsReader, revision);
        this.setPropertyValue(obj, value);
    }

    @Override
    public Object nullSafeMapToEntityFromMap(EnversService enversService, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        Object entityId = this.delegate.mapToIdFromMap(data);
        Object value = null;
        if (entityId != null) {
            AbstractToOneMapper.EntityInfo referencedEntity;
            value = versionsReader.getFirstLevelCache().contains(this.referencedEntityName, revision, entityId) ? versionsReader.getFirstLevelCache().get(this.referencedEntityName, revision, entityId) : (this.isIgnoreNotFound(enversService, referencedEntity = this.getEntityInfo(enversService, this.referencedEntityName), data, primaryKey) ? ToOneEntityLoader.loadImmediate(versionsReader, referencedEntity.getEntityClass(), this.referencedEntityName, entityId, revision, RevisionType.DEL.equals(data.get(enversService.getConfig().getRevisionTypePropertyName())), enversService) : ToOneEntityLoader.createProxyOrLoadImmediate(versionsReader, referencedEntity.getEntityClass(), this.referencedEntityName, entityId, revision, RevisionType.DEL.equals(data.get(enversService.getConfig().getRevisionTypePropertyName())), enversService));
        }
        return value;
    }

    public void addMiddleEqualToQuery(Parameters parameters, String idPrefix1, String prefix1, String idPrefix2, String prefix2) {
        this.delegate.addNullableIdsEqualToQuery(parameters, prefix1, this.delegate, prefix2);
    }

    private boolean isIgnoreNotFound(EnversService enversService, AbstractToOneMapper.EntityInfo referencedEntity, Map data, Object primaryKey) {
        String referencingEntityName = enversService.getEntitiesConfigurations().getEntityNameForVersionsEntityName((String)data.get("$type$"));
        if (referencingEntityName == null && primaryKey == null) {
            return true;
        }
        return enversService.getEntitiesConfigurations().getRelationDescription(referencingEntityName, this.getPropertyData().getName()).isIgnoreNotFound();
    }
}

