/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.internal.InMemoryThreadPoolBulkheadRegistry;
import io.github.resilience4j.core.Registry;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public interface ThreadPoolBulkheadRegistry
extends Registry<ThreadPoolBulkhead, ThreadPoolBulkheadConfig>,
AutoCloseable {
    public static ThreadPoolBulkheadRegistry of(ThreadPoolBulkheadConfig bulkheadConfig) {
        return new InMemoryThreadPoolBulkheadRegistry(bulkheadConfig);
    }

    public static ThreadPoolBulkheadRegistry of(ThreadPoolBulkheadConfig bulkheadConfig, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
        return new InMemoryThreadPoolBulkheadRegistry(bulkheadConfig, registryEventConsumer);
    }

    public static ThreadPoolBulkheadRegistry of(ThreadPoolBulkheadConfig bulkheadConfig, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers) {
        return new InMemoryThreadPoolBulkheadRegistry(bulkheadConfig, registryEventConsumers);
    }

    public static ThreadPoolBulkheadRegistry ofDefaults() {
        return ThreadPoolBulkheadRegistry.ofDefaults(Collections.emptyMap());
    }

    public static ThreadPoolBulkheadRegistry ofDefaults(Map<String, String> tags) {
        return new InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig.ofDefaults(), tags);
    }

    public static ThreadPoolBulkheadRegistry of(Map<String, ThreadPoolBulkheadConfig> configs) {
        return ThreadPoolBulkheadRegistry.of(configs, Collections.emptyMap());
    }

    public static ThreadPoolBulkheadRegistry of(Map<String, ThreadPoolBulkheadConfig> configs, Map<String, String> tags) {
        return new InMemoryThreadPoolBulkheadRegistry(configs, tags);
    }

    public static ThreadPoolBulkheadRegistry of(Map<String, ThreadPoolBulkheadConfig> configs, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
        return ThreadPoolBulkheadRegistry.of(configs, registryEventConsumer, Collections.emptyMap());
    }

    public static ThreadPoolBulkheadRegistry of(Map<String, ThreadPoolBulkheadConfig> configs, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer, Map<String, String> tags) {
        return new InMemoryThreadPoolBulkheadRegistry(configs, registryEventConsumer, tags);
    }

    public static ThreadPoolBulkheadRegistry of(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers) {
        return ThreadPoolBulkheadRegistry.of(configs, registryEventConsumers, Collections.emptyMap());
    }

    public static ThreadPoolBulkheadRegistry of(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers, Map<String, String> tags) {
        return new InMemoryThreadPoolBulkheadRegistry(configs, registryEventConsumers, tags);
    }

    public Set<ThreadPoolBulkhead> getAllBulkheads();

    public ThreadPoolBulkhead bulkhead(String var1);

    public ThreadPoolBulkhead bulkhead(String var1, Map<String, String> var2);

    public ThreadPoolBulkhead bulkhead(String var1, ThreadPoolBulkheadConfig var2);

    public ThreadPoolBulkhead bulkhead(String var1, ThreadPoolBulkheadConfig var2, Map<String, String> var3);

    public ThreadPoolBulkhead bulkhead(String var1, Supplier<ThreadPoolBulkheadConfig> var2);

    public ThreadPoolBulkhead bulkhead(String var1, Supplier<ThreadPoolBulkheadConfig> var2, Map<String, String> var3);

    public ThreadPoolBulkhead bulkhead(String var1, String var2);

    public ThreadPoolBulkhead bulkhead(String var1, String var2, Map<String, String> var3);

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_CONFIG = "default";
        private RegistryStore<ThreadPoolBulkhead> registryStore;
        private Map<String, ThreadPoolBulkheadConfig> threadPoolBulkheadConfigsMap = new HashMap<String, ThreadPoolBulkheadConfig>();
        private List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers = new ArrayList<RegistryEventConsumer<ThreadPoolBulkhead>>();
        private Map<String, String> tags;

        public Builder withRegistryStore(RegistryStore<ThreadPoolBulkhead> registryStore) {
            this.registryStore = registryStore;
            return this;
        }

        public Builder withThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
            this.threadPoolBulkheadConfigsMap.put(DEFAULT_CONFIG, threadPoolBulkheadConfig);
            return this;
        }

        public Builder addThreadPoolBulkheadConfig(String configName, ThreadPoolBulkheadConfig configuration) {
            if (configName.equals(DEFAULT_CONFIG)) {
                throw new IllegalArgumentException("You cannot add another configuration with name 'default' as it is preserved for default configuration");
            }
            this.threadPoolBulkheadConfigsMap.put(configName, configuration);
            return this;
        }

        public Builder addRegistryEventConsumer(RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
            this.registryEventConsumers.add(registryEventConsumer);
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public ThreadPoolBulkheadRegistry build() {
            return new InMemoryThreadPoolBulkheadRegistry(this.threadPoolBulkheadConfigsMap, this.registryEventConsumers, this.tags, this.registryStore);
        }
    }
}

