/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;

public class ClientCallableStatement
extends ClientPreparedStatement
implements PreparedStatement,
CallableStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialCallableStatement_ = null;
    private int wasNull_ = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;

    private void initCallableStatement() {
        this.materialCallableStatement_ = null;
        this.wasNull_ = 0;
    }

    @Override
    public void reset(boolean bl) throws SqlException {
        if (bl) {
            this.connection_.resetPrepareCall(this);
        } else {
            super.reset(bl);
        }
        this.wasNull_ = 0;
    }

    public ClientCallableStatement(Agent agent, ClientConnection clientConnection, String string, int n, int n2, int n3, ClientPooledConnection clientPooledConnection) throws SqlException {
        super(agent, clientConnection, string, n, n2, n3, 2, null, null, clientPooledConnection);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, ClientConnection clientConnection, String string, int n, int n2, int n3) throws SqlException {
        super.resetPreparedStatement(agent, clientConnection, string, n, n2, n3, 2, null, null);
        this.initCallableStatement();
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize", new Object[0]);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearParameters", new Object[0]);
            }
            super.clearParameters();
            this.outputRegistered_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "registerOutParameter", n, n2);
                }
                this.registerOutParameterX(n, n2);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void registerOutParameterX(int n, int n2) throws SqlException {
        super.checkForClosedStatement();
        int n3 = 0;
        this.registerOutParameterX(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "registerOutParameter", n, n2, n3);
                }
                super.checkForClosedStatement();
                this.registerOutParameterX(n, n2, n3);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void registerOutParameterX(int n, int n2, int n3) throws SqlException {
        super.checkForValidParameterIndex(n);
        this.agent_.checkForSupportedDataType(n2);
        this.checkForValidScale(n3);
        this.outputRegistered_ = true;
        this.parameterRegistered_[n - 1] = true;
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", n, n2, string);
        }
        this.registerOutParameter(n, n2);
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "wasNull", new Object[0]);
            }
            boolean bl = this.wasNullX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "wasNull", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean wasNullX() throws SqlException {
        super.checkForClosedStatement();
        if (this.wasNull_ == 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ088.S"), new Object[0]);
        }
        return this.wasNull_ == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                boolean bl;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBoolean", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                boolean bl2 = bl = this.wasNullX() ? false : this.singletonRowData_.getBoolean(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBoolean", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                byte by;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getByte", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                byte by2 = by = this.wasNullX() ? (byte)0 : this.singletonRowData_.getByte(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getByte", by);
                }
                return by;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                short s;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getShort", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                short s2 = s = this.wasNullX() ? (short)0 : this.singletonRowData_.getShort(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getShort", s);
                }
                return s;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getInt", n);
                }
                int n2 = this.getIntX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getInt", n2);
                }
                return n2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    int getIntX(int n) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? 0 : this.singletonRowData_.getInt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getLong", n);
                }
                long l = this.getLongX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLong", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    long getLongX(int n) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? 0L : this.singletonRowData_.getLong(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                float f;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getFloat", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                float f2 = f = this.wasNullX() ? 0.0f : this.singletonRowData_.getFloat(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getFloat", Float.valueOf(f));
                }
                return f;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                double d;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getDouble", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                double d2 = d = this.wasNullX() ? 0.0 : this.singletonRowData_.getDouble(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDouble", d);
                }
                return d;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException, ArithmeticException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                BigDecimal bigDecimal;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedEntry(this, "getBigDecimal", n, n2);
                }
                super.checkForClosedStatement();
                this.checkForValidScale(n2);
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                BigDecimal bigDecimal2 = bigDecimal = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(n);
                if (bigDecimal != null) {
                    bigDecimal = bigDecimal.setScale(n2, 1);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedExit(this, "getBigDecimal", bigDecimal);
                }
                return bigDecimal;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                BigDecimal bigDecimal;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBigDecimal", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                BigDecimal bigDecimal2 = bigDecimal = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", bigDecimal);
                }
                return bigDecimal;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Date date;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getDate", n, calendar);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(n);
                Date date2 = date = this.wasNullX() ? null : this.singletonRowData_.getDate(n, calendar);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
                }
                return date;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalDate getLocalDate(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                LocalDate localDate;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getLocalDate", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                LocalDate localDate2 = localDate = this.wasNullX() ? null : this.singletonRowData_.getLocalDate(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLocalDate", localDate);
                }
                return localDate;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDate(n, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Time time;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTime", n, calendar);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(n);
                Time time2 = time = this.wasNullX() ? null : this.singletonRowData_.getTime(n, calendar);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
                }
                return time;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTime(n, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalTime getLocalTime(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                LocalTime localTime;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getLocalTime", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                LocalTime localTime2 = localTime = this.wasNullX() ? null : this.singletonRowData_.getLocalTime(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLocalTime", localTime);
                }
                return localTime;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Timestamp timestamp;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTimestamp", n, calendar);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(n);
                Timestamp timestamp2 = timestamp = this.wasNullX() ? null : this.singletonRowData_.getTimestamp(n, calendar);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
                }
                return timestamp;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalDateTime getLocalDateTime(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                LocalDateTime localDateTime;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getLocalDateTime", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                LocalDateTime localDateTime2 = localDateTime = this.wasNullX() ? null : this.singletonRowData_.getLocalDateTime(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLocalDateTime", localDateTime);
                }
                return localDateTime;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getString", n);
                }
                String string = this.getStringX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getString", string);
                }
                return string;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    String getStringX(int n) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? null : this.singletonRowData_.getString(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBytes", n);
                }
                byte[] byArray = this.getBytesX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
                }
                return byArray;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    byte[] getBytesX(int n) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? null : this.singletonRowData_.getBytes(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Blob blob;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBlob", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Blob blob2 = blob = this.wasNullX() ? null : this.singletonRowData_.getBlob(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBlob", blob);
                }
                return blob;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Clob clob;
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Clob clob2 = clob = this.wasNullX() ? null : this.singletonRowData_.getClob(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getClob", clob);
                }
                return clob;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Array getArray(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getArray", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Array array = this.wasNullX() ? null : this.singletonRowData_.getArray(n);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getRef", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Ref ref = this.wasNullX() ? null : this.singletonRowData_.getRef(n);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Object object;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getObject", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Object object2 = object = this.wasNullX() ? null : this.singletonRowData_.getObject(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getObject", object);
                }
                return object;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getObject", n, map);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", string, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", string, n, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", string, n, string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public URL getURL(int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getURL", n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setURL", string, uRL);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setNull", string, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBoolean", string, bl);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setByte", string, by);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setShort", string, s);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setInt", string, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setLong", string, l);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setFloat", string, Float.valueOf(f));
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDouble", string, d);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBigDecimal", string, bigDecimal);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setString", string, string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBytes", string, byArray);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDate", string, date);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTime", string, time);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTimestamp", string, timestamp);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setAsciiStream", string, inputStream, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBinaryStream", string, inputStream, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", string, object, n, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", string, object, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", string, object);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setCharacterStream", string, reader, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDate", string, date, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTime", string, time, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTimestamp", string, timestamp, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setNull", string, n, string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public String getString(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getString", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBoolean", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getByte", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public short getShort(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getShort", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public int getInt(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getInt", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public long getLong(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getLong", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getFloat", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDouble", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBytes", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Date getDate(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDate", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Time getTime(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTime", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTimestamp", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Object getObject(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getObject", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBigDecimal", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getObject", string, map);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getRef", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBlob", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getClob", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getArray", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDate", string, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTime", string, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTimestamp", string, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getURL", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCharacterStream", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Reader reader = null;
                if (this.wasNull_ == 2) {
                    reader = this.singletonRowData_.getCharacterStream(n);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
                }
                return reader;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setAsciiStream(String,InputStream,long)");
    }

    @Override
    public final void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBinaryStream(String,InputStream,long)");
    }

    @Override
    public final void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setCharacterStream(String,Reader,long)");
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getCharacterStream(String)");
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(String)");
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(int)");
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(String)");
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (int)");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (String)");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setRowId (String, RowId)");
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob(String, Blob)");
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob(String, Clob)");
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNString (String, String)");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNString (String, Reader, long)");
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String, NClob)");
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob (String, Reader, long)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob (String, InputStream, long)");
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String, Reader, long)");
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (int)");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String)");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setSQLXML (String, SQLXML)");
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (int)");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (String)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setAsciiStream(String,InputStream)");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBinaryStream(String,InputStream)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob(String,InputStream)");
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setCharacterStream(String,Reader)");
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob(String,Reader)");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNCharacterStream(String,Reader)");
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob(String,Reader)");
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        if (clazz == null) {
            throw this.mismatchException("NULL", n);
        }
        Object object = String.class.equals(clazz) ? this.getString(n) : (BigDecimal.class.equals(clazz) ? this.getBigDecimal(n) : (Boolean.class.equals(clazz) ? Boolean.valueOf(this.getBoolean(n)) : (Byte.class.equals(clazz) ? Byte.valueOf(this.getByte(n)) : (Short.class.equals(clazz) ? Short.valueOf(this.getShort(n)) : (Integer.class.equals(clazz) ? Integer.valueOf(this.getInt(n)) : (Long.class.equals(clazz) ? Long.valueOf(this.getLong(n)) : (Float.class.equals(clazz) ? Float.valueOf(this.getFloat(n)) : (Double.class.equals(clazz) ? Double.valueOf(this.getDouble(n)) : (Date.class.equals(clazz) ? this.getDate(n) : (LocalDate.class.equals(clazz) ? this.getLocalDate(n) : (Time.class.equals(clazz) ? this.getTime(n) : (LocalTime.class.equals(clazz) ? this.getLocalTime(n) : (Timestamp.class.equals(clazz) ? this.getTimestamp(n) : (LocalDateTime.class.equals(clazz) ? this.getLocalDateTime(n) : (Blob.class.equals(clazz) ? this.getBlob(n) : (Clob.class.equals(clazz) ? this.getClob(n) : (clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(n) : this.getObject(n))))))))))))))))));
        if (this.wasNull()) {
            object = null;
        }
        if (object == null || clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw this.mismatchException(clazz.getName(), n);
    }

    private SQLException mismatchException(String string, int n) throws SQLException {
        String string2 = this.getParameterMetaData().getParameterTypeName(n);
        ClientMessageId clientMessageId = new ClientMessageId("22005");
        SqlException sqlException = new SqlException(this.agent_.logWriter_, clientMessageId, string, string2);
        return sqlException.getSQLException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void completeExecuteCall(Sqlca sqlca, Cursor cursor) {
        super.completeExecuteCall(sqlca, cursor);
        if (cursor == null) {
            return;
        }
        if (this.parameterMetaData_ == null) {
            return;
        }
        int n = cursor.columns_;
        for (int i = 0; i < n; ++i) {
            Object object;
            if (this.parameterMetaData_.sqlxParmmode_[i] != 2) continue;
            int n2 = i + 1;
            try {
                object = cursor.isNull_[i] ? null : cursor.getObject(n2);
            }
            catch (SqlException sqlException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(sqlException.getMessage());
                illegalArgumentException.initCause(sqlException);
                throw illegalArgumentException;
            }
            if (this.parameterMetaData_.types_[i] == 5 && object instanceof Integer) {
                object = ((Integer)object).shortValue();
            }
            this.setInput(n2, object);
        }
    }

    @Override
    protected String getJdbcStatementInterfaceName() {
        return "java.sql.CallableStatement";
    }

    private void checkGetterPreconditions(int n) throws SqlException {
        super.checkForValidParameterIndex(n);
        this.checkForValidOutParameter(n);
    }

    private void checkForValidOutParameter(int n) throws SqlException {
        if (this.parameterMetaData_ == null || this.parameterMetaData_.sqlxParmmode_[n - 1] < 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ091.S"), n);
        }
    }

    private void setWasNull(int n) {
        this.wasNull_ = this.singletonRowData_ == null ? 0 : (this.singletonRowData_.isNull_[n - 1] ? 1 : 2);
    }

    SQLException jdbcMethodNotImplemented() throws SQLException {
        try {
            super.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]).getSQLException();
    }
}

