/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.util.ClassNameUtil;
import org.jboss.windup.util.exception.WindupException;

public class PathUtil {
    private static final Logger LOG = Logger.getLogger(PathUtil.class.getName());
    public static final String WINDUP_HOME = "windup.home";
    public static final String WINDUP_RULESETS_DIR_SYSPROP = "windup.rulesets.dir";
    public static final String WINDUP_LABELSETS_DIR_SYSPROP = "windup.labelsets.dir";
    public static final String RULES_DIRECTORY_NAME = "rules";
    public static final String LABELS_DIRECTORY_NAME = "labels";
    public static final String IGNORE_DIRECTORY_NAME = "ignore";
    public static final String CACHE_DIRECTORY_NAME = "cache";
    public static final String ADDONS_DIRECTORY_NAME = "addons";
    public static String LIBRARY_DIRECTORY_NAME = "lib";
    public static String BINARY_DIRECTORY_NAME = "bin";

    public static Path getWindupUserDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            Path path = new File("").toPath();
            LOG.warning("$USER_HOME not set, using [" + path.toAbsolutePath().toString() + "] instead.");
            return path;
        }
        return Paths.get(userHome, new String[0]).resolve(".windup");
    }

    public static Path getWindupHome() {
        String windupHome = System.getProperty(WINDUP_HOME);
        if (windupHome == null) {
            Path path = new File("").toPath();
            LOG.warning("$WINDUP_HOME not set, using [" + path.toAbsolutePath().toString() + "] instead.");
            return path;
        }
        return Paths.get(windupHome, new String[0]);
    }

    public static void setWindupHome(Path windupHome) {
        System.setProperty(WINDUP_HOME, windupHome.toAbsolutePath().toString());
    }

    public static Path getUserCacheDir() {
        return PathUtil.getUserSubdirectory(CACHE_DIRECTORY_NAME);
    }

    public static Path getWindupCacheDir() {
        return PathUtil.getWindupSubdirectory(CACHE_DIRECTORY_NAME);
    }

    public static Path getUserIgnoreDir() {
        return PathUtil.getUserSubdirectory(IGNORE_DIRECTORY_NAME);
    }

    public static Path getWindupIgnoreDir() {
        return PathUtil.getWindupSubdirectory(IGNORE_DIRECTORY_NAME);
    }

    public static Path getWindupAddonsDir() {
        return PathUtil.getWindupSubdirectory(ADDONS_DIRECTORY_NAME);
    }

    public static Path getUserRulesDir() {
        return PathUtil.getUserSubdirectory(RULES_DIRECTORY_NAME);
    }

    public static Path getUserLabelsDir() {
        return PathUtil.getUserSubdirectory(LABELS_DIRECTORY_NAME);
    }

    public static Path getWindupRulesDir() {
        String rulesDir = System.getProperty(WINDUP_RULESETS_DIR_SYSPROP);
        if (rulesDir != null) {
            Path path = Paths.get(rulesDir, new String[0]);
            if (!path.toFile().exists()) {
                LOG.warning("windup.rulesets.dir points to a non-existent directory!" + path.toAbsolutePath().toString());
            }
            return path;
        }
        return PathUtil.getWindupSubdirectory(RULES_DIRECTORY_NAME);
    }

    public static Path getWindupLabelsDir() {
        String labelsDir = System.getProperty(WINDUP_LABELSETS_DIR_SYSPROP);
        if (labelsDir != null) {
            Path path = Paths.get(labelsDir, new String[0]);
            if (!path.toFile().exists()) {
                LOG.warning("windup.labelsets.dir points to a non-existent directory!" + path.toAbsolutePath().toString());
            }
            return path;
        }
        return PathUtil.getWindupSubdirectory(LABELS_DIRECTORY_NAME);
    }

    public static String cleanFileName(String badFileName) {
        if (badFileName == null) {
            return null;
        }
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < badFileName.length(); ++i) {
            char c = badFileName.charAt(i);
            if (Character.isJavaIdentifierPart((int)c)) {
                cleanName.append(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString();
    }

    public static String classFilePathToClassname(String relativePath) {
        if (relativePath == null) {
            return null;
        }
        int pos = relativePath.lastIndexOf(".class");
        if (pos < 0 && relativePath.lastIndexOf(".java") < 0) {
            throw new IllegalArgumentException("Not a .class/.java file path: " + relativePath);
        }
        if ((relativePath = FilenameUtils.separatorsToUnix((String)relativePath)).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.startsWith("src/main/java/")) {
            relativePath = relativePath.substring("src/main/java/".length());
        }
        if (relativePath.startsWith("WEB-INF/classes/")) {
            relativePath = relativePath.substring("WEB-INF/classes/".length());
        }
        if (relativePath.startsWith("WEB-INF/classes.jdk15/")) {
            relativePath = relativePath.substring("WEB-INF/classes.jdk15/".length());
        }
        if (relativePath.endsWith(".class")) {
            relativePath = relativePath.substring(0, relativePath.length() - ".class".length());
        } else if (relativePath.endsWith(".java")) {
            relativePath = relativePath.substring(0, relativePath.length() - ".java".length());
        }
        String qualifiedName = relativePath.replace("/", ".");
        return qualifiedName;
    }

    public static Path getRootFolderForSource(Path sourceFilePath, String packageName) {
        if (packageName == null || packageName.trim().isEmpty()) {
            return sourceFilePath.getParent();
        }
        String[] packageNameComponents = packageName.split("\\.");
        Path currentPath = sourceFilePath.getParent();
        for (int i = packageNameComponents.length; i > 0; --i) {
            String packageComponent = packageNameComponents[i - 1];
            if (!StringUtils.equals((CharSequence)packageComponent, (CharSequence)currentPath.getFileName().toString())) {
                return null;
            }
            currentPath = currentPath.getParent();
        }
        return currentPath;
    }

    public static boolean isInSubDirectory(File dir, File file) {
        if (file == null) {
            return false;
        }
        if (file.equals(dir)) {
            return true;
        }
        return PathUtil.isInSubDirectory(dir, file.getParentFile());
    }

    public static String pathToPackageName(String relativePath) {
        String qualifiedName = PathUtil.classFilePathToClassname(relativePath);
        return ClassNameUtil.getPackageName(qualifiedName);
    }

    public static void createDirectory(Path dir, String dirDesc) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new WindupException("Error creating " + dirDesc + " folder: " + dir.toString() + " due to: " + ex.getMessage(), ex);
        }
    }

    private static Path getUserSubdirectory(String subdirectory) {
        Path windupUserDir = PathUtil.getWindupUserDir();
        if (windupUserDir == null) {
            return null;
        }
        return windupUserDir.resolve(subdirectory);
    }

    private static Path getWindupSubdirectory(String subdirectory) {
        Path windupHome = PathUtil.getWindupHome();
        if (windupHome == null) {
            return null;
        }
        return windupHome.resolve(subdirectory);
    }
}

