/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.hibernate.InstantiationException;
import org.hibernate.Internal;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.type.spi.TypeBootstrapContext;

@Internal
public class TypeBeanInstanceProducer
implements BeanInstanceProducer,
TypeBootstrapContext {
    private final ConfigurationService configurationService;

    public TypeBeanInstanceProducer(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public <B> B produceBeanInstance(Class<B> beanType) {
        Constructor<B> bootstrapContextAwareConstructor = ReflectHelper.getConstructorOrNull(beanType, TypeBootstrapContext.class);
        if (bootstrapContextAwareConstructor != null) {
            try {
                return bootstrapContextAwareConstructor.newInstance(this);
            }
            catch (Exception e) {
                throw new InstantiationException("Could not instantiate type", beanType, e);
            }
        }
        Constructor<B> constructor = ReflectHelper.getConstructorOrNull(beanType, new Class[0]);
        if (constructor != null) {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new InstantiationException("Could not instantiate type", beanType, e);
            }
        }
        throw new InstantiationException("No appropriate constructor for type", beanType);
    }

    @Override
    public <B> B produceBeanInstance(String name, Class<B> beanType) {
        return this.produceBeanInstance(beanType);
    }

    @Override
    public Map<String, Object> getConfigurationSettings() {
        return this.configurationService.getSettings();
    }
}

