/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport;

import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3Q!\u0001\u0002\u0001\t!\u0011A#Q6lCB\u0013x\u000e^8d_2\u001cV\r\u001e;j]\u001e\u001c(BA\u0002\u0005\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\u0006\r\u00051!/Z7pi\u0016T\u0011aB\u0001\u0005C.\\\u0017m\u0005\u0002\u0001\u0013A\u0011!\"D\u0007\u0002\u0017)\tA\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000f\u0017\t1\u0011I\\=SK\u001aD\u0001\u0002\u0005\u0001\u0003\u0002\u0003\u0006IAE\u0001\u0007G>tg-[4\u0004\u0001A\u00111#G\u0007\u0002))\u0011\u0001#\u0006\u0006\u0003-]\t\u0001\u0002^=qKN\fg-\u001a\u0006\u00021\u0005\u00191m\\7\n\u0005i!\"AB\"p]\u001aLw\rC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0003=\u0001\u0002\"a\b\u0001\u000e\u0003\tAQ\u0001E\u000eA\u0002IAqA\t\u0001C\u0002\u0013\u00051%\u0001\u0010Ue\u0006t7\u000f]8si\u001a\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u001cuN\u001c4jOV\t!\u0003\u0003\u0004&\u0001\u0001\u0006IAE\u0001 )J\fgn\u001d9peR4\u0015-\u001b7ve\u0016$U\r^3di>\u00148i\u001c8gS\u001e\u0004\u0003bB\u0014\u0001\u0005\u0004%\t\u0001K\u0001,)J\fgn\u001d9peR4\u0015-\u001b7ve\u0016$U\r^3di>\u0014\u0018*\u001c9mK6,g\u000e^1uS>t7\t\\1tgV\t\u0011\u0006\u0005\u0002+c9\u00111f\f\t\u0003Y-i\u0011!\f\u0006\u0003]E\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019\f\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005AZ\u0001BB\u001b\u0001A\u0003%\u0011&\u0001\u0017Ue\u0006t7\u000f]8si\u001a\u000b\u0017\u000e\\;sK\u0012+G/Z2u_JLU\u000e\u001d7f[\u0016tG/\u0019;j_:\u001cE.Y:tA!9q\u0007\u0001b\u0001\n\u0003A\u0014A\u0007+sC:\u001c\bo\u001c:u\u0011\u0016\f'\u000f\u001e\"fCRLe\u000e^3sm\u0006dW#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005yZ\u0011AC2p]\u000e,(O]3oi&\u0011\u0001i\u000f\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011\u0019\u0011\u0005\u0001)A\u0005s\u0005YBK]1ogB|'\u000f\u001e%fCJ$()Z1u\u0013:$XM\u001d<bY\u0002Bq\u0001\u0012\u0001C\u0002\u0013\u0005Q)A\u0007SKF,\u0018N]3D_>\\\u0017.Z\u000b\u0002\rB\u0011!bR\u0005\u0003\u0011.\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004K\u0001\u0001\u0006IAR\u0001\u000f%\u0016\fX/\u001b:f\u0007>|7.[3!\u0011\u001da\u0005A1A\u0005\u00025\u000bAbU3dkJ,7i\\8lS\u0016,\u0012A\u0014\t\u0004\u0015=K\u0013B\u0001)\f\u0005\u0019y\u0005\u000f^5p]\"1!\u000b\u0001Q\u0001\n9\u000bQbU3dkJ,7i\\8lS\u0016\u0004\u0003b\u0002+\u0001\u0005\u0004%\t\u0001O\u0001\u0011\u0011\u0006tGm\u001d5bW\u0016$\u0016.\\3pkRDaA\u0016\u0001!\u0002\u0013I\u0014!\u0005%b]\u0012\u001c\b.Y6f)&lWm\\;uA\u0001")
public class AkkaProtocolSettings {
    private final Config TransportFailureDetectorConfig;
    private final String TransportFailureDetectorImplementationClass;
    private final FiniteDuration TransportHeartBeatInterval;
    private final boolean RequireCookie;
    private final Option<String> SecureCookie;
    private final FiniteDuration HandshakeTimeout;

    public Config TransportFailureDetectorConfig() {
        return this.TransportFailureDetectorConfig;
    }

    public String TransportFailureDetectorImplementationClass() {
        return this.TransportFailureDetectorImplementationClass;
    }

    public FiniteDuration TransportHeartBeatInterval() {
        return this.TransportHeartBeatInterval;
    }

    public boolean RequireCookie() {
        return this.RequireCookie;
    }

    public Option<String> SecureCookie() {
        return this.SecureCookie;
    }

    public FiniteDuration HandshakeTimeout() {
        return this.HandshakeTimeout;
    }

    public AkkaProtocolSettings(Config config) {
        this.TransportFailureDetectorConfig = config.getConfig("akka.remote.transport-failure-detector");
        this.TransportFailureDetectorImplementationClass = this.TransportFailureDetectorConfig().getString("implementation-class");
        this.TransportHeartBeatInterval = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.TransportFailureDetectorConfig()), "heartbeat-interval")), (Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.$greater((Object)Duration$.MODULE$.Zero())), (Function0 & java.io.Serializable & Serializable)() -> "transport-failure-detector.heartbeat-interval must be > 0");
        this.RequireCookie = config.getBoolean("akka.remote.require-cookie");
        this.SecureCookie = this.RequireCookie() ? new Some((Object)config.getString("akka.remote.secure-cookie")) : None$.MODULE$;
        List enabledTransports = config.getStringList("akka.remote.enabled-transports");
        this.HandshakeTimeout = enabledTransports.contains("akka.remote.netty.tcp") ? Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "akka.remote.netty.tcp.connection-timeout") : (enabledTransports.contains("akka.remote.netty.ssl") ? Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "akka.remote.netty.ssl.connection-timeout") : (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "akka.remote.handshake-timeout")), (Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.$greater((Object)Duration$.MODULE$.Zero())), (Function0 & java.io.Serializable & Serializable)() -> "handshake-timeout must be > 0"));
    }
}

