/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.t2bus;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nl.javadude.t2bus.BusError;
import nl.javadude.t2bus.VetoException;

public class EventHandler {
    private final Object target;
    private final Method method;
    private boolean vetoer;

    EventHandler(Object target, Method method) {
        this(target, method, false);
    }

    EventHandler(Object target, Method method, boolean vetoer) {
        Preconditions.checkNotNull((Object)target, (Object)"EventHandler target cannot be null.");
        Preconditions.checkNotNull((Object)method, (Object)"EventHandler method cannot be null.");
        Preconditions.checkState((vetoer || !Lists.newArrayList((Object[])method.getExceptionTypes()).contains(VetoException.class) ? 1 : 0) != 0, (String)"Method %s is not annotated as veto-er, but throws VetoExceptions", (Object[])new Object[]{method.getName()});
        this.target = target;
        this.method = method;
        this.vetoer = vetoer;
        method.setAccessible(true);
    }

    public void handleEvent(Object event) throws InvocationTargetException, VetoException {
        try {
            this.method.invoke(this.target, event);
        }
        catch (IllegalArgumentException e) {
            throw new BusError("Method rejected target/argument: " + event, e);
        }
        catch (IllegalAccessException e) {
            throw new BusError("Method became inaccessible: " + event, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof VetoException) {
                throw (VetoException)e.getCause();
            }
            throw e;
        }
    }

    public boolean isVetoer() {
        return this.vetoer;
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return "[wrapper " + this.method + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        return (31 + this.method.hashCode()) * 31 + this.target.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventHandler other = (EventHandler)obj;
        return this.method.equals(other.method) && this.target == other.target;
    }
}

