/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import org.agrona.MutableDirectBuffer;

public class ErrorResponseFlyweight {
    private static final int OFFENDING_COMMAND_CORRELATION_ID_OFFSET = 0;
    private static final int ERROR_CODE_OFFSET = 8;
    private static final int ERROR_MESSAGE_OFFSET = 12;
    private MutableDirectBuffer buffer;
    private int offset;

    public final ErrorResponseFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public long offendingCommandCorrelationId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public ErrorResponseFlyweight offendingCommandCorrelationId(long correlationId) {
        this.buffer.putLong(this.offset + 0, correlationId);
        return this;
    }

    public ErrorCode errorCode() {
        return ErrorCode.get(this.buffer.getInt(this.offset + 8));
    }

    public ErrorResponseFlyweight errorCode(ErrorCode code) {
        this.buffer.putInt(this.offset + 8, code.value());
        return this;
    }

    public String errorMessage() {
        return this.buffer.getStringUtf8(this.offset + 12);
    }

    public ErrorResponseFlyweight errorMessage(String message) {
        this.buffer.putStringUtf8(this.offset + 12, message);
        return this;
    }

    public int length() {
        return this.buffer.getInt(this.offset + 12) + 12 + 4;
    }
}

