/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Long2ObjectHashMap<V>
implements Map<Long, V>,
Serializable {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private long[] keys;
    private Object[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Long2ObjectHashMap() {
        this(8, 0.55f, true);
    }

    public Long2ObjectHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, true);
    }

    public Long2ObjectHashMap(int initialCapacity, float loadFactor, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.keys = new long[capacity];
        this.values = new Object[capacity];
    }

    public Long2ObjectHashMap(Long2ObjectHashMap<V> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.shouldAvoidAllocation = mapToCopy.shouldAvoidAllocation;
        this.keys = (long[])mapToCopy.keys.clone();
        this.values = (Object[])mapToCopy.values.clone();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    public boolean containsKey(long key) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (null != value) {
            for (Object v : this.values) {
                if (!value.equals(v)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Long)key);
    }

    public V get(long key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index]) && key != this.keys[index]) {
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    public V computeIfAbsent(long key, LongFunction<? extends V> mappingFunction) {
        V value = this.get(key);
        if (value == null && (value = mappingFunction.apply(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public V put(Long key, V value) {
        return this.put((long)key, value);
    }

    @Override
    public V put(long key, V value) {
        Objects.requireNonNull(value, "Value cannot be null");
        Object oldValue = null;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != this.values[index]) {
            if (key == this.keys[index]) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (null == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Long)key);
    }

    public V remove(long key) {
        Object value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (null != (value = this.values[index])) {
            if (key == this.keys[index]) {
                this.values[index] = null;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return (V)value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.values, null);
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getLongKey()).append('=').append(entryIterator.getValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = this.values[i];
            if (null == thisValue || thisValue.equals(thatValue = that.get(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            result += Long.hashCode(this.keys[i]) ^ value.hashCode();
        }
        return result;
    }

    @Override
    public V replace(long key, V value) {
        V curValue = this.get(key);
        if (curValue != null) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(long key, V oldValue, V newValue) {
        V curValue = this.get(key);
        if (curValue == null || !Objects.equals(curValue, oldValue)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        long[] tempKeys = new long[newCapacity];
        Object[] tempValues = new Object[newCapacity];
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            long key = this.keys[i];
            int newHash = Hashing.hash(key, mask);
            while (null != tempValues[newHash]) {
                ++newHash;
                newHash &= mask;
            }
            tempKeys[newHash] = key;
            tempValues[newHash] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (null == this.values[index &= mask]) break;
            int hash = Hashing.hash(this.keys[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.values[index] = null;
            deleteIndex = index;
        }
    }

    public class EntryIterator
    extends AbstractIterator<Map.Entry<Long, V>>
    implements Map.Entry<Long, V> {
        @Override
        public Map.Entry<Long, V> next() {
            this.findNext();
            if (Long2ObjectHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Long, V> allocateDuplicateEntry() {
            final long k = this.getLongKey();
            final Object v = this.getValue();
            return new Map.Entry<Long, V>(){

                @Override
                public Long getKey() {
                    return k;
                }

                @Override
                public V getValue() {
                    return v;
                }

                @Override
                public V setValue(V value) {
                    return Long2ObjectHashMap.this.put(k, value);
                }

                @Override
                public int hashCode() {
                    return Long.hashCode(EntryIterator.this.getLongKey()) ^ v.hashCode();
                }

                @Override
                public boolean equals(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    return e.getKey() != null && e.getValue() != null && e.getKey().equals(k) && e.getValue().equals(v);
                }

                public String toString() {
                    return k + "=" + v;
                }
            };
        }

        @Override
        public Long getKey() {
            return this.getLongKey();
        }

        public long getLongKey() {
            return Long2ObjectHashMap.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Long2ObjectHashMap.this.values[this.position()];
        }

        @Override
        public V setValue(V value) {
            Objects.requireNonNull(value);
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int pos = this.position();
            Object oldValue = Long2ObjectHashMap.this.values[pos];
            ((Long2ObjectHashMap)Long2ObjectHashMap.this).values[pos] = value;
            return oldValue;
        }
    }

    public class KeyIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Long2ObjectHashMap.this.keys[this.position()];
        }
    }

    public class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Long2ObjectHashMap.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T>,
    Serializable {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Long2ObjectHashMap.this.values.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] values = Long2ObjectHashMap.this.values;
            int mask = values.length - 1;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (null == values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((Long2ObjectHashMap)Long2ObjectHashMap.this).values[position] = null;
            --Long2ObjectHashMap.this.size;
            Long2ObjectHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        final void reset() {
            int capacity;
            this.remaining = Long2ObjectHashMap.this.size;
            Object[] values = Long2ObjectHashMap.this.values;
            int i = capacity = values.length;
            if (null != values[capacity - 1]) {
                for (i = 0; i < capacity && null != values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<Long, V>>
    implements Serializable {
        private final EntryIterator entryIterator;

        EntrySet() {
            this.entryIterator = Long2ObjectHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = (Map.Entry)o;
            Object val = Long2ObjectHashMap.this.get(entry.getKey());
            return val != null && val.equals(entry.getValue());
        }
    }

    class ValueCollection
    extends AbstractCollection<V>
    implements Serializable {
        private final ValueIterator valueIterator;

        ValueCollection() {
            this.valueIterator = Long2ObjectHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }
    }

    public class KeySet
    extends AbstractSet<Long>
    implements Serializable {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Long2ObjectHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Long2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectHashMap.this.containsKey(o);
        }

        public boolean contains(long key) {
            return Long2ObjectHashMap.this.containsKey(key);
        }

        @Override
        public boolean remove(Object o) {
            return null != Long2ObjectHashMap.this.remove(o);
        }

        public boolean remove(long key) {
            return null != Long2ObjectHashMap.this.remove(key);
        }

        @Override
        public void clear() {
            Long2ObjectHashMap.this.clear();
        }
    }
}

