/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.annotation.InternalApi;
import akka.stream.impl.ResizableMultiReaderRingBuffer$NothingToReadException$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-e!B\u0013'\u0001)b\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011e\u0002!\u0011!Q\u0001\nYB\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\nqBaA\u0011\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0014\u0001\u0001\u0006IA\u000e\u0005\t\u0003S\u0001\u0001\u0015)\u0003\u0002,!9\u0011\u0011\u0007\u0001!B\u00131\u0004bBA\u001a\u0001\u0001\u0006KA\u000e\u0005\u0007\u0003k\u0001A\u0011\u0002:\t\r\u0005]\u0002\u0001\"\u0003s\u0011\u0019\tI\u0004\u0001C\u0001e\"9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA#\u0001\u0011\u0005\u0011Q\b\u0005\u0007\u0003\u000f\u0002A\u0011\u0001:\t\r\u0005%\u0003\u0001\"\u0001s\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003c\u0002A\u0011CA:\u0011\u001d\t)\b\u0001C!\u0003o:aa\u0010\u0014\t\u0002)\u0002eAB\u0013'\u0011\u0003Q\u0013\tC\u0003C5\u0011\u00051iB\u0003E5!\u0005QIB\u0003H5!\u0005\u0001\nC\u0003C;\u0011\u0005Q\fC\u0004_;\u0005\u0005I\u0011B0\u0007\u000f!T\u0002\u0013aI\u0001S\")!\b\tD\u0001U\u001a9qN\u0007I\u0001$\u0003\u0001\b\"B9#\r\u0003\u0011\b\"B:#\r\u0003!(A\b*fg&T\u0018M\u00197f\u001bVdG/\u001b*fC\u0012,'OU5oO\n+hMZ3s\u0015\t9\u0003&\u0001\u0003j[Bd'BA\u0015+\u0003\u0019\u0019HO]3b[*\t1&\u0001\u0003bW.\fWcA\u0017\u0002\u0010M\u0011\u0001A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0002\u0017%t\u0017\u000e^5bYNK'0Z\u0002\u0001!\tys'\u0003\u00029a\t\u0019\u0011J\u001c;\u0002\u000f5\f\u0007pU5{K\u000691-\u001e:t_J\u001cX#\u0001\u001f\u0011\u0005u\u0002cB\u0001 \u001a\u001b\u00051\u0013A\b*fg&T\u0018M\u00197f\u001bVdG/\u001b*fC\u0012,'OU5oO\n+hMZ3s!\tq$d\u0005\u0002\u001b]\u00051A(\u001b8jiz\"\u0012\u0001Q\u0001\u0017\u001d>$\b.\u001b8h)>\u0014V-\u00193Fq\u000e,\u0007\u000f^5p]B\u0011a)H\u0007\u00025\t1bj\u001c;iS:<Gk\u001c*fC\u0012,\u0005pY3qi&|gnE\u0002\u001e\u0013V\u0003\"A\u0013*\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(6\u0003\u0019a$o\\8u}%\t\u0011'\u0003\u0002Ra\u00059\u0001/Y2lC\u001e,\u0017BA*U\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|gN\u0003\u0002RaA\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\bG>tGO]8m\u0015\tQ\u0006'\u0001\u0003vi&d\u0017B\u0001/X\u00051qun\u0015;bG.$&/Y2f)\u0005)\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012\u0001\u0019\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fA\u0001\\1oO*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005\u0019y%M[3di\n91)\u001e:t_J\u001c8C\u0001\u0011/+\u0005Y\u0007c\u0001&m]&\u0011Q\u000e\u0016\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002GE\t11)\u001e:t_J\u001c\"A\t\u0018\u0002\r\r,(o]8s+\u00051\u0014AC2veN|'o\u0018\u0013fcR\u0011Q\u000f\u001f\t\u0003_YL!a\u001e\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006s\u0012\u0002\rAN\u0001\u0003SbD#AG>\u0011\u0005q|X\"A?\u000b\u0005yT\u0013AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011A?\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u00033m\f\u0001bY;sg>\u00148\u000f\t\u000b\t\u0003\u0013\t\t#a\t\u0002&A!a\bAA\u0006!\u0011\ti!a\u0004\r\u0001\u00119\u0011\u0011\u0003\u0001C\u0002\u0005M!!\u0001+\u0012\t\u0005U\u00111\u0004\t\u0004_\u0005]\u0011bAA\ra\t9aj\u001c;iS:<\u0007cA\u0018\u0002\u001e%\u0019\u0011q\u0004\u0019\u0003\u0007\u0005s\u0017\u0010C\u00035\u000b\u0001\u0007a\u0007C\u0003:\u000b\u0001\u0007a\u0007C\u0003;\u000b\u0001\u0007A(\u0001\u0006nCb\u001c\u0016N_3CSR\fQ!\u0019:sCf\u0004RaLA\u0017\u00037I1!a\f1\u0005\u0015\t%O]1z\u0003\u001d9(/\u001b;f\u0013b\faA]3bI&C\u0018A\u00027f]\nKG/\u0001\u0003nCN\\\u0017\u0001B:ju\u0016\fq![:F[B$\u00180\u0006\u0002\u0002@A\u0019q&!\u0011\n\u0007\u0005\r\u0003GA\u0004C_>dW-\u00198\u0002\u00119|g.R7qif\fA#[7nK\u0012L\u0017\r^3ms\u00063\u0018-\u001b7bE2,\u0017\u0001D7bq\u00063\u0018-\u001b7bE2,\u0017!B2pk:$Hc\u0001\u001c\u0002P!1\u0011/\u0005a\u0001\u0003#\u0002\"!\u0010\u0012\u0002\u0015%t\u0017\u000e^\"veN|'\u000fF\u0002v\u0003/Ba!\u001d\nA\u0002\u0005E\u0013!B<sSR,G\u0003BA \u0003;Bq!a\u0018\u0014\u0001\u0004\tY!A\u0003wC2,X-\u0001\u0003sK\u0006$G\u0003BA\u0006\u0003KBa!\u001d\u000bA\u0002\u0005E\u0013aD8o\u0007V\u00148o\u001c:SK6|g/\u001a3\u0015\u0007U\fY\u0007\u0003\u0004r+\u0001\u0007\u0011\u0011K\u0001\rkB$\u0017\r^3SK\u0006$\u0017\n\u001f\u000b\u0002k\u0006yQO\u001c3fe2L\u0018N\\4BeJ\f\u00170\u0006\u0002\u0002,\u0005AAo\\*ue&tw\r\u0006\u0002\u0002zA!\u00111PAB\u001d\u0011\ti(a \u0011\u00051\u0003\u0014bAAAa\u00051\u0001K]3eK\u001aLA!!\"\u0002\b\n11\u000b\u001e:j]\u001eT1!!!1Q\t\u00011\u0010")
@InternalApi
public class ResizableMultiReaderRingBuffer<T> {
    private final Cursors cursors;
    private final int maxSizeBit;
    private Object[] array;
    private int writeIx;
    private int readIx;

    public Cursors cursors() {
        return this.cursors;
    }

    private int lenBit() {
        return Integer.numberOfTrailingZeros(this.array.length);
    }

    private int mask() {
        return Integer.MAX_VALUE >> 31 - this.lenBit();
    }

    public int size() {
        return this.writeIx - this.readIx;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int immediatelyAvailable() {
        return this.array.length - this.size();
    }

    public int maxAvailable() {
        return (1 << this.maxSizeBit) - this.size();
    }

    public int count(Cursor cursor) {
        return this.writeIx - cursor.cursor();
    }

    public void initCursor(Cursor cursor) {
        cursor.cursor_$eq(this.readIx);
    }

    public boolean write(T value) {
        boolean bl;
        if (this.size() < this.array.length) {
            this.array[this.writeIx & this.mask()] = value;
            ++this.writeIx;
            bl = true;
        } else if (this.lenBit() < this.maxSizeBit) {
            int r = this.readIx & this.mask();
            Object[] newArray = new Object[this.array.length << 1];
            System.arraycopy(this.array, r, newArray, 0, this.array.length - r);
            System.arraycopy(this.array, 0, newArray, this.array.length - r, r);
            this.rebaseCursors$1(this.cursors().cursors());
            this.array = newArray;
            int w = this.size();
            this.array[w & this.mask()] = value;
            this.writeIx = w + 1;
            this.readIx = 0;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public T read(Cursor cursor) {
        void var3_3;
        int c = cursor.cursor();
        if (c - this.writeIx < 0) {
            cursor.cursor_$eq(cursor.cursor() + 1);
            Object ret = this.array[c & this.mask()];
            if (c == this.readIx) {
                this.updateReadIx();
            }
        } else {
            throw ResizableMultiReaderRingBuffer$NothingToReadException$.MODULE$;
        }
        return var3_3;
    }

    public void onCursorRemoved(Cursor cursor) {
        block0: {
            if (cursor.cursor() != this.readIx) break block0;
            this.updateReadIx();
        }
    }

    private void updateReadIx() {
        int newReadIx = this.writeIx + this.minCursor$1(this.cursors().cursors(), 0);
        while (this.readIx != newReadIx) {
            this.array[this.readIx & this.mask()] = null;
            ++this.readIx;
        }
    }

    public Object[] underlyingArray() {
        return this.array;
    }

    public String toString() {
        return new StringBuilder(66).append("ResizableMultiReaderRingBuffer(size=").append(this.size()).append(", writeIx=").append(this.writeIx).append(", readIx=").append(this.readIx).append(", cursors=").append(this.cursors().cursors().size()).append(")").toString();
    }

    private final void rebaseCursors$1(List remaining) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Cursor head = (Cursor)colon2.head();
            List tail = colon2.tl$access$1();
            head.cursor_$eq(head.cursor() - this.readIx);
            remaining = tail;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final int minCursor$1(List remaining, int result) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Cursor head = (Cursor)colon2.head();
            List tail = colon2.tl$access$1();
            result = package$.MODULE$.min(head.cursor() - this.writeIx, result);
            remaining = tail;
        }
        int n = result;
        return n;
    }

    public ResizableMultiReaderRingBuffer(int initialSize, int maxSize, Cursors cursors) {
        this.cursors = cursors;
        Predef$.MODULE$.require(Integer.lowestOneBit(maxSize) == maxSize && 0 < maxSize && maxSize <= 0x3FFFFFFF, (Function0 & java.io.Serializable & Serializable)() -> "maxSize must be a power of 2 that is > 0 and < Int.MaxValue/2");
        Predef$.MODULE$.require(Integer.lowestOneBit(initialSize) == initialSize && 0 < initialSize && initialSize <= maxSize, (Function0 & java.io.Serializable & Serializable)() -> "initialSize must be a power of 2 that is > 0 and <= maxSize");
        this.maxSizeBit = Integer.numberOfTrailingZeros(maxSize);
        this.array = new Object[initialSize];
        this.writeIx = 0;
        this.readIx = 0;
    }

    public static interface Cursor {
        public int cursor();

        public void cursor_$eq(int var1);
    }

    public static interface Cursors {
        public List<Cursor> cursors();
    }
}

