/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexingQueueStore {
    private static final Logger log = LoggerFactory.getLogger((Class)IndexingQueueStore.class);
    private static final String ENCODING = "UTF-8";
    private static final String ADD = "ADD";
    private static final String REMOVE = "REMOVE";
    private final Set pending = new HashSet();
    private final FileSystem fs;
    private final String fileName;

    IndexingQueueStore(FileSystem fs, String fileName) throws FileSystemException {
        this.fs = fs;
        this.fileName = fileName;
        this.readStore();
    }

    public String[] getPending() {
        return this.pending.toArray(new String[this.pending.size()]);
    }

    public void addUUID(String uuid) {
        this.pending.add(uuid);
    }

    public void removeUUID(String uuid) {
        this.pending.remove(uuid);
    }

    public void close() {
        if (this.pending.isEmpty()) {
            try {
                if (this.fs.exists(this.fileName)) {
                    this.fs.deleteFile(this.fileName);
                }
            }
            catch (FileSystemException e) {
                log.warn("unable to delete " + this.fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStore() throws FileSystemException {
        if (this.fs.exists(this.fileName)) {
            try {
                InputStream in = this.fs.getInputStream(this.fileName);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, ENCODING));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int idx = line.indexOf(32);
                        if (idx == -1) {
                            log.warn("invalid line in {}: {}", (Object)this.fileName, (Object)line);
                            continue;
                        }
                        String cmd = line.substring(0, idx);
                        String uuid = line.substring(idx + 1, line.length());
                        if (ADD.equals(cmd)) {
                            this.pending.add(uuid);
                            continue;
                        }
                        if (REMOVE.equals(cmd)) {
                            this.pending.remove(uuid);
                            continue;
                        }
                        log.warn("invalid line in {}: {}", (Object)this.fileName, (Object)line);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage(), e);
            }
        }
    }
}

