/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.MoreLikeThis;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class SimilarityQuery
extends Query {
    private final String uuid;
    private final Analyzer analyzer;

    public SimilarityQuery(String uuid, Analyzer analyzer) {
        this.uuid = uuid;
        this.analyzer = analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        MoreLikeThis more = new MoreLikeThis(reader);
        more.setAnalyzer(this.analyzer);
        more.setFieldNames(new String[]{FieldNames.FULLTEXT});
        more.setMinWordLen(4);
        Query similarityQuery = null;
        TermDocs td = reader.termDocs(new Term(FieldNames.UUID, this.uuid));
        try {
            if (td.next()) {
                similarityQuery = more.like(td.doc());
            }
        }
        finally {
            td.close();
        }
        if (similarityQuery != null) {
            return similarityQuery.rewrite(reader);
        }
        return new BooleanQuery();
    }

    public String toString(String field) {
        return "rep:similar(" + this.uuid + ")";
    }
}

