/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlList;
import org.apache.jackrabbit.core.security.authorization.UnmodifiableAccessControlList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlEntryIterator
implements Iterator {
    private static Logger log = LoggerFactory.getLogger((Class)AccessControlEntryIterator.class);
    private final List acls = new ArrayList();
    private Iterator currentEntries;
    private Object next;

    public AccessControlEntryIterator(List aces) {
        this(new AccessControlList[]{new UnmodifiableAccessControlList(aces)});
    }

    public AccessControlEntryIterator(AccessControlList[] acls) {
        for (int i = 0; i < acls.length; ++i) {
            this.acls.add(acls[i]);
        }
        this.next = this.seekNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Object ret = this.next;
        this.next = this.seekNext();
        return ret;
    }

    private Object seekNext() {
        while (this.currentEntries == null || !this.currentEntries.hasNext()) {
            if (this.acls.isEmpty()) {
                this.currentEntries = null;
                break;
            }
            AccessControlEntry[] entries = new AccessControlEntry[]{};
            try {
                entries = ((AccessControlList)this.acls.remove(0)).getAccessControlEntries();
            }
            catch (RepositoryException e) {
                log.error("Unable to retrieve ACEs: " + e.getMessage() + " -> try next.");
            }
            this.currentEntries = Arrays.asList(entries).iterator();
        }
        return this.currentEntries == null ? null : this.currentEntries.next();
    }
}

