/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsPowerPointTextExtractor
extends AbstractTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger((Class)MsPowerPointTextExtractor.class);

    public MsPowerPointTextExtractor() {
        super(new String[]{"application/vnd.ms-powerpoint", "application/mspowerpoint", "application/powerpoint"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            PowerPointExtractor extractor = new PowerPointExtractor(stream);
            StringReader stringReader = new StringReader(extractor.getText(true, true));
            return stringReader;
        }
        catch (RuntimeException e) {
            logger.warn("Failed to extract PowerPoint text content", (Throwable)e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ignored) {}
        }
    }

    static {
        POIFSReader.class.getName();
    }
}

