/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.engine.spi.event.PrincipalRoleAssignmentCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.PrincipalRoleAssignmentDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePrincipalsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleRenamedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\f\u0018\u0001\u0011B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\u0001\u0002!\t!\u0011\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u0019I\u0006\u0001)A\u0005-\"9!\f\u0001b\u0001\n\u0003Y\u0006B\u00024\u0001A\u0003%A\fC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002\u0012\u0001!\t%a\u0005\t\u000f\u0005E\u0001\u0001\"\u0011\u0002R!9\u00111\f\u0001\u0005B\u0005u\u0003bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003g\u0002A\u0011IA;\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!!!\u0001\t\u0003\ny\tC\u0004\u0002\u0002\u0002!I!a&\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003w\u0003A\u0011IA_\u0011\u001d\t\t\r\u0001C!\u0003\u0007Dq!!4\u0001\t\u0013\tyM\u0001\u0007S_2,'+Z:pkJ\u001cWM\u0003\u0002\u00193\u0005\u0019\u0011\r]5\u000b\u0005iY\u0012\u0001\u0002:fgRT!\u0001H\u000f\u0002\t\r|'/\u001a\u0006\u0003=}\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003A\u0005\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\t\n1aY8n\u0007\u0001\u0019B\u0001A\u0013,eA\u0011a%K\u0007\u0002O)\u0011\u0001&G\u0001\bg\u0016\u001cWO]3e\u0013\tQsEA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011A\u0006M\u0007\u0002[)\u0011\u0001D\f\u0006\u0003_u\ta!\u001a8hS:,\u0017BA\u0019.\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014!B:mMRR'\"A\u001c\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u000f\u001b\u0003\u000f1{wmZ5oO\u000691/\u001a:wS\u000e,\u0007C\u0001\u001f@\u001b\u0005i$B\u0001 \u001e\u0003!\u0019XmY;sSRL\u0018BA\u0019>\u0003\u0019a\u0014N\\5u}Q\u0011!\t\u0012\t\u0003\u0007\u0002i\u0011a\u0006\u0005\u0006u\t\u0001\ra\u000f\u0015\u0003\u0005\u0019\u0003\"a\u0012*\u000e\u0003!S!!\u0013&\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002L\u0019\u00069a-Y2u_JL(BA'O\u0003\u0015\u0011W-\u00198t\u0015\ty\u0005+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\t\u0016aA8sO&\u00111\u000b\u0013\u0002\n\u0003V$xn^5sK\u0012\f\u0011\u0002\u001a;p/JLG/\u001a:\u0016\u0003Y\u0003\"aQ,\n\u0005a;\"!\u0003#u_^\u0013\u0018\u000e^3s\u0003)!Go\\,sSR,'\u000fI\u0001\te\u0016\u001c\bo\u001c8tKV\tA\f\u0005\u0002^I6\taL\u0003\u0002`A\u0006\u00191\u000f]5\u000b\u0005\u0005\u0014\u0017\u0001\u0003:fgR,\u0017m]=\u000b\u0005\r\u0004\u0016!\u00026c_N\u001c\u0018BA3_\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u0003%\u0011Xm\u001d9p]N,\u0007\u0005\u000b\u0002\u0007QB\u0011\u0011.]\u0007\u0002U*\u0011Ad\u001b\u0006\u0003Y6\f!A]:\u000b\u00059|\u0017AA<t\u0015\u0005\u0001\u0018!\u00026bm\u0006D\u0018B\u0001:k\u0005\u001d\u0019uN\u001c;fqR\fa!\u001a=jgR\u001cHCA;|!\t1\u00180D\u0001x\u0015\u0005A\u0018!B:dC2\f\u0017B\u0001>x\u0005\u001d\u0011un\u001c7fC:DQ\u0001`\u0004A\u0002u\f\u0001B]8mK:\u000bW.\u001a\t\u0004}\u0006-abA@\u0002\bA\u0019\u0011\u0011A<\u000e\u0005\u0005\r!bAA\u0003G\u00051AH]8pizJ1!!\u0003x\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\b\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011B<\u0002\t1L7\u000f\u001e\u000b\u000b\u0003+\ty#a\r\u00028\u0005\u001d\u0003CBA\f\u0003C\t)#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u0011)H/\u001b7\u000b\u0005\u0005}\u0011\u0001\u00026bm\u0006LA!a\t\u0002\u001a\t!A*[:u!\u0011\t9#a\u000b\u000e\u0005\u0005%\"B\u0001 .\u0013\u0011\ti#!\u000b\u0003\tI{G.\u001a\u0005\u0007\u0003cA\u0001\u0019A?\u0002\u0005%$\u0007BBA\u001b\u0011\u0001\u0007Q0A\u0006s_2,\u0007+\u0019;uKJt\u0007bBA\u001d\u0011\u0001\u0007\u00111H\u0001\u0007a\u0006<\u0017N\\4\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011.\u0003\r!Go\\\u0005\u0005\u0003\u000b\nyD\u0001\u0004QC\u001eLgn\u001a\u0005\b\u0003\u0013B\u0001\u0019AA&\u0003\u0015y'\u000fZ3s!\u0011\ti$!\u0014\n\t\u0005=\u0013q\b\u0002\t\u001fJ$WM]5oORA\u00111KA+\u0003/\nI\u0006E\u0003\u0002\u0018\u0005\u0005R\u0010\u0003\u0004\u00026%\u0001\r! \u0005\b\u0003sI\u0001\u0019AA\u001e\u0011\u001d\tI%\u0003a\u0001\u0003\u0017\n1\u0002\\5ti6K(k\u001c7fgRA\u00111KA0\u0003C\n\u0019\u0007\u0003\u0004\u00026)\u0001\r! \u0005\b\u0003sQ\u0001\u0019AA\u001e\u0011\u001d\tIE\u0003a\u0001\u0003\u0017\n\u0011\u0002\\5tiJ{G.Z:\u0015\u0015\u0005M\u0013\u0011NA7\u0003_\n\t\b\u0003\u0004\u0002l-\u0001\r!`\u0001\tkN,'O\\1nK\"1\u0011QG\u0006A\u0002uDq!!\u000f\f\u0001\u0004\tY\u0004C\u0004\u0002J-\u0001\r!a\u0013\u0002\r\r\u0014X-\u0019;f)\u0011\t9(! \u0011\u0007Y\fI(C\u0002\u0002|]\u0014A!\u00168ji\"1\u0011q\u0010\u0007A\u0002u\fAA\\1nK\u0006\u0001R\u000f\u001d3bi\u0016\u0004&/\u001b8dSB\fGn\u001d\u000b\u0005\u0003o\n)\tC\u0004\u0002\b6\u0001\r!!#\u0002\u001dI|G.\u001a)sS:\u001c\u0017\u000e]1mgB!\u0011qEAF\u0013\u0011\ti)!\u000b\u0003\u001dI{G.\u001a)sS:\u001c\u0017\u000e]1mgR1\u0011qOAI\u0003'Ca!a \u000f\u0001\u0004i\bbBAK\u001d\u0001\u0007\u00111K\u0001\u000baJLgnY5qC2\u001cH\u0003CA<\u00033\u000bY*!(\t\r\u0005Er\u00021\u0001~\u0011\u0019\tyh\u0004a\u0001{\"9\u0011QS\bA\u0002\u0005M\u0013AB1tg&<g\u000e\u0006\u0004\u0002x\u0005\r\u0016Q\u0015\u0005\u0007\u0003\u007f\u0002\u0002\u0019A?\t\r\u0005\u001d\u0006\u00031\u0001~\u0003%\u0001(/\u001b8dSB\fG.\u0001\u0005v]\u0006\u001c8/[4o)\u0019\t9(!,\u00020\"1\u0011qP\tA\u0002uDa!a*\u0012\u0001\u0004i\u0018A\u0002:f]\u0006lW\r\u0006\u0004\u0002x\u0005U\u0016q\u0017\u0005\u0007\u0003\u007f\u0012\u0002\u0019A?\t\r\u0005e&\u00031\u0001~\u0003\u001dqWm\u001e(b[\u0016\fa\u0001Z3mKR,G\u0003BA<\u0003\u007fCa!a \u0014\u0001\u0004i\u0018A\u0005:fC\u0012\u0014v\u000e\\3Qe&t7-\u001b9bYN$\u0002\"!2\u0002H\u0006%\u00171\u001a\t\u0007\u0003/\t\t#!#\t\r\u0005UB\u00031\u0001~\u0011\u001d\tI\u0004\u0006a\u0001\u0003wAq!!\u0013\u0015\u0001\u0004\tY%\u0001\u0010gSJ,'k\u001c7f!JLgnY5qC2\u001c8\t[1oO\u0016$WI^3oiR!\u0011qOAi\u0011\u001d\t9)\u0006a\u0001\u0003'\u0004b!a\u0006\u0002\"\u0005U\u0007c\u0001\u001f\u0002X&\u0019\u0011QF\u001f)\u0007\u0001\tY\u000e\u0005\u0003\u0002^\u0006\rXBAAp\u0015\r\t\tOT\u0001\u000bgR,'/Z8usB,\u0017\u0002BAs\u0003?\u0014!bQ8oiJ|G\u000e\\3s\u0001")
public class RoleResource
extends AbstractSecuredResource
implements RoleService,
Logging {
    private final com.xebialabs.deployit.security.RoleService service;
    private final DtoWriter dtoWriter;
    @Context
    private final HttpResponse response;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @GET
    public List<String> list() {
        return super.list();
    }

    @Path(value="roles")
    @GET
    public List<String> listMyRoles() {
        return super.listMyRoles();
    }

    @Path(value="roles/{username}")
    @GET
    public List<String> listRoles(String x$1) {
        return super.listRoles(x$1);
    }

    @Path(value="principals")
    @GET
    public List<RolePrincipals> readRolePrincipals() {
        return super.readRolePrincipals();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RoleResource roleResource = this;
        synchronized (roleResource) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private DtoWriter dtoWriter() {
        return this.dtoWriter;
    }

    public HttpResponse response() {
        return this.response;
    }

    public boolean exists(String roleName) {
        return this.service.roleExists(roleName);
    }

    public List<Role> list(String id, String rolePattern, Paging paging, Ordering order) {
        List<Role> list;
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = this.dtoWriter().writeRoles(this.service.getRoles(id));
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader(this.service.countRoles(id, rolePattern), this.response());
            list = this.dtoWriter().writeRoles(this.service.getRoles(id, rolePattern, paging, order));
        }
        return list;
    }

    public List<String> list(String rolePattern, Paging paging, Ordering order) {
        List<String> list;
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = this.service.getRoles().stream().map(x$1 -> x$1.getName()).collect(Collectors.toList());
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader(this.service.countRoles((Number)Predef$.MODULE$.int2Integer(-1), rolePattern), this.response());
            list = this.service.getRoles(rolePattern, paging, order).stream().map(x$2 -> x$2.getName()).collect(Collectors.toList());
        }
        return list;
    }

    public List<String> listMyRoles(String rolePattern, Paging paging, Ordering order) {
        return this.service.getRolesFor(Permissions.getAuthentication(), rolePattern, paging, order).stream().map(x$3 -> x$3.getName()).collect(Collectors.toList());
    }

    public List<String> listRoles(String username, String rolePattern, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        return this.service.getRolesFor(username, rolePattern, paging, order).stream().map(x$4 -> x$4.getName()).collect(Collectors.toList());
    }

    public void create(String name) {
        block0: {
            this.checkPermission(PlatformPermissions.EDIT_SECURITY);
            if (this.service.roleExists(name)) break block0;
            this.service.create(name);
            EventBusHolder.publish((Object)new RoleCreatedEvent(name));
        }
    }

    public void updatePrincipals(RolePrincipals rolePrincipals) {
        this.updatePrincipals(rolePrincipals.getRole().getId(), rolePrincipals.getRole().getName(), rolePrincipals.getPrincipals());
    }

    public void updatePrincipals(String name, List<String> principals) {
        this.updatePrincipals(null, name, principals);
    }

    private void updatePrincipals(String id, String name, List<String> principals) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        com.xebialabs.deployit.security.Role role = new com.xebialabs.deployit.security.Role(id, name, principals);
        this.service.createOrUpdateRole(role);
        this.fireRolePrincipalsChangedEvent(this.service.readRoleAssignments());
    }

    public void assign(String name, String principal) {
        com.xebialabs.deployit.security.Role role = this.service.getRoleForRoleName(name);
        Buffer newPrincipals = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(role.getPrincipals()).$colon$plus((Object)principal, Buffer$.MODULE$.canBuildFrom());
        this.updatePrincipals(name, ImplicitConversions$.MODULE$.buffer$u0020AsJavaList(newPrincipals));
        EventBusHolder.publish((Object)new PrincipalRoleAssignmentCreatedEvent(principal, name));
    }

    public void unassign(String name, String principal) {
        com.xebialabs.deployit.security.Role role = this.service.getRoleForRoleName(name);
        Buffer newPrincipals = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(role.getPrincipals()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RoleResource.$anonfun$unassign$1(principal, p)));
        this.updatePrincipals(name, ImplicitConversions$.MODULE$.buffer$u0020AsJavaList(newPrincipals));
        EventBusHolder.publish((Object)new PrincipalRoleAssignmentDeletedEvent(principal, name));
    }

    public void rename(String name, String newName) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.service.rename(name, newName);
        EventBusHolder.publish((Object)new RoleRenamedEvent(name, newName));
    }

    public void delete(String name) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        this.service.deleteByName(name);
        EventBusHolder.publish((Object)new RoleDeletedEvent(name));
    }

    public List<RolePrincipals> readRolePrincipals(String rolePattern, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        ObjectRef multimap = ObjectRef.create(null);
        if (rolePattern == null && (paging == null || paging.resultsPerPage() == -1) && order == null) {
            multimap.elem = this.service.readRoleAssignments();
        } else {
            multimap.elem = this.service.readRoleAssignments(rolePattern, paging, order);
            long total = this.service.countRoles((Number)Predef$.MODULE$.int2Integer(-1), rolePattern);
            PaginationSupport$.MODULE$.addTotalCountHeader(total, this.response());
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("com.xebialabs.deployit.security.RoleService delivered roles: ").append((List)multimap$1.elem).toString());
        List<RolePrincipals> assignments = this.dtoWriter().writeRoleAssignments((List)multimap.elem);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Going to return the following roles: ").append(assignments).toString());
        return assignments;
    }

    private void fireRolePrincipalsChangedEvent(List<com.xebialabs.deployit.security.Role> rolePrincipals) {
        EventBusHolder.publish((Object)new RolePrincipalsChangedEvent(rolePrincipals.stream().map(r -> new StringBuilder(4).append(r.getName()).append(" => ").append(r.getPrincipals()).toString()).collect(Collectors.toList())));
    }

    public static final /* synthetic */ boolean $anonfun$unassign$1(String principal$1, String p) {
        String string = p;
        String string2 = principal$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public RoleResource(com.xebialabs.deployit.security.RoleService service) {
        this.service = service;
        Logging.$init$((Logging)this);
        this.dtoWriter = new DtoWriter();
        this.response = null;
    }
}

