/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.crypto;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRetriever {
    private HttpHost proxy;
    private Logger logger = LoggerFactory.getLogger(KeyRetriever.class);
    private String jwks_uri;
    private Map<String, PublicKey> keysById = new LinkedHashMap<String, PublicKey>();

    public KeyRetriever(String jwks_uri) {
        this.jwks_uri = jwks_uri;
    }

    public PublicKey getKeyById(String keyId) {
        return this.keysById.get(keyId);
    }

    public void refreshKeys() {
        try {
            this.logger.info("Refreshing OIDC keys from {}...", (Object)this.jwks_uri);
            LinkedHashMap<String, PublicKey> result = new LinkedHashMap<String, PublicKey>();
            String keySetJson = this.call(this.jwks_uri);
            JSONArray keys = new JSONObject(keySetJson).getJSONArray("keys");
            for (int i = 0; i < keys.length(); ++i) {
                JSONObject key = keys.getJSONObject(i);
                String use = Strings.emptyToNull((String)key.optString("use"));
                String alg = Strings.emptyToNull((String)key.optString("alg"));
                if ((use == null || use.equals("sig")) && (alg == null || alg.equals("RS256"))) {
                    result.put(key.getString("kid"), this.computeKey(key.getString("e"), key.getString("n")));
                    continue;
                }
                this.logger.debug("Retrieved key with id {} should have use/alg sig/RS256 but was {}/{}", new Object[]{key.getString("kid"), use, alg});
            }
            this.keysById = result;
            this.logCurrentKeys();
            if (this.keysById.size() == 0) {
                this.logger.warn(keys.length() == 0 ? "Server returned zero keys - OIDC login effectively disabled" : "OIDC provider returned " + keys.length() + " keys but none were usable");
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not properly retrieve keys from " + this.jwks_uri, (Throwable)e);
        }
    }

    private void logCurrentKeys() {
        this.logger.info("Currently known OIDC key IDs:\n * " + com.xebialabs.xlplatform.utils.Strings.mkString(new ArrayList<String>(this.keysById.keySet()), (String)"\n * ") + (this.keysById.size() == 0 ? "(none)" : ""));
    }

    private PublicKey computeKey(String e, String n) throws InvalidKeySpecException, NoSuchAlgorithmException {
        BigInteger exponent = new BigInteger(1, Base64.getUrlDecoder().decode(e));
        BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode(n));
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(keySpec);
    }

    private String call(String uri) throws IOException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.proxy != null) {
            httpClientBuilder.setProxy(this.proxy);
        }
        try (CloseableHttpClient client = httpClientBuilder.build();){
            HttpGet request = new HttpGet(uri);
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)request);
            String string = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public void setProxy(String proxyHost, Integer proxyPort) {
        this.proxy = new HttpHost(proxyHost, proxyPort.intValue(), null);
    }
}

