/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.overthere.util.OverthereUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDescriptorRegistry
extends DescriptorRegistry {
    private static Logger logger = LoggerFactory.getLogger(LocalDescriptorRegistry.class);
    public static final DescriptorRegistryId LOCAL_ID = new LocalDescriptorRegistryId();
    private final Map<Type, Descriptor> descriptors = new HashMap<Type, Descriptor>();
    private final SealedDescriptorHierarchy subtypes = new SealedDescriptorHierarchy();

    protected LocalDescriptorRegistry() {
        super(LOCAL_ID);
    }

    void register(Descriptor descriptor) {
        OverthereUtils.checkState((!this.descriptors.containsKey(descriptor.getType()) ? 1 : 0) != 0, (String)"The type [%s] is already registered in XL Deploy.", (Object[])new Object[]{descriptor.getType()});
        logger.debug("Registered ConfigurationItem: {}", (Object)descriptor);
        this.descriptors.put(descriptor.getType(), descriptor);
    }

    void registerSubtype(Type supertype, Type subtype) {
        OverthereUtils.checkState((!supertype.equals((Object)subtype) ? 1 : 0) != 0, (String)"Cannot register [%s] as its own subtype.", (Object[])new Object[]{supertype});
        this.subtypes.registerSubType(supertype, subtype);
    }

    protected boolean isLocal() {
        return true;
    }

    protected Collection<Descriptor> _getDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    protected Collection<Type> _getSubtypes(Type supertype) {
        return Collections.unmodifiableCollection(this.subtypes.getSubtypes(supertype));
    }

    protected Descriptor _getDescriptor(Type type) {
        OverthereUtils.checkState((!this.descriptors.isEmpty() ? 1 : 0) != 0, (String)"DescriptorRegistry not booted", (Object[])new Object[0]);
        OverthereUtils.checkArgument((boolean)LocalDescriptorRegistry.exists((Type)type), (String)"Unknown type [%s]", (Object[])new Object[]{type});
        return this.descriptors.get(type);
    }

    protected boolean _exists(Type type) {
        return this.descriptors.containsKey(type);
    }

    private static class SealedDescriptorHierarchy {
        private Map<Type, Set<Type>> hierarchy = new HashMap<Type, Set<Type>>();
        private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private SealedDescriptorHierarchy() {
        }

        void registerSubType(Type supertype, Type subtype) {
            this.lock.writeLock().lock();
            try {
                if (!this.hierarchy.containsKey(supertype)) {
                    this.hierarchy.put(supertype, new LinkedHashSet());
                }
                this.hierarchy.get(supertype).add(subtype);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<Type> getSubtypes(Type supertype) {
            this.lock.readLock().lock();
            try {
                Set<Type> types = this.hierarchy.get(supertype);
                if (types != null) {
                    ArrayList<Type> arrayList = new ArrayList<Type>(types);
                    return arrayList;
                }
                List<Type> list = Collections.emptyList();
                return list;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }
}

