/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster.membership.storage;

import com.xebialabs.xlplatform.cluster.DataSourceConfig;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipDB2Dialect;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipDerbyDialect;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipH2Dialect;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipMSSQLDialect;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipMySQLDialect;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipOracleDialect;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipPostgreSQLDialect;
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipSQLManagement;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import scala.util.matching.Regex;

public final class ClusterMembershipManagement$ {
    public static ClusterMembershipManagement$ MODULE$;
    private final Regex Oracle;
    private final Regex MySQL;
    private final Regex PostgreSQL;
    private final Regex DB2;
    private final Regex MSSQL;
    private final Regex H2;
    private final Regex Derby;

    static {
        new ClusterMembershipManagement$();
    }

    public Regex Oracle() {
        return this.Oracle;
    }

    public Regex MySQL() {
        return this.MySQL;
    }

    public Regex PostgreSQL() {
        return this.PostgreSQL;
    }

    public Regex DB2() {
        return this.DB2;
    }

    public Regex MSSQL() {
        return this.MSSQL;
    }

    public Regex H2() {
        return this.H2;
    }

    public Regex Derby() {
        return this.Derby;
    }

    public ClusterMembershipSQLManagement selectDialect(DataSourceConfig dsConfig, FiniteDuration ttl, boolean failFast) {
        ClusterMembershipSQLManagement clusterMembershipSQLManagement;
        String url = dsConfig.url();
        String string = url.toLowerCase();
        Option option = this.Oracle().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
            clusterMembershipSQLManagement = new ClusterMembershipOracleDialect(dsConfig, ttl, failFast);
        } else {
            Option option2 = this.MySQL().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
                clusterMembershipSQLManagement = new ClusterMembershipMySQLDialect(dsConfig, ttl, failFast);
            } else {
                Option option3 = this.PostgreSQL().unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0) {
                    clusterMembershipSQLManagement = new ClusterMembershipPostgreSQLDialect(dsConfig, ttl, failFast);
                } else {
                    Option option4 = this.DB2().unapplySeq((CharSequence)string);
                    if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0) {
                        clusterMembershipSQLManagement = new ClusterMembershipDB2Dialect(dsConfig, ttl, failFast);
                    } else {
                        Option option5 = this.MSSQL().unapplySeq((CharSequence)string);
                        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(0) == 0) {
                            clusterMembershipSQLManagement = new ClusterMembershipMSSQLDialect(dsConfig, ttl, failFast);
                        } else {
                            Option option6 = this.H2().unapplySeq((CharSequence)string);
                            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(0) == 0) {
                                clusterMembershipSQLManagement = new ClusterMembershipH2Dialect(dsConfig, ttl, failFast);
                            } else {
                                Option option7 = this.Derby().unapplySeq((CharSequence)string);
                                if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(0) == 0) {
                                    clusterMembershipSQLManagement = new ClusterMembershipDerbyDialect(dsConfig, ttl, failFast);
                                } else {
                                    throw new IllegalArgumentException(new StringBuilder(54).append("Could not determine the correct dialect for JDBC url: ").append(url).toString());
                                }
                            }
                        }
                    }
                }
            }
        }
        return clusterMembershipSQLManagement;
    }

    public boolean selectDialect$default$3() {
        return true;
    }

    private ClusterMembershipManagement$() {
        MODULE$ = this;
        this.Oracle = new StringOps(Predef$.MODULE$.augmentString("jdbc:oracle.*")).r();
        this.MySQL = new StringOps(Predef$.MODULE$.augmentString("jdbc:mysql.*")).r();
        this.PostgreSQL = new StringOps(Predef$.MODULE$.augmentString("jdbc:postgresql.*")).r();
        this.DB2 = new StringOps(Predef$.MODULE$.augmentString("jdbc:db2.*")).r();
        this.MSSQL = new StringOps(Predef$.MODULE$.augmentString("jdbc:sqlserver.*")).r();
        this.H2 = new StringOps(Predef$.MODULE$.augmentString("jdbc:h2.*")).r();
        this.Derby = new StringOps(Predef$.MODULE$.augmentString("jdbc:derby.*")).r();
    }
}

