/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.xebialabs.deployit.deployment.planner.CompositePlan;
import com.xebialabs.deployit.deployment.planner.ExecutablePlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.xlplatform.satellite.Satellite;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class ParallelPlan
extends CompositePlan {
    public ParallelPlan(String description, List<? extends ExecutablePlan> subPlans, List<ExecutionStateListener> listeners) {
        super(description, subPlans, listeners);
    }

    public ParallelPlan(String description, List<? extends ExecutablePlan> subPlans, List<ExecutionStateListener> listeners, Satellite satellite) {
        super(description, subPlans, listeners, satellite);
    }

    @Override
    public Writer writePlan(Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        boolean first = true;
        this.writeBlockBoundery(out, 2);
        if (this.satellite() != null) {
            out.println("# [Parallel (on Satellite " + this.satellite() + "] " + this.getDescription());
        } else {
            out.println("# [Parallel] " + this.getDescription());
        }
        this.writeBlockBoundery(out, 2);
        for (Plan plan : this.getSubPlans()) {
            StringWriter singlePlanWriter = new StringWriter();
            if (!first) {
                singlePlanWriter.append("============================================>\n");
            }
            plan.writePlan(singlePlanWriter);
            out.append(ParallelPlan.indent(singlePlanWriter.toString(), 4));
            first = false;
        }
        return writer;
    }
}

