/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive.sql.reports;

import com.xebialabs.deployit.core.sql.OrderBy;
import com.xebialabs.deployit.core.sql.OrderBy$;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks$;
import org.joda.time.DateTime;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0010!\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005o!A!\t\u0001BC\u0002\u0013\r1\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u001d!\u0006A1A\u0005\u0002UCa!\u0017\u0001!\u0002\u00131\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B3\u0001\t\u00031\u0007\"\u00025\u0001\t\u0003I\u0007\"B=\u0001\t\u0003Q\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u0017Aq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u00055\u0002\u0001\"\u0003\u00020!9\u0011\u0011\u0007\u0001\u0005\n\u0005=\u0002bBA\u001a\u0001\u0011%\u0011q\u0006\u0005\b\u0003k\u0001A\u0011BA\u0018\u0011\u001d\t9\u0004\u0001C\u0005\u0003_Aq!!\u000f\u0001\t\u0013\ty\u0003C\u0004\u0002<\u0001!I!a\f\t\u000f\u0005u\u0002\u0001\"\u0003\u00020!9\u0011q\b\u0001\u0005\n\u0005=\u0002bBA!\u0001\u0011%\u0011q\u0006\u0005\b\u0003\u0007\u0002A\u0011BA\u0018\u0011\u001d\t)\u0005\u0001C\u0005\u0003_Aq!a\u0012\u0001\t\u0013\ty\u0003C\u0004\u0002J\u0001!I!a\f\u0003?M\u000bH\u000eR3qY>LX.\u001a8u)\u0006\u001c8.\u00118bYf$\u0018nY:Rk\u0016\u0014\u0018P\u0003\u0002\"E\u00059!/\u001a9peR\u001c(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nq!\u0019:dQ&4XM\u0003\u0002(Q\u0005!A/Y:l\u0015\tI#&\u0001\u0005eKBdw._5u\u0015\tYC&A\u0005yK\nL\u0017\r\\1cg*\tQ&A\u0002d_6\u001c\u0001a\u0005\u0002\u0001aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\fQAY3hS:\u0004\"\u0001O \u000e\u0003eR!AO\u001e\u0002\tQLW.\u001a\u0006\u0003yu\nAA[8eC*\ta(A\u0002pe\u001eL!\u0001Q\u001d\u0003\u0011\u0011\u000bG/\u001a+j[\u0016\f1!\u001a8e\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0002\tB\u0011Q)S\u0007\u0002\r*\u00111e\u0012\u0006\u0003\u0011\"\nAaY8sK&\u0011!J\u0012\u0002\u000b'FdG)[1mK\u000e$\u0018aC:rY\u0012K\u0017\r\\3di\u0002\na\u0001P5oSRtDc\u0001(S'R\u0011q*\u0015\t\u0003!\u0002i\u0011\u0001\t\u0005\u0006\u0005\u0016\u0001\u001d\u0001\u0012\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006\u0003\u0016\u0001\raN\u0001\u000eg\u0016dWm\u0019;Ck&dG-\u001a:\u0016\u0003Y\u0003\"!R,\n\u0005a3%!D*fY\u0016\u001cGOQ;jY\u0012,'/\u0001\btK2,7\r\u001e\"vS2$WM\u001d\u0011\u00029QD'o\\;hQB,HOQ=EKBdw._7f]R\u0014Vm];miR\u0011Al\u0018\t\u0003cuK!A\u0018\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0006A\"\u0001\r!Y\u0001\u0007gR\fG/^:\u0011\u0005\t\u001cW\"\u0001\u0013\n\u0005\u0011$#\u0001\u0005#fa2|\u00170\\3oiJ+7/\u001e7u\u0003]\u0019w.\u001e8u\u0005f$U\r\u001d7ps6,g\u000e\u001e*fgVdG\u000f\u0006\u0002]O\")\u0001-\u0003a\u0001C\u0006\tBo\u001c;bYN\u0014\u00150\u00119q\u0003:$WI\u001c<\u0015\u0007qSw\u000fC\u0003l\u0015\u0001\u0007A.A\bbaBd\u0017nY1uS>tg*Y7f!\tiGO\u0004\u0002oeB\u0011qNM\u0007\u0002a*\u0011\u0011OL\u0001\u0007yI|w\u000e\u001e \n\u0005M\u0014\u0014A\u0002)sK\u0012,g-\u0003\u0002vm\n11\u000b\u001e:j]\u001eT!a\u001d\u001a\t\u000baT\u0001\u0019\u00017\u0002\u001b\u0015tg/\u001b:p]6,g\u000e^%e\u0003u!x\u000e\u001d(M_:<Wm\u001d;Sk:t\u0017N\\4EKBdw._7f]R\u001cHC\u0001/|\u0011\u0015a8\u00021\u0001~\u0003\u0011!x\u000e\u001d(\u0011\u0005Er\u0018BA@3\u0005\rIe\u000e^\u0001\u0017i>\u0004h\nR3qY>LX.\u001a8ug\nK8\u000b^1uKR)A,!\u0002\u0002\b!)\u0001\r\u0004a\u0001C\")A\u0010\u0004a\u0001{\u0006\u0011\u0013M^3sC\u001e,G)\u001e:bi&|g\u000eR3qY>LX.\u001a8ug>3XM\u001d+j[\u0016$\u0012\u0001X\u0001\"i>$\u0018\r\\*vG\u000e,7o\u001d4vY\u0012+\u0007\u000f\\8z[\u0016tG\u000fR;sCRLwN\\\u0001\u0005E&t7\u000fF\u0003]\u0003'\ti\u0002C\u0004\u0002\u0016=\u0001\r!a\u0006\u0002\u0011\tLgn\u0015;beR\u0004B!MA\r{&\u0019\u00111\u0004\u001a\u0003\r=\u0003H/[8o\u0011\u001d\tyb\u0004a\u0001\u0003/\taAY5o\u000b:$\u0017AE7bi\u000eD\u0017\t\u001a3D_:\u001cHO]1j]R$B!!\n\u0002,A\u0019\u0011'a\n\n\u0007\u0005%\"GA\u0002B]fDQ\u0001\u0019\tA\u0002\u0005\f1b]3mK\u000e$8i\\;oiR\ta+\u0001\tpe\u0012,'OQ=D_VtG\u000fR3tG\u0006\u0001rM]8va\nK\u0018\t\u001d9B]\u0012,eN^\u0001\u0014OJ|W\u000f\u001d\"z3\u0016\f'/\u00118e\u001b>tG\u000f[\u0001!I\u0016\u0004Hn\\=UCN\\G+\u001f9fg>#\b.\u001a:UQ\u0006t'k\u001c7mE\u0006\u001c7.A\u0007e_:,w+\u001b;i%\u0016$(/_\u0001\u0005I>tW-\u0001\u0006o_R\u0014V\r\u001e:jK\u0012\f\u0001c];n\r\u0006LG.\u001e:f\u0007>,h\u000e^:\u00025=\u0014H-\u001a:Cs\u001a\u000b\u0017\u000e\\;sK\u000e{WO\u001c;Tk6$Um]2\u0002)\u0005$GmU;dG\u0016\u001c8oQ8ogR\u0014\u0018-\u001b8u\u0003M\tG\r\u001a$bS2,GmQ8ogR\u0014\u0018-\u001b8u\u0003Q\tG\rZ!c_J$X\rZ\"p]N$(/Y5oi\u0006)\u0012\r\u001a3S_2d'-Y2l\u0007>t7\u000f\u001e:bS:$\b")
public class SqlDeploymentTaskAnalyticsQuery {
    private final SqlDialect sqlDialect;
    private final SelectBuilder selectBuilder;

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public SelectBuilder selectBuilder() {
        return this.selectBuilder;
    }

    public void throughputByDeploymentResult(DeploymentResult status) {
        this.groupByYearAndMonth();
        this.selectCount();
        this.matchAddConstraint(status);
    }

    public void countByDeploymentResult(DeploymentResult status) {
        this.selectCount();
        this.matchAddConstraint(status);
    }

    public void totalsByAppAndEnv(String applicationName, String environmentId) {
        this.selectCount();
        this.deployTaskTypesOtherThanRollback();
        this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.main_application(), applicationName)).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.environment(), environmentId));
    }

    public void topNLongestRunningDeployments(int topN) {
        this.selectBuilder().select((Selectable)SqlFunction$.MODULE$.average().apply((Object)ArchivedDeploymentTasks$.MODULE$.duration())).orderBy((OrderBy)OrderBy$.MODULE$.desc((Selectable)SqlFunction$.MODULE$.average().apply((Object)ArchivedDeploymentTasks$.MODULE$.duration())));
        this.selectBuilder().limit(topN);
        this.notRetried();
        this.deployTaskTypesOtherThanRollback();
        this.groupByAppAndEnv();
    }

    public void topNDeploymentsByState(DeploymentResult status, int topN) {
        this.groupByAppAndEnv();
        this.selectCount();
        this.orderByCountDesc();
        this.selectBuilder().limit(topN);
        DeploymentResult deploymentResult = status;
        if (DeploymentResult.SUCCESS.equals(deploymentResult)) {
            this.addSuccessConstraint();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DeploymentResult.FAILED.equals(deploymentResult)) {
            this.sumFailureCounts();
            this.addFailedConstraint();
            this.orderByFailureCountSumDesc();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException("topNDeploymentsByState called with invalid deploymentResult");
        }
    }

    public void averageDurationDeploymentsOverTime() {
        this.groupByYearAndMonth();
        this.selectCount();
        this.selectBuilder().select((Selectable)SqlFunction$.MODULE$.average().apply((Object)ArchivedDeploymentTasks$.MODULE$.duration()));
        this.deployTaskTypesOtherThanRollback();
        this.done();
    }

    public void totalSuccessfulDeploymentDuration() {
        this.selectCount();
        this.selectBuilder().select((Selectable)SqlFunction$.MODULE$.average().apply((Object)ArchivedDeploymentTasks$.MODULE$.duration())).select((Selectable)this.sqlDialect().standardDeviation(ArchivedDeploymentTasks$.MODULE$.duration()));
        this.addSuccessConstraint();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bins(Option<Object> binStart, Option<Object> binEnd) {
        this.selectCount();
        this.deployTaskTypesOtherThanRollback();
        this.done();
        Tuple2 tuple2 = new Tuple2(binStart, binEnd);
        if (tuple2 != null) {
            Option binStart2 = (Option)tuple2._1();
            Option option = (Option)tuple2._2();
            if (binStart2 instanceof Some) {
                Some some = (Some)binStart2;
                if (None$.MODULE$.equals(option)) {
                    this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.largerThen((Selectable)ArchivedDeploymentTasks$.MODULE$.duration(), (Number)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)some.get()))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Option binStart3 = (Option)tuple2._1();
            Option binEnd2 = (Option)tuple2._2();
            if (binStart3 instanceof Some) {
                Some some = (Some)binStart3;
                if (binEnd2 instanceof Some) {
                    Some some2 = (Some)binEnd2;
                    this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.largerThen((Selectable)ArchivedDeploymentTasks$.MODULE$.duration(), (Number)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)some.get())))).where((SqlCondition)SqlCondition$.MODULE$.smallerOrEqual((Selectable)ArchivedDeploymentTasks$.MODULE$.duration(), (Number)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)some2.get()))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option binEnd3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && binEnd3 instanceof Some) {
                Some some = (Some)binEnd3;
                this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.smallerOrEqual((Selectable)ArchivedDeploymentTasks$.MODULE$.duration(), (Number)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)some.get()))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Object matchAddConstraint(DeploymentResult status) {
        SelectBuilder selectBuilder;
        DeploymentResult deploymentResult = status;
        if (DeploymentResult.ROLLBACK.equals(deploymentResult)) {
            selectBuilder = this.addRollbackConstraint();
        } else if (DeploymentResult.SUCCESS.equals(deploymentResult)) {
            selectBuilder = this.addSuccessConstraint();
        } else if (DeploymentResult.FAILED.equals(deploymentResult)) {
            selectBuilder = this.addFailedConstraint();
        } else if (DeploymentResult.ABORTED.equals(deploymentResult)) {
            selectBuilder = this.addAbortedConstraint();
        } else if (DeploymentResult.TOTAL.equals(deploymentResult)) {
            selectBuilder = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)deploymentResult);
        }
        return selectBuilder;
    }

    private SelectBuilder selectCount() {
        return (SelectBuilder)this.selectBuilder().select((Selectable)SqlFunction$.MODULE$.countAll());
    }

    private SelectBuilder orderByCountDesc() {
        return (SelectBuilder)this.selectBuilder().orderBy((OrderBy)OrderBy$.MODULE$.desc((Selectable)SqlFunction$.MODULE$.countAll()));
    }

    private SelectBuilder groupByAppAndEnv() {
        return ((SelectBuilder)this.selectBuilder().select((Selectable)ArchivedDeploymentTasks$.MODULE$.main_application()).select((Selectable)ArchivedDeploymentTasks$.MODULE$.environment())).groupBy((Selectable)ArchivedDeploymentTasks$.MODULE$.main_application()).groupBy((Selectable)ArchivedDeploymentTasks$.MODULE$.environment());
    }

    private SelectBuilder groupByYearAndMonth() {
        return ((SelectBuilder)this.selectBuilder().select((Selectable)this.sqlDialect().year(ArchivedDeploymentTasks$.MODULE$.start_date())).select((Selectable)this.sqlDialect().month(ArchivedDeploymentTasks$.MODULE$.start_date()))).groupBy((Selectable)this.sqlDialect().year(ArchivedDeploymentTasks$.MODULE$.start_date())).groupBy((Selectable)this.sqlDialect().month(ArchivedDeploymentTasks$.MODULE$.start_date()));
    }

    private SelectBuilder deployTaskTypesOtherThanRollback() {
        return (SelectBuilder)this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.in((Selectable)ArchivedDeploymentTasks$.MODULE$.task_type(), (Iterable)new .colon.colon((Object)TaskType.INITIAL, (List)new .colon.colon((Object)TaskType.UPGRADE, (List)new .colon.colon((Object)TaskType.UNDEPLOY, (List)Nil$.MODULE$)))));
    }

    private SelectBuilder doneWithRetry() {
        return (SelectBuilder)this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.status(), TaskExecutionState.DONE.name())).where((SqlCondition)SqlCondition$.MODULE$.largerThen((Selectable)ArchivedDeploymentTasks$.MODULE$.failure_count(), (Number)Predef$.MODULE$.int2Integer(0)));
    }

    private SelectBuilder done() {
        return (SelectBuilder)this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.status(), TaskExecutionState.DONE.name())).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.failure_count(), (Number)Predef$.MODULE$.int2Integer(0)));
    }

    private SelectBuilder notRetried() {
        return (SelectBuilder)this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.failure_count(), (Number)Predef$.MODULE$.int2Integer(0)));
    }

    private SelectBuilder sumFailureCounts() {
        return (SelectBuilder)this.selectBuilder().select((Selectable)SqlFunction$.MODULE$.sum().apply((Object)ArchivedDeploymentTasks$.MODULE$.failure_count()));
    }

    private SelectBuilder orderByFailureCountSumDesc() {
        return (SelectBuilder)this.selectBuilder().orderBy((OrderBy)OrderBy$.MODULE$.desc((Selectable)SqlFunction$.MODULE$.sum().apply((Object)ArchivedDeploymentTasks$.MODULE$.failure_count())));
    }

    private SelectBuilder addSuccessConstraint() {
        this.deployTaskTypesOtherThanRollback();
        return this.done();
    }

    private SelectBuilder addFailedConstraint() {
        this.deployTaskTypesOtherThanRollback();
        return this.doneWithRetry();
    }

    private SelectBuilder addAbortedConstraint() {
        this.deployTaskTypesOtherThanRollback();
        return (SelectBuilder)this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.status(), TaskExecutionState.CANCELLED.name()));
    }

    private SelectBuilder addRollbackConstraint() {
        return (SelectBuilder)this.selectBuilder().where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.task_type(), TaskType.ROLLBACK.name()));
    }

    public SqlDeploymentTaskAnalyticsQuery(DateTime begin, DateTime end, SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
        this.selectBuilder = (SelectBuilder)new SelectBuilder(ArchivedDeploymentTasks$.MODULE$.tableName(), sqlDialect).where(SqlCondition$.MODULE$.between((Selectable)ArchivedDeploymentTasks$.MODULE$.start_date(), begin, end));
    }
}

