/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.userauth.certificate;

import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Certificate<T extends PublicKey>
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private final T publicKey;
    private final byte[] nonce;
    private final BigInteger serial;
    private final long type;
    private final String id;
    private final List<String> validPrincipals;
    private final Date validAfter;
    private final Date validBefore;
    private final Map<String, String> critOptions;
    private final Map<String, String> extensions;
    private final byte[] signatureKey;
    private final byte[] signature;

    Certificate(Builder<T> builder) {
        this.publicKey = builder.getPublicKey();
        this.nonce = builder.getNonce();
        this.serial = builder.getSerial();
        this.type = builder.getType();
        this.id = builder.getId();
        this.validPrincipals = builder.getValidPrincipals();
        this.validAfter = builder.getValidAfter();
        this.validBefore = builder.getValidBefore();
        this.critOptions = builder.getCritOptions();
        this.extensions = builder.getExtensions();
        this.signatureKey = builder.getSignatureKey();
        this.signature = builder.getSignature();
    }

    public static <P extends PublicKey> Builder<P> getBuilder() {
        return new Builder();
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public BigInteger getSerial() {
        return this.serial;
    }

    public long getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getValidPrincipals() {
        return this.validPrincipals;
    }

    public Date getValidAfter() {
        return this.validAfter;
    }

    public Date getValidBefore() {
        return this.validBefore;
    }

    public Map<String, String> getCritOptions() {
        return this.critOptions;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public byte[] getSignatureKey() {
        return this.signatureKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public T getKey() {
        return this.publicKey;
    }

    @Override
    public byte[] getEncoded() {
        return this.publicKey.getEncoded();
    }

    @Override
    public String getAlgorithm() {
        return this.publicKey.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.publicKey.getFormat();
    }

    public static class Builder<T extends PublicKey> {
        private T publicKey;
        private byte[] nonce;
        private BigInteger serial;
        private long type;
        private String id;
        private List<String> validPrincipals;
        private Date validAfter;
        private Date validBefore;
        private Map<String, String> critOptions;
        private Map<String, String> extensions;
        private byte[] signatureKey;
        private byte[] signature;

        public Certificate<T> build() {
            return new Certificate(this);
        }

        public T getPublicKey() {
            return this.publicKey;
        }

        public Builder<T> publicKey(T publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public byte[] getNonce() {
            return this.nonce;
        }

        public Builder<T> nonce(byte[] nonce) {
            this.nonce = nonce;
            return this;
        }

        public BigInteger getSerial() {
            return this.serial;
        }

        public Builder<T> serial(BigInteger serial) {
            this.serial = serial;
            return this;
        }

        public long getType() {
            return this.type;
        }

        public Builder<T> type(long type) {
            this.type = type;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        public List<String> getValidPrincipals() {
            return this.validPrincipals;
        }

        public Builder<T> validPrincipals(List<String> validPrincipals) {
            this.validPrincipals = validPrincipals;
            return this;
        }

        public Date getValidAfter() {
            return this.validAfter;
        }

        public Builder<T> validAfter(Date validAfter) {
            this.validAfter = validAfter;
            return this;
        }

        public Date getValidBefore() {
            return this.validBefore;
        }

        public Builder<T> validBefore(Date validBefore) {
            this.validBefore = validBefore;
            return this;
        }

        public Map<String, String> getCritOptions() {
            return this.critOptions;
        }

        public Builder<T> critOptions(Map<String, String> critOptions) {
            this.critOptions = critOptions;
            return this;
        }

        public Map<String, String> getExtensions() {
            return this.extensions;
        }

        public Builder<T> extensions(Map<String, String> extensions) {
            this.extensions = extensions;
            return this;
        }

        public byte[] getSignatureKey() {
            return this.signatureKey;
        }

        public Builder<T> signatureKey(byte[] signatureKey) {
            this.signatureKey = signatureKey;
            return this;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public Builder<T> signature(byte[] signature) {
            this.signature = signature;
            return this;
        }
    }
}

