/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import net.schmizz.sshj.userauth.password.AccountResource;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUpdateProvider;
import net.schmizz.sshj.userauth.password.Resource;

public class AuthPassword
extends AbstractAuthMethod {
    private final PasswordFinder pwdf;
    private static final PasswordUpdateProvider nullProvider = new PasswordUpdateProvider(){

        @Override
        public char[] provideNewPassword(Resource<?> resource, String prompt) {
            return null;
        }

        @Override
        public boolean shouldRetry(Resource<?> resource) {
            return false;
        }
    };
    private final PasswordUpdateProvider newPasswordProvider;

    public AuthPassword(PasswordFinder pwdf) {
        this(pwdf, nullProvider);
    }

    public AuthPassword(PasswordFinder pwdf, PasswordUpdateProvider newPasswordProvider) {
        super("password");
        this.pwdf = pwdf;
        this.newPasswordProvider = newPasswordProvider;
    }

    @Override
    public SSHPacket buildReq() throws UserAuthException {
        AccountResource accountResource = this.makeAccountResource();
        this.log.debug("Requesting password for {}", (Object)accountResource);
        return (SSHPacket)((SSHPacket)super.buildReq().putBoolean(false)).putSensitiveString(this.pwdf.reqPassword(accountResource));
    }

    @Override
    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60 && this.newPasswordProvider != null) {
            this.log.info("Received SSH_MSG_USERAUTH_PASSWD_CHANGEREQ.");
            try {
                String prompt = buf.readString();
                buf.readString();
                AccountResource resource = this.makeAccountResource();
                char[] newPassword = this.newPasswordProvider.provideNewPassword(resource, prompt);
                SSHPacket sshPacket = (SSHPacket)((SSHPacket)((SSHPacket)super.buildReq().putBoolean(true)).putSensitiveString(this.pwdf.reqPassword(resource))).putSensitiveString(newPassword);
                this.params.getTransport().write(sshPacket);
            }
            catch (Buffer.BufferException e) {
                throw new TransportException(e);
            }
        } else {
            if (cmd == Message.USERAUTH_60) {
                throw new UserAuthException("Password change request received; unsupported operation (newPassword was 'null')");
            }
            super.handle(cmd, buf);
        }
    }

    @Override
    public boolean shouldRetry() {
        AccountResource accountResource = this.makeAccountResource();
        return this.newPasswordProvider.shouldRetry(accountResource) || this.pwdf.shouldRetry(accountResource);
    }
}

