/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation.journal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.prevayler.implementation.TransactionGuide;
import org.prevayler.implementation.TransactionTimestamp;
import org.prevayler.implementation.journal.Journal;
import org.prevayler.implementation.publishing.TransactionSubscriber;

public class TransientJournal
implements Journal {
    private final List journal = new ArrayList();
    private long _initialTransaction;
    private boolean _initialTransactionInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(TransactionGuide guide) {
        if (!this._initialTransactionInitialized) {
            throw new IllegalStateException("Journal.update() has to be called at least once before Journal.journal().");
        }
        guide.startTurn();
        try {
            guide.checkSystemVersion(this._initialTransaction + (long)this.journal.size());
            this.journal.add(guide.timestamp().cleanCopy());
        }
        finally {
            guide.endTurn();
        }
    }

    @Override
    public synchronized void update(TransactionSubscriber subscriber, long initialTransaction) throws IOException {
        if (!this._initialTransactionInitialized) {
            this._initialTransactionInitialized = true;
            this._initialTransaction = initialTransaction;
            return;
        }
        if (initialTransaction < this._initialTransaction) {
            throw new IOException("Unable to recover transaction " + initialTransaction + ". The oldest recoverable transaction is " + this._initialTransaction + ".");
        }
        int i = (int)(initialTransaction - this._initialTransaction);
        if (i > this.journal.size()) {
            throw new IOException("The transaction journal has not yet reached transaction " + initialTransaction + ". The last logged transaction was " + (this._initialTransaction + (long)this.journal.size() - 1L) + ".");
        }
        while (i != this.journal.size()) {
            TransactionTimestamp entry = (TransactionTimestamp)this.journal.get(i);
            long recoveringTransaction = this._initialTransaction + (long)i;
            if (entry.systemVersion() != recoveringTransaction) {
                throw new IOException("Expected " + recoveringTransaction + " but was " + entry.systemVersion());
            }
            subscriber.receive(entry);
            ++i;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized long nextTransaction() {
        if (!this._initialTransactionInitialized) {
            throw new IllegalStateException("update() must be called at least once");
        }
        return this._initialTransaction + (long)this.journal.size();
    }
}

