/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local.validation;

import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import org.apache.commons.lang.StringUtils;

public class IntegerOrPlaceholderValidator
implements Validator<String> {
    public void validate(String value, ValidationContext context) {
        if (value == null) {
            return;
        }
        if (!this.isPlaceholder(value) && !this.isInteger(value)) {
            context.error("This value is not valid. The expected type is integer (num) or placeholder.", new Object[]{value});
        }
    }

    private boolean isPlaceholder(String value) {
        return StringUtils.startsWith((String)value, (String)"{{") && StringUtils.endsWith((String)value, (String)"}}");
    }

    private boolean isInteger(String value) {
        return StringUtils.isNumeric((String)value);
    }
}

