/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.util.Properties;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;

public class FallbackPrincipalProvider
implements PrincipalProvider {
    public static final String OPTION_DISABLED = "disabled";
    private boolean disabled;

    @Override
    public Principal getPrincipal(String principalName) {
        return this.disabled ? null : new UnknownPrincipal(principalName);
    }

    @Override
    public PrincipalIterator findPrincipals(String simpleFilter) {
        return PrincipalIteratorAdapter.EMPTY;
    }

    @Override
    public PrincipalIterator findPrincipals(String simpleFilter, int searchType) {
        return PrincipalIteratorAdapter.EMPTY;
    }

    @Override
    public PrincipalIterator getPrincipals(int searchType) {
        return PrincipalIteratorAdapter.EMPTY;
    }

    @Override
    public PrincipalIterator getGroupMembership(Principal principal) {
        return PrincipalIteratorAdapter.EMPTY;
    }

    @Override
    public void init(Properties options) {
        this.disabled = "true".equals(options.get(OPTION_DISABLED));
    }

    @Override
    public void close() {
    }

    @Override
    public boolean canReadPrincipal(Session session, Principal principalToRead) {
        return true;
    }
}

