/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.overthere.util.OverthereUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.joda.time.DateTime;

public class JcrUtils {
    public static List<String> readList(Node node, String property) throws RepositoryException {
        Property prop = node.getProperty(property);
        ArrayList<String> list = new ArrayList<String>();
        if (prop.isMultiple()) {
            for (Value value : prop.getValues()) {
                list.add(value.getString());
            }
        } else {
            list.add(prop.getString());
        }
        return list;
    }

    public static Map<String, String> readMap(Property property) throws RepositoryException {
        HashMap<String, String> map = new HashMap<String, String>();
        OverthereUtils.checkState((boolean)property.isMultiple(), (String)"The property [%s] should be multi-valued in order to read a Map<String, String>", (Object[])new Object[]{property.getName()});
        for (Value value : property.getValues()) {
            String string = value.getString();
            int i = string.indexOf("=");
            String k = string;
            String v = "";
            if (i > -1) {
                k = string.substring(0, i);
                v = string.substring(i + 1);
            }
            map.put(k, v);
        }
        return map;
    }

    public static void writeMap(Node node, String propertyName, Map<String, String> map) throws RepositoryException {
        ArrayList<Value> values = new ArrayList<Value>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            values.add(node.getSession().getValueFactory().createValue(entry.getKey() + "=" + entry.getValue()));
        }
        if (values.isEmpty() && node.hasProperty(propertyName)) {
            node.getProperty(propertyName).remove();
        }
        if (!values.isEmpty()) {
            node.setProperty(propertyName, values.toArray(new Value[values.size()]));
        }
    }

    public static void forEachNonJcrProperty(Node node, Callback<Property> f) throws RepositoryException {
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property p = properties.nextProperty();
            if (p.getName().startsWith("jcr:") || p.getName().startsWith("$")) continue;
            f.apply(p);
        }
    }

    public static void clearProperties(Node node) throws RepositoryException {
        JcrUtils.forEachNonJcrProperty(node, new Callback<Property>(){

            @Override
            public void apply(Property input) throws RepositoryException {
                input.remove();
            }
        });
    }

    public static String getProperty(Node node, String propName) throws RepositoryException {
        return node.getProperty(propName).getString();
    }

    public static int getIntegerProperty(Node node, String propName) throws RepositoryException {
        return (int)node.getProperty(propName).getLong();
    }

    public static DateTime getDate(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            return new DateTime((Object)node.getProperty(propName).getDate());
        }
        return null;
    }

    public static String getOptionalProperty(Node node, String propName) throws RepositoryException {
        if (node.hasProperty(propName)) {
            return node.getProperty(propName).getString();
        }
        return null;
    }

    public static Node getOrCreateChild(Node parentNode, String nodeId) throws RepositoryException {
        if (parentNode.hasNode(nodeId)) {
            return parentNode.getNode(nodeId);
        }
        return parentNode.addNode(nodeId);
    }

    public static int countMatches(String s, char c) {
        int matches = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++matches;
        }
        return matches;
    }

    public static String escapeIllegalJcrChars(String name) {
        return JcrUtils.escapeIllegalChars(name, "%/:[]*|\t\r\n");
    }

    private static String escapeIllegalChars(String name, String illegal) {
        StringBuilder buffer = new StringBuilder(name.length() * 2);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (illegal.indexOf(ch) != -1 || ch == '.' && name.length() < 3 || ch == ' ' && (i == 0 || i == name.length() - 1)) {
                buffer.append('%');
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String unescapeIllegalJcrChars(String name) {
        StringBuilder buffer = new StringBuilder(name.length());
        int i = name.indexOf(37);
        while (i > -1 && i + 2 < name.length()) {
            buffer.append(name.toCharArray(), 0, i);
            int a = Character.digit(name.charAt(i + 1), 16);
            int b = Character.digit(name.charAt(i + 2), 16);
            if (a > -1 && b > -1) {
                buffer.append((char)(a * 16 + b));
                name = name.substring(i + 3);
            } else {
                buffer.append('%');
                name = name.substring(i + 1);
            }
            i = name.indexOf(37);
        }
        buffer.append(name);
        return buffer.toString();
    }

    public static interface Callback<T> {
        public void apply(T var1) throws RepositoryException;
    }
}

