/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrChangeSetExecutor;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.NullProgressLogger;
import com.xebialabs.deployit.repository.PathHelper;
import com.xebialabs.deployit.repository.ProgressLogger;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;

class JcrReferentialIntegrityChecker
implements JcrCallback<Object> {
    private final JcrRepositoryService jcrRepositoryService;
    private final ChangeSet changeset;
    private final PasswordEncrypter passwordEncrypter;
    private final LicenseService licenseService;

    JcrReferentialIntegrityChecker(JcrRepositoryService jcrRepositoryService, ChangeSet changeset, PasswordEncrypter passwordEncrypter, LicenseService licenseService) {
        this.jcrRepositoryService = (JcrRepositoryService)Checks.checkNotNull((Object)jcrRepositoryService, (String)"jcrRepositoryService");
        this.changeset = (ChangeSet)Checks.checkNotNull((Object)changeset, (String)"changeset");
        this.passwordEncrypter = (PasswordEncrypter)Checks.checkNotNull((Object)passwordEncrypter, (String)"passwordEncrypter");
        this.licenseService = licenseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doInJcr(Session session) throws RepositoryException {
        this.checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(session);
        Map<String, List<PropertyRef>> deletedEntityRefs = this.findReferencesToDeletedNodes(session);
        JcrChangeSetExecutor changeSetExecutor = new JcrChangeSetExecutor(this.jcrRepositoryService, this.changeset, this.passwordEncrypter, this.licenseService, (ProgressLogger)new NullProgressLogger());
        changeSetExecutor.execute(session, true);
        try {
            this.checkForRemainingReferencesToDeletedNodes(deletedEntityRefs, session);
        }
        finally {
            session.refresh(false);
        }
        return null;
    }

    private void checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(Session session) throws RepositoryException {
        for (ConfigurationItem entity : this.changeset.getCreateCis()) {
            if (!session.nodeExists(PathHelper.getAbsolutePathFromId((String)entity.getId()))) continue;
            throw new ItemAlreadyExistsException("Repository entity %s already exists", new Object[]{entity.getId()});
        }
    }

    private Map<String, List<PropertyRef>> findReferencesToDeletedNodes(Session session) throws RepositoryException {
        HashMap<String, List<PropertyRef>> deletedEntityRefs = new HashMap<String, List<PropertyRef>>();
        for (String deleteNodeId : this.changeset.getDeleteCiIds()) {
            if (!session.nodeExists(PathHelper.getAbsolutePathFromId((String)deleteNodeId))) continue;
            Node node = session.getNode(PathHelper.getAbsolutePathFromId((String)deleteNodeId));
            PropertyIterator references = node.getReferences();
            while (references.hasNext()) {
                Property property = references.nextProperty();
                Node parent = property.getParent();
                if (this.isParentListCiReference(property, node)) continue;
                deletedEntityRefs.computeIfAbsent(deleteNodeId, i -> new ArrayList()).add(new PropertyRef(parent.getPath(), property.getName(), node.getIdentifier()));
            }
        }
        return deletedEntityRefs;
    }

    private boolean isParentListCiReference(Property referenceProperty, Node nodeToBeDeleted) throws RepositoryException {
        Node owningNode = referenceProperty.getParent();
        if (!nodeToBeDeleted.getParent().getPath().equals(owningNode.getPath())) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = NodeUtils.descriptorOf(referenceProperty);
        return propertyDescriptor.isAsContainment() && propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI;
    }

    private void checkForRemainingReferencesToDeletedNodes(Map<String, List<PropertyRef>> deletedEntityRefs, Session session) throws RepositoryException {
        for (String deleteNodeId : deletedEntityRefs.keySet()) {
            for (PropertyRef propertyRef : deletedEntityRefs.get(deleteNodeId)) {
                Value[] values;
                Value[] valueArray;
                Node owningNode;
                if (!session.nodeExists(propertyRef.owningNode) || !(owningNode = session.getNode(propertyRef.owningNode)).hasProperty(propertyRef.property)) continue;
                Property property = owningNode.getProperty(propertyRef.property);
                if (property.isMultiple()) {
                    valueArray = property.getValues();
                } else {
                    Value[] valueArray2 = new Value[1];
                    valueArray = valueArray2;
                    valueArray2[0] = property.getValue();
                }
                for (Value value : values = valueArray) {
                    if (!value.getString().equals(propertyRef.uuidOfReferencedNode)) continue;
                    throw new ItemInUseException("Repository entity %s is still referenced by %s", new Object[]{deleteNodeId, this.getOwnerNodeWithoutLeadingSlash(propertyRef)});
                }
            }
        }
    }

    private String getOwnerNodeWithoutLeadingSlash(PropertyRef propertyRef) {
        String owningNode = propertyRef.owningNode;
        if (owningNode.charAt(0) == '/') {
            return owningNode.substring(1);
        }
        return owningNode;
    }

    private static class PropertyRef {
        private String owningNode;
        private String property;
        private String uuidOfReferencedNode;

        PropertyRef(String owningNode, String property, String uuidOfReferencedNode) {
            this.owningNode = owningNode;
            this.property = property;
            this.uuidOfReferencedNode = uuidOfReferencedNode;
        }
    }
}

