/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.migration;

import com.xebialabs.deployit.migration.ArtifactsMigration;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactDataRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.slf4j.Marker;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u0017\tAA)\u0019;bE\u0006\u001cXM\u0003\u0002\u0004\t\u0005IQ.[4sCRLwN\u001c\u0006\u0003\u000b\u0019\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u0007\u0013-A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003%\u0005\u0013H/\u001b4bGR\u001cX*[4sCRLwN\u001c\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tQa\u001d7gi)T\u0011aG\u0001\tOJL'P\u001f7fI&\u0011Q\u0004\u0007\u0002\b\u0019><w-\u001b8h\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013\u0001\u00063c\u0003J$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\"Q5\t!E\u0003\u0002$I\u0005I\u0011M\u001d;jM\u0006\u001cGo\u001d\u0006\u0003K\u0019\n1a]9m\u0015\t9C!\u0001\u0006sKB|7/\u001b;pefL!!\u000b\u0012\u00031\u0011\u0013\u0017I\u001d;jM\u0006\u001cG\u000fR1uCJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003-!'\rR1uCN#xN]3\u0011\u00055RT\"\u0001\u0018\u000b\u0005=\u0002\u0014A\u00013c\u0015\t\t$'\u0001\u0003eCR\f'BA\u001a5\u0003\u0011\u0019wN]3\u000b\u0005U2\u0014A\u00036bG.\u0014\u0018M\u00192ji*\u0011q\u0007O\u0001\u0007CB\f7\r[3\u000b\u0003e\n1a\u001c:h\u0013\tYdFA\u0006EE\u0012\u000bG/Y*u_J,\u0007\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002%Q\u0014\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b1\u0002\u001e:b]N\f7\r^5p]*\u00111\tO\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0011Q\t\u0011\u0002\u001b!2\fGOZ8s[R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\u0006I!-\u0019;dQNK'0\u001a\t\u0003\u001b%K!A\u0013\b\u0003\u0007%sG\u000fC\u0003M\u0001\u0011\u0005Q*\u0001\u0004=S:LGO\u0010\u000b\u0006\u001d>\u0003\u0016K\u0015\t\u0003'\u0001AQaH&A\u0002\u0001BQaK&A\u00021BQ!P&A\u0002yBQaR&A\u0002!CQ\u0001\u0016\u0001\u0005BU\u000bq!\\5he\u0006$X\rF\u0001W!\tiq+\u0003\u0002Y\u001d\t!QK\\5u\u0001")
public class Database
implements ArtifactsMigration,
Logging {
    private final DbArtifactDataRepository dbArtifactRepository;
    private final DbDataStore dbDataStore;
    private final PlatformTransactionManager transactionManager;
    private final int batchSize;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Database database = this;
        synchronized (database) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public void migrate() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Migrating artifacts from database. Batch size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.batchSize)})));
        Iterator identifiers = this.dbDataStore.getAllIdentifiers();
        IntRef batchCount = IntRef.create((int)0);
        while (identifiers.hasNext()) {
            IntRef count = IntRef.create((int)0);
            ++batchCount.elem;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing batch ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchCount$1.elem)})));
            TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            try {
                try {
                    while (identifiers.hasNext() && count.elem < this.batchSize) {
                        Object object;
                        DataIdentifier id = (DataIdentifier)identifiers.next();
                        String idStr = id.toString();
                        if (this.dbArtifactRepository.exists(idStr)) {
                            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found artifact already migrated: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{idStr})));
                            object = BoxedUnit.UNIT;
                        } else {
                            object = BoxesRunTime.boxToInteger((int)this.dbArtifactRepository.insert(idStr, this.dbDataStore.getRecord(id).getStream()));
                        }
                        ++count.elem;
                    }
                }
                catch (Throwable t) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Error while migrating database artifacts.", (Function0 & Serializable & scala.Serializable)() -> t);
                    transactionStatus.setRollbackOnly();
                    throw t;
                }
            }
            finally {
                if (transactionStatus.isRollbackOnly()) {
                    this.transactionManager.rollback(transactionStatus);
                } else {
                    this.transactionManager.commit(transactionStatus);
                }
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished processing batch ", ". Processed ", " artifacts."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batchCount$1.elem), BoxesRunTime.boxToInteger((int)count$1.elem)})));
        }
    }

    public Database(DbArtifactDataRepository dbArtifactRepository, DbDataStore dbDataStore, PlatformTransactionManager transactionManager, int batchSize) {
        this.dbArtifactRepository = dbArtifactRepository;
        this.dbDataStore = dbDataStore;
        this.transactionManager = transactionManager;
        this.batchSize = batchSize;
        Logging.$init$((Logging)this);
    }
}

