/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.DefaultTimeoutModel;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.SecureTarget;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.TimeoutModel;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.CommonTimer;

public class Snmp
implements Session,
CommandResponder {
    private static final LogAdapter logger = LogFactory.getLogger(Snmp.class);
    private MessageDispatcher messageDispatcher;
    private Map pendingRequests = new Hashtable(50);
    private Map asyncRequests = new Hashtable(50);
    private CommonTimer timer;
    private transient Vector commandResponderListeners;
    private TimeoutModel timeoutModel = new DefaultTimeoutModel();
    private NotificationDispatcher notificationDispatcher = null;
    private ReportHandler reportHandler = new ReportProcessor();

    public Snmp() {
        this.messageDispatcher = new MessageDispatcherImpl();
    }

    protected final void initMessageDispatcher() {
        this.messageDispatcher.addCommandResponder(this);
        this.messageDispatcher.addMessageProcessingModel(new MPv2c());
        this.messageDispatcher.addMessageProcessingModel(new MPv1());
        this.messageDispatcher.addMessageProcessingModel(new MPv3());
        SecurityProtocols.getInstance().addDefaultProtocols();
    }

    public Snmp(TransportMapping transportMapping) {
        this();
        this.initMessageDispatcher();
        if (transportMapping != null) {
            this.addTransportMapping(transportMapping);
        }
    }

    public Snmp(MessageDispatcher messageDispatcher, TransportMapping transportMapping) {
        this.messageDispatcher = messageDispatcher;
        this.messageDispatcher.addCommandResponder(this);
        if (transportMapping != null) {
            this.addTransportMapping(transportMapping);
        }
    }

    public Snmp(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.messageDispatcher.addCommandResponder(this);
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public void addTransportMapping(TransportMapping transportMapping) {
        this.messageDispatcher.addTransportMapping(transportMapping);
        transportMapping.addTransportListener(this.messageDispatcher);
    }

    public void removeTransportMapping(TransportMapping transportMapping) {
        this.messageDispatcher.removeTransportMapping(transportMapping);
        transportMapping.removeTransportListener(this.messageDispatcher);
    }

    public synchronized boolean addNotificationListener(Address address, CommandResponder commandResponder) {
        TransportMapping transportMapping = TransportMappings.getInstance().createTransportMapping(address);
        if (transportMapping == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to add notification listener for address: " + address);
            }
            return false;
        }
        if (transportMapping instanceof ConnectionOrientedTransportMapping) {
            ((ConnectionOrientedTransportMapping)transportMapping).setConnectionTimeout(0L);
        }
        transportMapping.addTransportListener(this.messageDispatcher);
        if (this.notificationDispatcher == null) {
            this.notificationDispatcher = new NotificationDispatcher();
            this.addCommandResponder(this.notificationDispatcher);
        }
        this.notificationDispatcher.addNotificationListener(address, transportMapping, commandResponder);
        try {
            transportMapping.listen();
            if (logger.isInfoEnabled()) {
                logger.info("Added notification listener for address: " + address);
            }
            return true;
        }
        catch (IOException iOException) {
            logger.warn("Failed to initialize notification listener for address '" + address + "': " + iOException.getMessage());
            return false;
        }
    }

    public synchronized boolean removeNotificationListener(Address address) {
        if (this.notificationDispatcher != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Removing notification listener for address: " + address);
            }
            return this.notificationDispatcher.removeNotificationListener(address);
        }
        return false;
    }

    public void listen() throws IOException {
        Iterator iterator = this.messageDispatcher.getTransportMappings().iterator();
        while (iterator.hasNext()) {
            TransportMapping transportMapping = (TransportMapping)iterator.next();
            if (transportMapping.isListening()) continue;
            transportMapping.listen();
        }
    }

    public int getNextRequestID() {
        return this.messageDispatcher.getNextRequestID();
    }

    public void close() throws IOException {
        Object object;
        Object object2 = this.messageDispatcher.getTransportMappings().iterator();
        while (object2.hasNext()) {
            object = (TransportMapping)object2.next();
            if (!object.isListening()) continue;
            object.close();
        }
        object2 = this.timer;
        this.timer = null;
        if (object2 != null) {
            object2.cancel();
        }
        object = this.pendingRequests.values().iterator();
        while (object.hasNext()) {
            PendingRequest pendingRequest = (PendingRequest)object.next();
            ResponseEvent responseEvent = new ResponseEvent(this, null, pendingRequest.pdu, null, pendingRequest.userObject, new InterruptedException("Snmp session has been closed"));
            pendingRequest.listener.onResponse(responseEvent);
        }
        if (this.notificationDispatcher != null) {
            this.notificationDispatcher.closeAll();
        }
    }

    public ResponseEvent get(PDU pDU, Target target) throws IOException {
        pDU.setType(-96);
        return this.send(pDU, target);
    }

    public void get(PDU pDU, Target target, Object object, ResponseListener responseListener) throws IOException {
        pDU.setType(-96);
        this.send(pDU, target, object, responseListener);
    }

    public ResponseEvent getNext(PDU pDU, Target target) throws IOException {
        pDU.setType(-95);
        return this.send(pDU, target);
    }

    public void getNext(PDU pDU, Target target, Object object, ResponseListener responseListener) throws IOException {
        pDU.setType(-95);
        this.send(pDU, target, object, responseListener);
    }

    public ResponseEvent getBulk(PDU pDU, Target target) throws IOException {
        pDU.setType(-91);
        return this.send(pDU, target);
    }

    public void getBulk(PDU pDU, Target target, Object object, ResponseListener responseListener) throws IOException {
        pDU.setType(-91);
        this.send(pDU, target, object, responseListener);
    }

    public ResponseEvent inform(PDU pDU, Target target) throws IOException {
        pDU.setType(-90);
        return this.send(pDU, target);
    }

    public void inform(PDU pDU, Target target, Object object, ResponseListener responseListener) throws IOException {
        pDU.setType(-90);
        this.send(pDU, target, object, responseListener);
    }

    public void trap(PDUv1 pDUv1, Target target) throws IOException {
        if (target.getVersion() != 0) {
            throw new IllegalArgumentException("SNMPv1 trap PDU must be used with SNMPv1");
        }
        pDUv1.setType(-92);
        this.send(pDUv1, target);
    }

    public void notify(PDU pDU, Target target) throws IOException {
        if (target.getVersion() == 0) {
            throw new IllegalArgumentException("Notifications PDUs cannot be used with SNMPv1");
        }
        pDU.setType(-89);
        this.send(pDU, target);
    }

    public ResponseEvent set(PDU pDU, Target target) {
        pDU.setType(-93);
        try {
            return this.send(pDU, target);
        }
        catch (IOException iOException) {
            return new ResponseEvent(this, null, pDU, null, target, iOException);
        }
    }

    public void set(PDU pDU, Target target, Object object, ResponseListener responseListener) throws IOException {
        pDU.setType(-93);
        this.send(pDU, target, object, responseListener);
    }

    public ResponseEvent send(PDU pDU, Target target) throws IOException {
        return this.send(pDU, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEvent send(PDU pDU, Target target, TransportMapping transportMapping) throws IOException {
        if (!pDU.isConfirmedPdu()) {
            this.sendMessage(pDU, target, transportMapping, null);
            return null;
        }
        if (this.timer == null) {
            this.createPendingTimer();
        }
        SyncResponseListener syncResponseListener = new SyncResponseListener();
        PendingRequest pendingRequest = null;
        SyncResponseListener syncResponseListener2 = syncResponseListener;
        synchronized (syncResponseListener2) {
            PduHandle pduHandle = null;
            PendingRequest pendingRequest2 = new PendingRequest(syncResponseListener, target, pDU, target, transportMapping);
            pduHandle = this.sendMessage(pDU, target, transportMapping, pendingRequest2);
            try {
                syncResponseListener.wait();
                pendingRequest = (PendingRequest)this.pendingRequests.remove(pduHandle);
                if (logger.isDebugEnabled()) {
                    logger.debug("Removed pending request with handle: " + pduHandle);
                }
                pendingRequest2.setFinished();
                pendingRequest2.cancel();
            }
            catch (InterruptedException interruptedException) {
                logger.warn(interruptedException);
                pendingRequest2.setFinished();
                pendingRequest2.cancel();
                pendingRequest = (PendingRequest)this.pendingRequests.remove(pduHandle);
                if (pendingRequest != null) {
                    pendingRequest.setFinished();
                    pendingRequest.cancel();
                }
                Thread.currentThread().interrupt();
            }
            finally {
                if (!pendingRequest2.finished && (pendingRequest = (PendingRequest)this.pendingRequests.remove(pduHandle)) != null) {
                    pendingRequest.setFinished();
                    pendingRequest.cancel();
                }
            }
        }
        if (pendingRequest != null) {
            pendingRequest.setFinished();
            pendingRequest.cancel();
        }
        return syncResponseListener.response;
    }

    private synchronized void createPendingTimer() {
        if (this.timer == null) {
            this.timer = SNMP4JSettings.getTimerFactory().createTimer();
        }
    }

    public void send(PDU pDU, Target target, Object object, ResponseListener responseListener) throws IOException {
        this.send(pDU, target, null, object, responseListener);
    }

    public void send(PDU pDU, Target target, TransportMapping transportMapping, Object object, ResponseListener responseListener) throws IOException {
        if (!pDU.isConfirmedPdu()) {
            this.sendMessage(pDU, target, transportMapping, null);
            return;
        }
        if (this.timer == null) {
            this.createPendingTimer();
        }
        AsyncPendingRequest asyncPendingRequest = new AsyncPendingRequest(responseListener, object, pDU, target, transportMapping);
        this.sendMessage(pDU, target, transportMapping, asyncPendingRequest);
    }

    public PDU sendPDU(PDU pDU, Target target) throws IOException {
        ResponseEvent responseEvent = this.send(pDU, target);
        if (responseEvent != null) {
            return responseEvent.getResponse();
        }
        return null;
    }

    public void sendPDU(PDU pDU, Target target, Object object, ResponseListener responseListener) throws IOException {
        this.send(pDU, target, object, responseListener);
    }

    protected PduHandle sendMessage(PDU pDU, Target target, TransportMapping transportMapping, PduHandleCallback pduHandleCallback) throws IOException {
        PduHandle pduHandle = null;
        if (target instanceof SecureTarget) {
            SecureTarget secureTarget = (SecureTarget)target;
            pduHandle = this.messageDispatcher.sendPdu(transportMapping, secureTarget.getAddress(), secureTarget.getVersion(), secureTarget.getSecurityModel(), secureTarget.getSecurityName().getValue(), secureTarget.getSecurityLevel(), pDU, true, pduHandleCallback);
        } else if (target instanceof CommunityTarget) {
            CommunityTarget communityTarget = (CommunityTarget)target;
            int n = 2;
            if (communityTarget.getVersion() == 0) {
                n = 1;
            }
            pduHandle = this.messageDispatcher.sendPdu(transportMapping, communityTarget.getAddress(), communityTarget.getVersion(), n, communityTarget.getCommunity().getValue(), 1, pDU, true, pduHandleCallback);
        }
        return pduHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(PDU pDU, ResponseListener responseListener) {
        PendingRequest pendingRequest;
        AsyncRequestKey asyncRequestKey = new AsyncRequestKey(pDU, responseListener);
        PduHandle pduHandle = (PduHandle)this.asyncRequests.remove(asyncRequestKey);
        if (logger.isDebugEnabled()) {
            logger.debug("Cancelling pending request with handle " + pduHandle);
        }
        if (pduHandle != null && (pendingRequest = (PendingRequest)this.pendingRequests.remove(pduHandle)) != null) {
            PendingRequest pendingRequest2 = pendingRequest;
            synchronized (pendingRequest2) {
                pendingRequest.setFinished();
                pendingRequest.cancel();
            }
        }
    }

    public void setLocalEngine(byte[] byArray, int n, int n2) {
        MPv3 mPv3 = this.getMPv3();
        mPv3.setLocalEngineID(byArray);
        USM uSM = (USM)mPv3.getSecurityModel(3);
        uSM.setLocalEngine(new OctetString(byArray), n, n2);
    }

    public byte[] getLocalEngineID() {
        return this.getMPv3().getLocalEngineID();
    }

    private MPv3 getMPv3() {
        MPv3 mPv3 = (MPv3)this.getMessageProcessingModel(3);
        if (mPv3 == null) {
            throw new NoSuchElementException("MPv3 not available");
        }
        return mPv3;
    }

    public byte[] discoverAuthoritativeEngineID(Address address, long l) {
        Object object;
        MPv3 mPv3 = this.getMPv3();
        OctetString octetString = mPv3.removeEngineID(address);
        if (octetString != null && (object = this.getUSM()) != null) {
            ((USM)object).removeEngineTime(octetString);
        }
        object = new ScopedPDU();
        ((PDU)object).setType(-96);
        UserTarget userTarget = new UserTarget();
        userTarget.setTimeout(l);
        userTarget.setAddress(address);
        try {
            this.send((PDU)object, userTarget);
            OctetString octetString2 = mPv3.getEngineID(address);
            if (octetString2 == null) {
                return null;
            }
            return new OctetString(octetString2.getValue()).getValue();
        }
        catch (IOException iOException) {
            logger.error("IO error while trying to discover authoritative engine ID: " + iOException);
            return null;
        }
    }

    public USM getUSM() {
        return (USM)SecurityModels.getInstance().getSecurityModel(new Integer32(3));
    }

    public MessageProcessingModel getMessageProcessingModel(int n) {
        return this.messageDispatcher.getMessageProcessingModel(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPdu(CommandResponderEvent commandResponderEvent) {
        PduHandle pduHandle = commandResponderEvent.getPduHandle();
        PDU pDU = commandResponderEvent.getPDU();
        if (pDU.getType() == -94) {
            PendingRequest pendingRequest;
            commandResponderEvent.setProcessed(true);
            if (logger.isDebugEnabled()) {
                logger.debug("Looking up pending request with handle " + pduHandle);
            }
            Map map = this.pendingRequests;
            synchronized (map) {
                pendingRequest = (PendingRequest)this.pendingRequests.get(pduHandle);
                if (pendingRequest != null) {
                    pendingRequest.responseReceived();
                }
            }
            if (pendingRequest == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Received response that cannot be matched to any outstanding request, address=" + commandResponderEvent.getPeerAddress() + ", requestID=" + pDU.getRequestID());
                }
            } else {
                pendingRequest.listener.onResponse(new ResponseEvent(this, commandResponderEvent.getPeerAddress(), pendingRequest.pdu, pDU, pendingRequest.userObject));
            }
        } else if (pDU.getType() == -88) {
            commandResponderEvent.setProcessed(true);
            this.reportHandler.processReport(pduHandle, commandResponderEvent);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Fire process PDU event: " + commandResponderEvent.toString());
            }
            this.fireProcessPdu(commandResponderEvent);
        }
    }

    public synchronized void removeCommandResponder(CommandResponder commandResponder) {
        if (this.commandResponderListeners != null && this.commandResponderListeners.contains(commandResponder)) {
            Vector vector = (Vector)this.commandResponderListeners.clone();
            vector.removeElement(commandResponder);
            this.commandResponderListeners = vector;
        }
    }

    public synchronized void addCommandResponder(CommandResponder commandResponder) {
        Vector vector;
        Vector vector2 = vector = this.commandResponderListeners == null ? new Vector(2) : (Vector)this.commandResponderListeners.clone();
        if (!vector.contains(commandResponder)) {
            vector.addElement(commandResponder);
            this.commandResponderListeners = vector;
        }
    }

    protected void fireProcessPdu(CommandResponderEvent commandResponderEvent) {
        if (this.commandResponderListeners != null) {
            Vector vector = this.commandResponderListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CommandResponder)vector.get(i)).processPdu(commandResponderEvent);
                if (!commandResponderEvent.isProcessed()) continue;
                return;
            }
        }
    }

    public TimeoutModel getTimeoutModel() {
        return this.timeoutModel;
    }

    public ReportHandler getReportHandler() {
        return this.reportHandler;
    }

    public void setTimeoutModel(TimeoutModel timeoutModel) {
        if (timeoutModel == null) {
            throw new NullPointerException("Timeout model cannot be null");
        }
        this.timeoutModel = timeoutModel;
    }

    public void setReportHandler(ReportHandler reportHandler) {
        if (reportHandler == null) {
            throw new IllegalArgumentException("ReportHandler must not be null");
        }
        this.reportHandler = reportHandler;
    }

    class NotificationDispatcher
    implements CommandResponder {
        private Hashtable notificationListeners = new Hashtable(10);
        private Hashtable notificationTransports = new Hashtable(10);

        protected NotificationDispatcher() {
        }

        public synchronized void addNotificationListener(Address address, TransportMapping transportMapping, CommandResponder commandResponder) {
            this.notificationListeners.put(address, transportMapping);
            this.notificationTransports.put(transportMapping, commandResponder);
        }

        public synchronized boolean removeNotificationListener(Address address) {
            block3: {
                TransportMapping transportMapping = (TransportMapping)this.notificationListeners.remove(address);
                if (transportMapping == null) {
                    return false;
                }
                transportMapping.removeTransportListener(Snmp.this.messageDispatcher);
                this.notificationTransports.remove(transportMapping);
                try {
                    transportMapping.close();
                }
                catch (IOException iOException) {
                    logger.error(iOException);
                    if (!logger.isDebugEnabled()) break block3;
                    iOException.printStackTrace();
                }
            }
            return true;
        }

        public synchronized void closeAll() {
            this.notificationTransports.clear();
            Iterator iterator = this.notificationListeners.values().iterator();
            while (iterator.hasNext()) {
                TransportMapping transportMapping = (TransportMapping)iterator.next();
                try {
                    transportMapping.close();
                }
                catch (IOException iOException) {
                    logger.error(iOException);
                    if (!logger.isDebugEnabled()) continue;
                    iOException.printStackTrace();
                }
            }
            this.notificationListeners.clear();
        }

        public synchronized void processPdu(CommandResponderEvent commandResponderEvent) {
            CommandResponder commandResponder;
            block4: {
                commandResponder = (CommandResponder)this.notificationTransports.get(commandResponderEvent.getTransportMapping());
                if (commandResponderEvent.getPDU() != null && commandResponderEvent.getPDU().getType() == -90) {
                    try {
                        this.sendInformResponse(commandResponderEvent);
                    }
                    catch (MessageException messageException) {
                        if (!logger.isWarnEnabled()) break block4;
                        logger.warn("Failed to send response on INFORM PDU event (" + commandResponderEvent + "): " + messageException.getMessage());
                    }
                }
            }
            if (commandResponder != null) {
                commandResponder.processPdu(commandResponderEvent);
            }
        }

        protected void sendInformResponse(CommandResponderEvent commandResponderEvent) throws MessageException {
            PDU pDU = (PDU)commandResponderEvent.getPDU().clone();
            pDU.setType(-94);
            pDU.setErrorStatus(0);
            pDU.setErrorIndex(0);
            Snmp.this.messageDispatcher.returnResponsePdu(commandResponderEvent.getMessageProcessingModel(), commandResponderEvent.getSecurityModel(), commandResponderEvent.getSecurityName(), commandResponderEvent.getSecurityLevel(), pDU, commandResponderEvent.getMaxSizeResponsePDU(), commandResponderEvent.getStateReference(), new StatusInformation());
        }
    }

    static class SyncResponseListener
    implements ResponseListener {
        private ResponseEvent response = null;

        SyncResponseListener() {
        }

        public synchronized void onResponse(ResponseEvent responseEvent) {
            this.response = responseEvent;
            this.notify();
        }

        public ResponseEvent getResponse() {
            return this.response;
        }
    }

    static class AsyncRequestKey {
        private PDU request;
        private ResponseListener listener;

        public AsyncRequestKey(PDU pDU, ResponseListener responseListener) {
            this.request = pDU;
            this.listener = responseListener;
        }

        public boolean equals(Object object) {
            if (object instanceof AsyncRequestKey) {
                AsyncRequestKey asyncRequestKey = (AsyncRequestKey)object;
                return this.request.equals(asyncRequestKey.request) && this.listener.equals(asyncRequestKey.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.request.hashCode();
        }
    }

    class AsyncPendingRequest
    extends PendingRequest {
        public AsyncPendingRequest(ResponseListener responseListener, Object object, PDU pDU, Target target, TransportMapping transportMapping) {
            super(responseListener, object, pDU, target, transportMapping);
        }

        protected void registerRequest(PduHandle pduHandle) {
            AsyncRequestKey asyncRequestKey = new AsyncRequestKey(this.pdu, this.listener);
            Snmp.this.asyncRequests.put(asyncRequestKey, pduHandle);
        }
    }

    class PendingRequest
    extends TimerTask
    implements PduHandleCallback {
        private PduHandle key;
        protected int retryCount;
        protected ResponseListener listener;
        protected Object userObject;
        protected PDU pdu;
        protected Target target;
        protected TransportMapping transport;
        private int requestStatus = 0;
        private int maxRequestStatus = 2;
        private volatile boolean finished = false;
        private volatile boolean responseReceived = false;

        public PendingRequest(ResponseListener responseListener, Object object, PDU pDU, Target target, TransportMapping transportMapping) {
            this.userObject = object;
            this.listener = responseListener;
            this.retryCount = target.getRetries();
            this.pdu = pDU;
            this.target = (Target)target.clone();
            this.transport = transportMapping;
        }

        private PendingRequest(PendingRequest pendingRequest) {
            this.userObject = pendingRequest.userObject;
            this.listener = pendingRequest.listener;
            this.retryCount = pendingRequest.retryCount - 1;
            this.pdu = pendingRequest.pdu;
            this.target = pendingRequest.target;
            this.requestStatus = pendingRequest.requestStatus;
            this.responseReceived = pendingRequest.responseReceived;
            this.transport = pendingRequest.transport;
        }

        protected void registerRequest(PduHandle pduHandle) {
        }

        public void responseReceived() {
            this.responseReceived = true;
        }

        public synchronized void pduHandleAssigned(PduHandle pduHandle, Object object) {
            if (this.key == null) {
                this.key = pduHandle;
                Snmp.this.pendingRequests.put(pduHandle, this);
                this.registerRequest(pduHandle);
                if (logger.isDebugEnabled()) {
                    logger.debug("Running pending " + (this.listener instanceof SyncResponseListener ? "sync" : "async") + " request with handle " + pduHandle + " and retry count left " + this.retryCount);
                }
                long l = Snmp.this.timeoutModel.getRetryTimeout(this.target.getRetries() - this.retryCount, this.target.getRetries(), this.target.getTimeout());
                if (!this.finished && !this.responseReceived) {
                    Snmp.this.timer.schedule(this, l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            PduHandle pduHandle = this.key;
            PDU pDU = this.pdu;
            Target target = this.target;
            TransportMapping transportMapping = this.transport;
            ResponseListener responseListener = this.listener;
            Object object = this.userObject;
            if (pduHandle == null || pDU == null || target == null || responseListener == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("PendingRequest canceled key=" + pduHandle + ", pdu=" + pDU + ", target=" + target + ", transport=" + transportMapping + ", listener=" + responseListener);
                }
                return;
            }
            try {
                boolean bl;
                Object object2 = Snmp.this.pendingRequests;
                synchronized (object2) {
                    bl = !this.finished && this.retryCount > 0 && !this.responseReceived;
                }
                if (bl) {
                    try {
                        object2 = new PendingRequest(this);
                        Snmp.this.sendMessage(pDU, target, transportMapping, (PduHandleCallback)object2);
                    }
                    catch (IOException iOException) {
                        this.finished = true;
                        logger.error("Failed to send SNMP message to " + target + ": " + iOException.getMessage());
                        Snmp.this.messageDispatcher.releaseStateReference(target.getVersion(), pduHandle);
                        this.listener.onResponse(new ResponseEvent(Snmp.this, null, pDU, null, object, iOException));
                    }
                } else if (!this.finished) {
                    this.finished = true;
                    Snmp.this.pendingRequests.remove(pduHandle);
                    if (!this.responseReceived) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Request timed out: " + pduHandle.getTransactionID());
                        }
                        Snmp.this.messageDispatcher.releaseStateReference(target.getVersion(), pduHandle);
                        this.listener.onResponse(new ResponseEvent(Snmp.this, null, pDU, null, object));
                    }
                } else {
                    Snmp.this.pendingRequests.remove(pduHandle);
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                logger.error("Failed to process pending request " + pduHandle + " because " + runtimeException.getMessage(), runtimeException);
                throw runtimeException;
            }
            catch (Error error) {
                if (logger.isDebugEnabled()) {
                    error.printStackTrace();
                }
                logger.fatal("Failed to process pending request " + pduHandle + " because " + error.getMessage(), error);
                throw error;
            }
        }

        public boolean setFinished() {
            boolean bl = this.finished;
            this.finished = true;
            return bl;
        }

        public void setMaxRequestStatus(int n) {
            this.maxRequestStatus = n;
        }

        public int getMaxRequestStatus() {
            return this.maxRequestStatus;
        }

        public boolean isResponseReceived() {
            return this.responseReceived;
        }

        public boolean cancel() {
            boolean bl = super.cancel();
            this.key = null;
            this.pdu = null;
            this.target = null;
            this.transport = null;
            this.listener = null;
            this.userObject = null;
            return bl;
        }
    }

    class ReportProcessor
    implements ReportHandler {
        ReportProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processReport(PduHandle pduHandle, CommandResponderEvent commandResponderEvent) {
            boolean bl;
            PDU pDU = commandResponderEvent.getPDU();
            logger.debug("Searching pending request with handle" + pduHandle);
            PendingRequest pendingRequest = (PendingRequest)Snmp.this.pendingRequests.get(pduHandle);
            if (pendingRequest == null) {
                logger.warn("Unmatched report PDU received from " + commandResponderEvent.getPeerAddress());
                return;
            }
            if (pDU.size() == 0) {
                logger.error("Illegal report PDU received from " + commandResponderEvent.getPeerAddress() + " missing report variable binding");
                return;
            }
            VariableBinding variableBinding = pDU.get(0);
            if (variableBinding == null) {
                logger.error("Received illegal REPORT PDU from " + commandResponderEvent.getPeerAddress());
                return;
            }
            OID oID = variableBinding.getOid();
            boolean bl2 = false;
            if (pendingRequest.requestStatus < pendingRequest.maxRequestStatus) {
                switch (pendingRequest.requestStatus) {
                    case 0: {
                        if (SnmpConstants.usmStatsUnknownEngineIDs.equals(oID)) {
                            bl2 = true;
                            break;
                        }
                        if (!SnmpConstants.usmStatsNotInTimeWindows.equals(oID)) break;
                        pendingRequest.requestStatus++;
                        bl2 = true;
                        break;
                    }
                    case 1: {
                        if (!SnmpConstants.usmStatsNotInTimeWindows.equals(oID)) break;
                        bl2 = true;
                    }
                }
            }
            if (bl2) {
                logger.debug("Send new request after report.");
                pendingRequest.requestStatus++;
                try {
                    PduHandle pduHandle2 = Snmp.this.sendMessage(pendingRequest.pdu, pendingRequest.target, commandResponderEvent.getTransportMapping(), null);
                    pendingRequest.key = pduHandle2;
                }
                catch (IOException iOException) {
                    logger.error("Failed to send message to " + pendingRequest.target + ": " + iOException.getMessage());
                    return;
                }
            }
            ResponseListener responseListener = pendingRequest.listener;
            PDU pDU2 = pendingRequest.pdu;
            Object object = pendingRequest.userObject;
            PendingRequest pendingRequest2 = pendingRequest;
            synchronized (pendingRequest2) {
                bl = pendingRequest.cancel();
            }
            Snmp.this.pendingRequests.remove(pduHandle);
            if (bl) {
                responseListener.onResponse(new ResponseEvent(this, commandResponderEvent.getPeerAddress(), pDU2, pDU, object));
            } else if (logger.isInfoEnabled()) {
                logger.info("Received late report from " + commandResponderEvent.getPeerAddress() + " with request ID " + pDU.getRequestID());
            }
        }
    }

    public static interface ReportHandler {
        public void processReport(PduHandle var1, CommandResponderEvent var2);
    }
}

