/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.inspection.InspectionContext;
import com.xebialabs.deployit.inspection.InspectionContextAdapter;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inspector {
    private static final Logger logger = LoggerFactory.getLogger(Inspector.class);

    public static void inspect(ConfigurationItem item, com.xebialabs.deployit.plugin.api.inspection.InspectionContext context) {
        Inspector.checkRequiredDiscoveryProperties(item);
        Method inspectMethod = Inspector.findInspectMethod(item);
        if (inspectMethod != null) {
            logger.debug("Invoking @Inspect method on {}", (Object)item);
            Class<?>[] parameterTypes = inspectMethod.getParameterTypes();
            if (parameterTypes[0].equals(InspectionPlanningContext.class)) {
                Inspector.callInspectionMethod(inspectMethod, item, new InspectionContextAdapter(context));
            } else if (parameterTypes[0].equals(com.xebialabs.deployit.plugin.api.inspection.InspectionContext.class)) {
                Inspector.callInspectionMethod(inspectMethod, item, context);
            }
            context.inspected(item);
        }
    }

    private static void callInspectionMethod(Method inspectMethod, ConfigurationItem item, Object ctx) {
        try {
            inspectMethod.invoke((Object)item, ctx);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot invoke @Inspect method on " + item, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot invoke @Inspect method on " + item, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error invoking @Inspect method on " + item, e);
        }
    }

    @Deprecated
    public List<InspectionStep> getInspectionSteps(ConfigurationItem item, Map<String, Object> taskAttributes) {
        InspectionContext context = new InspectionContext(taskAttributes);
        Inspector.inspectConfigurationItem(item, context);
        return context.getSteps();
    }

    @Deprecated
    public List<ConfigurationItem> inspect(ConfigurationItem item, ExecutionContext originalContext) {
        InspectionContext context = new InspectionContext(originalContext);
        return this.doInspect(item, context);
    }

    @Deprecated
    public List<ConfigurationItem> inspect(ConfigurationItem item, Map<String, Object> taskAttributes) {
        InspectionContext context = new InspectionContext(taskAttributes);
        return this.doInspect(item, context);
    }

    private List<ConfigurationItem> doInspect(ConfigurationItem item, InspectionContext context) {
        InspectionStep step2;
        logger.debug("Inspecting {}", (Object)item);
        Inspector.inspectConfigurationItem(item, context);
        while ((step2 = context.getNextStep()) != null) {
            Step.Result result;
            logger.debug("Invoking inspection step: {}", (Object)step2.getDescription());
            try {
                context.startStepExecution(step2);
                result = step2.execute((ExecutionContext)context);
            }
            catch (Exception exc) {
                throw new RuntimeException(String.format("Step '%s' failed with exception: %s", step2.getDescription(), exc.toString()), exc);
            }
            if (result == Step.Result.Fail) {
                String lastErrorMessage = this.getLastMessageFromLogs(context.getCapturedError());
                if (lastErrorMessage != null) {
                    throw new RuntimeException(String.format("Step '%s' failed with error: %s", step2.getDescription(), lastErrorMessage));
                }
                throw new RuntimeException(String.format("Step '%s' failed without any output to stderr", step2.getDescription()));
            }
            this.inspectNewDiscoveredConfigurationItems(context);
        }
        return Lists.newArrayList(context.getInspected().values());
    }

    private String getLastMessageFromLogs(List<String> messages) {
        if (messages.size() > 0) {
            ListIterator<String> reverseIterator = messages.listIterator(messages.size());
            while (reverseIterator.hasPrevious()) {
                String message = reverseIterator.previous();
                if (message == null || message.length() == 0) continue;
                return message;
            }
        }
        return null;
    }

    private void inspectNewDiscoveredConfigurationItems(InspectionContext ctx) {
        for (ConfigurationItem configurationItem : Lists.newArrayList(ctx.getDiscovered().values())) {
            Inspector.inspectConfigurationItem(configurationItem, ctx);
        }
    }

    private static void inspectConfigurationItem(ConfigurationItem item, InspectionContext ctx) {
        Inspector.checkRequiredDiscoveryProperties(item);
        Method inspectMethod = Inspector.findInspectMethod(item);
        if (inspectMethod != null) {
            try {
                logger.debug("Invoking @Inspect method on {}", (Object)item);
                inspectMethod.invoke((Object)item, ctx);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Cannot invoke @Inspect method on " + item, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot invoke @Inspect method on " + item, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error invoking @Inspect method on " + item, e);
            }
        }
        ctx.inspected(item);
    }

    private static void checkRequiredDiscoveryProperties(ConfigurationItem item) {
        Descriptor descriptor = item.getType().getDescriptor();
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object o;
            if (!propertyDescriptor.isInspectionProperty() || !propertyDescriptor.isRequiredForInspection() || (o = propertyDescriptor.get(item)) != null) continue;
            throw new IllegalArgumentException("Missing required property for discovery " + propertyDescriptor.getName());
        }
    }

    private static Method findInspectMethod(ConfigurationItem item) {
        Method[] methods;
        for (Method method : methods = item.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Inspect.class)) continue;
            return method;
        }
        return null;
    }
}

