/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableImageHandler;
import io.aeron.ClientConductor;
import io.aeron.EndOfStreamHandler;
import io.aeron.Image;
import io.aeron.SubscriptionFields;
import io.aeron.UnavailableImageHandler;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.RawBlockHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.collections.ArrayUtil;

public class Subscription
extends SubscriptionFields
implements AutoCloseable {
    protected long p16;
    protected long p17;
    protected long p18;
    protected long p19;
    protected long p20;
    protected long p21;
    protected long p22;
    protected long p23;
    protected long p24;
    protected long p25;
    protected long p26;
    protected long p27;
    protected long p28;
    protected long p29;
    protected long p30;

    Subscription(ClientConductor conductor, String channel, int streamId, long registrationId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        super(registrationId, streamId, conductor, channel, availableImageHandler, unavailableImageHandler);
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public AvailableImageHandler availableImageHandler() {
        return this.availableImageHandler;
    }

    public UnavailableImageHandler unavailableImageHandler() {
        return this.unavailableImageHandler;
    }

    public int pollEndOfStreams(EndOfStreamHandler endOfStreamHandler) {
        int numEndOfStreams = 0;
        for (Image image : this.images) {
            if (!image.isEndOfStream()) continue;
            ++numEndOfStreams;
            endOfStreamHandler.onEndOfStream(image);
        }
        return numEndOfStreams;
    }

    public int poll(FragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public int controlledPoll(ControlledFragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public long blockPoll(BlockHandler blockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.blockPoll(blockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public long rawPoll(RawBlockHandler rawBlockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.rawPoll(rawBlockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public boolean isConnected() {
        return this.images.length > 0;
    }

    public boolean hasNoImages() {
        return this.images.length == 0;
    }

    public int imageCount() {
        return this.images.length;
    }

    public Image imageBySessionId(int sessionId) {
        Image result = null;
        for (Image image : this.images) {
            if (sessionId != image.sessionId()) continue;
            result = image;
            break;
        }
        return result;
    }

    public Image imageAtIndex(int index) {
        return this.images[index];
    }

    public List<Image> images() {
        return Collections.unmodifiableList(Arrays.asList(this.images));
    }

    public void forEachImage(Consumer<Image> consumer) {
        for (Image image : this.images) {
            consumer.accept(image);
        }
    }

    @Override
    public void close() {
        this.conductor.releaseSubscription(this);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long channelStatus() {
        if (this.isClosed) {
            return -1L;
        }
        return this.conductor.channelStatus(this.channelStatusId);
    }

    void channelStatusId(int id) {
        this.channelStatusId = id;
    }

    int channelStatusId() {
        return this.channelStatusId;
    }

    void internalClose() {
        this.isClosed = true;
        this.closeImages();
    }

    boolean containsImage(long correlationId) {
        return this.imageIdSet.contains(correlationId);
    }

    void addImage(Image image) {
        if (this.isClosed) {
            image.close();
            this.conductor.releaseImage(image);
        } else if (this.imageIdSet.add(image.correlationId())) {
            this.images = (Image[])ArrayUtil.add((Object[])this.images, (Object)image);
        }
    }

    Image removeImage(long correlationId) {
        Object[] oldArray = this.images;
        Image removedImage = null;
        if (this.imageIdSet.remove(correlationId)) {
            int i = 0;
            for (Image image : oldArray) {
                if (image.correlationId() == correlationId) {
                    removedImage = image;
                    break;
                }
                ++i;
            }
            this.images = (Image[])ArrayUtil.remove((Object[])oldArray, (int)i);
            removedImage.close();
            this.conductor.releaseImage(removedImage);
        }
        return removedImage;
    }

    private void closeImages() {
        Image[] images = this.images;
        this.images = EMPTY_ARRAY;
        for (Image image : images) {
            image.close();
        }
        this.imageIdSet.clear();
        for (Image image : images) {
            this.conductor.releaseImage(image);
            try {
                if (null == this.unavailableImageHandler) continue;
                this.unavailableImageHandler.onUnavailableImage(image);
            }
            catch (Throwable ex) {
                this.conductor.handleError(ex);
            }
        }
    }
}

