/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
public class Deployment
extends AbstractDto {
    private String id;
    private ConfigurationItem deployedApplication;
    private List<ConfigurationItem> deployeds = new ArrayList<ConfigurationItem>();
    private List<ConfigurationItemId> deployables = new ArrayList<ConfigurationItemId>();
    private List<ConfigurationItemId> containers = new ArrayList<ConfigurationItemId>();
    private List<Deployment> requiredDeployments = new ArrayList<Deployment>();
    private Set<ResolvedPlaceholder> resolvedPlaceholders = new HashSet<ResolvedPlaceholder>();
    private int deploymentGroupIndex;
    private DeploymentType deploymentType;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConfigurationItem getDeployedApplication() {
        return this.deployedApplication;
    }

    public List<ConfigurationItem> getDeployeds() {
        return this.deployeds;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public void setDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    public boolean isOfType(DeploymentType type) {
        return this.deploymentType == type;
    }

    public void setDeployedApplication(ConfigurationItem deployedApplication) {
        this.deployedApplication = deployedApplication;
    }

    public void setDeployeds(List<ConfigurationItem> deployeds) {
        this.deployeds = deployeds;
    }

    public void add(ConfigurationItem object) {
        this.deployeds.add(object);
    }

    public void addAll(List<ConfigurationItem> deployeds) {
        this.deployeds.addAll(deployeds);
    }

    public String getVersion() {
        return (String)this.deployedApplication.getProperty("version");
    }

    public String getEnvironment() {
        return (String)this.deployedApplication.getProperty("environment");
    }

    public List<ConfigurationItemId> getDeployables() {
        return this.deployables;
    }

    public void setDeployables(List<ConfigurationItemId> deployables) {
        this.deployables = deployables;
    }

    public List<ConfigurationItemId> getContainers() {
        return this.containers;
    }

    public void setContainers(List<ConfigurationItemId> containers) {
        this.containers = containers;
    }

    public List<Deployment> getRequiredDeployments() {
        return this.requiredDeployments;
    }

    public List<List<Deployment>> getGroupedRequiredDeployments() {
        Map<Integer, List<Deployment>> collect = this.requiredDeployments.stream().collect(Collectors.groupingBy(Deployment::getDeploymentGroupIndex));
        ArrayList<Integer> keys = new ArrayList<Integer>(collect.keySet());
        Collections.sort(keys);
        return keys.stream().map(collect::get).collect(Collectors.toList());
    }

    public void setGroupedRequiredDeployments(List<List<Deployment>> dependencies) {
        for (int i = 0; i < dependencies.size(); ++i) {
            int index = i;
            dependencies.get(i).forEach(x -> x.setDeploymentGroupIndex(index + 1));
        }
        this.requiredDeployments = dependencies.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public int getDeploymentGroupIndex() {
        return this.deploymentGroupIndex;
    }

    public void setDeploymentGroupIndex(int deploymentGroupIndex) {
        this.deploymentGroupIndex = deploymentGroupIndex;
    }

    public void setRequiredDeployments(List<Deployment> requiredDeployments) {
        this.requiredDeployments = requiredDeployments;
    }

    public Set<ResolvedPlaceholder> getResolvedPlaceholders() {
        return this.resolvedPlaceholders;
    }

    public void addResolvedPlaceholders(Set<ResolvedPlaceholder> resolvedPlaceholders) {
        this.resolvedPlaceholders.addAll(resolvedPlaceholders);
    }

    public void setResolvedPlaceholders(Set<ResolvedPlaceholder> resolvedPlaceholders) {
        this.resolvedPlaceholders = resolvedPlaceholders;
    }

    @PublicApiRef
    public static enum DeploymentType {
        INITIAL,
        UPDATE,
        UNDEPLOYMENT;

    }
}

