/*
 * Decompiled with CFR 0.152.
 */
package kamon.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kamon.util.PathFilter;

public final class GlobPathFilter
implements PathFilter {
    private static final Pattern GLOB_PATTERN = Pattern.compile("(\\*\\*?)|(\\?)|(\\\\.)|(/+)|([^*?]+)");
    private final String glob;
    private final Pattern pattern;

    public GlobPathFilter(String string) {
        this.pattern = GlobPathFilter.getGlobPattern(string);
        this.glob = string;
    }

    @Override
    public boolean accept(String string) {
        return this.pattern.matcher(string).matches();
    }

    private static Pattern getGlobPattern(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = GLOB_PATTERN.matcher(string);
        boolean bl = false;
        while (matcher.find()) {
            bl = false;
            String string2 = matcher.group(1);
            if (string2 != null) {
                if (string2.length() == 2) {
                    stringBuilder.append(".*");
                    continue;
                }
                stringBuilder.append("[^/]*");
                continue;
            }
            string2 = matcher.group(2);
            if (string2 != null) {
                stringBuilder.append("[^/]");
                continue;
            }
            string2 = matcher.group(3);
            if (string2 != null) {
                stringBuilder.append(Pattern.quote(matcher.group().substring(1)));
                continue;
            }
            string2 = matcher.group(4);
            if (string2 != null) {
                stringBuilder.append("/+");
                bl = true;
                continue;
            }
            stringBuilder.append(Pattern.quote(matcher.group()));
        }
        if (bl) {
            stringBuilder.append(".*");
        }
        return Pattern.compile(stringBuilder.toString());
    }
}

