/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.exception.UnknownRevisionException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemRevision;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository$;
import com.xebialabs.deployit.repository.sql.HistoryQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Repository
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\u00015\u0011qcQ5ISN$xN]=SKB|7/\u001b;pefLU\u000e\u001d7\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u000be\u0016\u0004xn]5u_JL(BA\u0004\t\u0003!!W\r\u001d7ps&$(BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0002\u0006\r\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\nDS\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u00163%\u0011!D\u0001\u0002\u000f\u0011&\u001cHo\u001c:z#V,'/[3t\u0011!a\u0002A!b\u0001\n\u0003i\u0012\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u0010\u0011\u0005}AS\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013\u0001B2pe\u0016T!a\t\u0013\u0002\t)$'m\u0019\u0006\u0003K\u0019\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002O\u0005\u0019qN]4\n\u0005%\u0002#\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0011!i\u0003A!b\u0001\n\u0003q\u0013AB7baB,'/F\u00010!\t\u0001t'D\u00012\u0015\t\u00114'\u0001\u0005eCR\f'-\u001b8e\u0015\t!T'A\u0004kC\u000e\\7o\u001c8\u000b\u0005YR\u0011!\u00034bgR,'\u000f_7m\u0013\tA\u0014G\u0001\u0007PE*,7\r^'baB,'\u000f\u0003\u0005;\u0001\t\u0005\t\u0015!\u00030\u0003\u001di\u0017\r\u001d9fe\u0002B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\u0019!P\u0001\u000bgFdG)[1mK\u000e$X#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\r\t%BA\u0011\u0007\u0013\t\u0019\u0005I\u0001\u0006Tc2$\u0015.\u00197fGRD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IAP\u0001\fgFdG)[1mK\u000e$\b\u0005C\u0003H\u0001\u0011\u0005\u0001*\u0001\u0004=S:LGO\u0010\u000b\u0004\u0013z\u001bGC\u0001&L!\t)\u0002\u0001C\u0003=\r\u0002\u000fa\b\u000b\u0003L\u001b^C\u0006C\u0001(V\u001b\u0005y%B\u0001)R\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003%N\u000bqAZ1di>\u0014\u0018P\u0003\u0002UI\u0005)!-Z1og&\u0011ak\u0014\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f\u0013!W\u0001\u000f[\u0006LgnU9m\t&\fG.Z2uQ\tY5\f\u0005\u0002O9&\u0011Ql\u0014\u0002\n\u0003V$xn^5sK\u0012DQ\u0001\b$A\u0002yACAX'XA\u0006\n\u0011-\u0001\tnC&t'\n\u001a2d)\u0016l\u0007\u000f\\1uK\"\u0012al\u0017\u0005\u0006[\u0019\u0003\ra\f\u0015\u0005G6;V-I\u0001g\u00035A\u0017n\u001d;pefl\u0015\r\u001d9fe\"\u00121m\u0017\u0005\u0006S\u0002!\tE[\u0001\u0014O\u0016$h+\u001a:tS>t'+\u001a<jg&|gn\u001d\u000b\u0003W^\u00042\u0001\\9t\u001b\u0005i'B\u00018p\u0003\u0011)H/\u001b7\u000b\u0003A\fAA[1wC&\u0011!/\u001c\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002uk6\tA!\u0003\u0002w\t\tI2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7SKZL7/[8o\u0011\u0015A\b\u000e1\u0001z\u0003\tIG\rE\u0002{\u0003\u0007q!a_@\u0011\u0005q\u0004R\"A?\u000b\u0005yd\u0011A\u0002\u001fs_>$h(C\u0002\u0002\u0002A\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001!!9\u00111\u0002\u0001\u0005\n\u00055\u0011!\u00054fi\u000eD'+\u001a<jg&|g\u000eR1uCR!\u0011qBA'!\u0011a\u0017/!\u0005\u0011\u0015=\t\u0019\"a\u0006\u0002\u001e\u0005\u001d\u00130C\u0002\u0002\u0016A\u0011a\u0001V;qY\u0016$\u0004cA\b\u0002\u001a%\u0019\u00111\u0004\t\u0003\u0007%sG\u000f\u0005\u0003\u0002 \u0005\u0005c\u0002BA\u0011\u0003wqA!a\t\u000289!\u0011QEA\u001b\u001d\u0011\t9#a\r\u000f\t\u0005%\u0012\u0011\u0007\b\u0005\u0003W\tyCD\u0002}\u0003[I\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\r\tIDA\u0001\u0005E\u0006\u001cX-\u0003\u0003\u0002>\u0005}\u0012a\u00029bG.\fw-\u001a\u0006\u0004\u0003s\u0011\u0011\u0002BA\"\u0003\u000b\u0012\u0001bQ5Q\u0017RK\b/\u001a\u0006\u0005\u0003{\ty\u0004E\u0002m\u0003\u0013J1!a\u0013n\u0005!\u0019\u0015\r\\3oI\u0006\u0014\bB\u0002=\u0002\n\u0001\u0007\u0011\u0010C\u0004\u0002R\u0001!I!a\u0015\u0002\u001f\r\u0014X-\u0019;f%\u00164\u0018n]5p]N$B!!\u0016\u0002\\A!A.a\u0016t\u0013\r\tI&\u001c\u0002\n\u0003J\u0014\u0018-\u001f'jgRD\u0001\"!\u0018\u0002P\u0001\u0007\u0011qB\u0001\u0006SR,Wn\u001d\u0005\b\u0003C\u0002A\u0011IA2\u00031\u0011X-\u00193SKZL7/[8o+\u0011\t)'a\u001b\u0015\r\u0005\u001d\u00141RAG!\u0011\tI'a\u001b\r\u0001\u0011A\u0011QNA0\u0005\u0004\tyGA\u0001U#\u0011\t\t(a\u001e\u0011\u0007=\t\u0019(C\u0002\u0002vA\u0011qAT8uQ&tw\r\u0005\u0003\u0002z\u0005\u001dUBAA>\u0015\u0011\ti(a \u0002\u0007U$WN\u0003\u0003\u0002\u0002\u0006\r\u0015aA1qS*\u0019\u0011Q\u0011\u0004\u0002\rAdWoZ5o\u0013\u0011\tI)a\u001f\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000e\u0003\u0004y\u0003?\u0002\r!\u001f\u0005\b\u0003\u001f\u000by\u00061\u0001z\u00031\u0011XM^5tS>tg*Y7f\u0011\u001d\t\u0019\n\u0001C!\u0003+\u000ba!\u001b8tKJ$HCCAL\u0003;\u000b\t+!*\u0002:B\u0019q\"!'\n\u0007\u0005m\u0005C\u0001\u0003V]&$\b\u0002CAP\u0003#\u0003\r!!\b\u0002\u0005A\\\u0007\u0002CAR\u0003#\u0003\r!a\u001e\u0002\u0005\rL\u0007\u0002CAT\u0003#\u0003\r!!+\u0002\u00079|w\u000f\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\tQLW.\u001a\u0006\u0004\u0003g3\u0013\u0001\u00026pI\u0006LA!a.\u0002.\nAA)\u0019;f)&lW\rC\u0004\u0002<\u0006E\u0005\u0019A=\u0002\u0011U\u001cXM\u001d(b[\u0016Dq!a0\u0001\t\u0003\n\t-\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003/\u000b\u0019\r\u0003\u0005\u0002 \u0006u\u0006\u0019AA\u000fQ\u0019\u0001\u0011qY,\u0002VB!\u0011\u0011ZAi\u001b\t\tYMC\u0002Q\u0003\u001bT1!a4%\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005M\u00171\u001a\u0002\u000e)J\fgn]1di&|g.\u00197\"\u0005\u0005]\u0017AF7bS:$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u0007\u0001\tY\u000e\u0005\u0003\u0002^\u0006\rXBAAp\u0015\r\t\t\u000fJ\u0001\u000bgR,'/Z8usB,\u0017\u0002BAs\u0003?\u0014!BU3q_NLGo\u001c:z\u0001")
public class CiHistoryRepositoryImpl
implements CiHistoryRepository,
HistoryQueries {
    private final JdbcTemplate jdbcTemplate;
    private final ObjectMapper mapper;
    private final SqlDialect sqlDialect;
    private String INSERT;
    private String DELETE;
    private String SELECT_CI;
    private String SELECT_REVISIONS;
    private volatile byte bitmap$0;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    private String INSERT$lzycompute() {
        CiHistoryRepositoryImpl ciHistoryRepositoryImpl = this;
        synchronized (ciHistoryRepositoryImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.INSERT = HistoryQueries.INSERT$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String DELETE$lzycompute() {
        CiHistoryRepositoryImpl ciHistoryRepositoryImpl = this;
        synchronized (ciHistoryRepositoryImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.DELETE = HistoryQueries.DELETE$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String SELECT_CI$lzycompute() {
        CiHistoryRepositoryImpl ciHistoryRepositoryImpl = this;
        synchronized (ciHistoryRepositoryImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SELECT_CI = HistoryQueries.SELECT_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.SELECT_CI;
    }

    @Override
    public String SELECT_CI() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SELECT_CI$lzycompute() : this.SELECT_CI;
    }

    private String SELECT_REVISIONS$lzycompute() {
        CiHistoryRepositoryImpl ciHistoryRepositoryImpl = this;
        synchronized (ciHistoryRepositoryImpl) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SELECT_REVISIONS = HistoryQueries.SELECT_REVISIONS$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.SELECT_REVISIONS;
    }

    @Override
    public String SELECT_REVISIONS() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SELECT_REVISIONS$lzycompute() : this.SELECT_REVISIONS;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public List<ConfigurationItemRevision> getVersionRevisions(String id) {
        return this.createRevisions(this.fetchRevisionData(id));
    }

    private List<Tuple4<Object, Integer, Calendar, String>> fetchRevisionData(String id) {
        return this.jdbcTemplate().query(this.SELECT_REVISIONS(), (rs, row) -> {
            Integer pk = (Integer)package$.MODULE$.asCiPKType().apply((Object)BoxesRunTime.boxToInteger((int)rs.getInt(1)));
            Calendar timestamp = com.xebialabs.deployit.core.sql.package$.MODULE$.toCalendar(rs.getTimestamp(2, com.xebialabs.deployit.core.sql.package$.MODULE$.UTC_CALENDAR()));
            String username = rs.getString(3);
            return new Tuple4((Object)BoxesRunTime.boxToInteger((int)row), (Object)pk, (Object)timestamp, (Object)username);
        }, new Object[]{package$.MODULE$.idToPath(id)});
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<ConfigurationItemRevision> createRevisions(List<Tuple4<Object, Integer, Calendar, String>> items) {
        void var3_2;
        ArrayList<ConfigurationItemRevision> result = new ArrayList<ConfigurationItemRevision>(items.size());
        Iterator<Tuple4<Object, Integer, Calendar, String>> itr = items.iterator();
        while (itr.hasNext()) {
            Tuple4<Object, Integer, Calendar, String> tuple4 = itr.next();
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            int row = BoxesRunTime.unboxToInt((Object)tuple4._1());
            Calendar timestamp = (Calendar)tuple4._3();
            String username = (String)tuple4._4();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)row), (Object)timestamp, (Object)username);
            Tuple3 tuple32 = tuple3;
            int row2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            Calendar timestamp2 = (Calendar)tuple32._2();
            String username2 = (String)tuple32._3();
            result.add(itr.hasNext() ? new ConfigurationItemRevision(CiHistoryRepository$.MODULE$.indexToRevisionName(row2), timestamp2, username2) : new ConfigurationItemRevision("current", timestamp2, username2));
        }
        return var3_2;
    }

    @Override
    public <T extends ConfigurationItem> T readRevision(String id, String revisionName) {
        String string = revisionName;
        Option option = CiHistoryRepository$.MODULE$.nameRegex().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw CiHistoryRepositoryImpl.throwUnknownRevision$1(id, revisionName);
        }
        String res = (String)((LinearSeqOptimized)option.get()).apply(0);
        int n = new StringOps(Predef$.MODULE$.augmentString(res)).toInt();
        int idx = n;
        List<Tuple4<Object, Integer, Calendar, String>> revisions = this.fetchRevisionData(id);
        if (revisions.size() < idx) {
            throw CiHistoryRepositoryImpl.throwUnknownRevision$1(id, revisionName);
        }
        Integer pk = (Integer)revisions.get(idx)._2();
        List result = this.jdbcTemplate().queryForList(this.SELECT_CI(), String.class, new Object[]{pk, package$.MODULE$.idToPath(id)});
        String ci_json = (String)result.get(0);
        return (T)((ConfigurationItem)this.mapper().readValue(ci_json, ConfigurationItem.class));
    }

    @Override
    public void insert(Integer pk, ConfigurationItem ci, DateTime now, String userName) {
        block0: {
            if (!CiHistoryRepository$.MODULE$.shouldVersion(ci.getId(), ci.getType())) break block0;
            this.jdbcTemplate().update(this.INSERT(), new Object[]{pk, com.xebialabs.deployit.core.sql.package$.MODULE$.toCalendar(now), Option$.MODULE$.apply((Object)userName).getOrElse((Function0 & Serializable & scala.Serializable)() -> "<system>"), this.mapper().writerFor(ConfigurationItem.class).writeValueAsString((Object)ci)});
        }
    }

    @Override
    public void delete(Integer pk) {
        this.jdbcTemplate().update(this.DELETE(), new Object[]{pk});
    }

    private static final Nothing$ throwUnknownRevision$1(String id$1, String revisionName$1) {
        throw new UnknownRevisionException("Cannot find revision [%s] for configuration item [%s]", new Object[]{revisionName$1, id$1});
    }

    public CiHistoryRepositoryImpl(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="historyMapper") ObjectMapper mapper, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.mapper = mapper;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        HistoryQueries.$init$(this);
    }
}

