/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Dictionaries {
    private List<Dictionary> dictionaries = new ArrayList<Dictionary>();
    private Application application;
    private Container container;

    private Dictionaries(List<Dictionary> dictionaries, Application application, Container container) {
        this.dictionaries = dictionaries;
        this.application = application;
        this.container = container;
    }

    public static Dictionaries of(List<Dictionary> dictionaries) {
        return new Dictionaries(dictionaries, null, null);
    }

    public Dictionaries filterBy(Application application) {
        return new Dictionaries(this.dictionaries, application, this.container);
    }

    public Dictionaries filterBy(Container container) {
        return new Dictionaries(this.dictionaries, this.application, container);
    }

    public Dictionaries withAdditionalEntries(Map<String, String> dictionaryEntries) {
        Dictionary dictionary = Dictionaries.inMemoryDictionary(dictionaryEntries);
        ArrayList<Dictionary> newDicts = new ArrayList<Dictionary>();
        newDicts.add(dictionary);
        newDicts.addAll(this.dictionaries);
        return new Dictionaries(newDicts, this.application, this.container);
    }

    private static Dictionary inMemoryDictionary(Map<String, String> dictionaryEntries) {
        Dictionary dictionary = new Dictionary();
        dictionary.getEntries().putAll(dictionaryEntries);
        return dictionary;
    }

    public ConsolidatedDictionary consolidate() {
        List<Dictionary> filteredDictionaries = this.dictionaries.stream().filter(input -> this.isApplicableTo((Dictionary)input, this.application, this.container)).collect(Collectors.toList());
        return ConsolidatedDictionary.create(filteredDictionaries);
    }

    private boolean isApplicableTo(Dictionary dict, Application app, Container container) {
        boolean appMatches = dict.getRestrictToDistributions().isEmpty() || dict.getRestrictToDistributions().contains(app);
        boolean containerMatches = dict.getRestrictToContainers().isEmpty() || dict.getRestrictToContainers().contains(container);
        return appMatches && containerMatches;
    }
}

