/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.Parser;
import com.github.drapostolos.typeparser.ParserHelper;
import com.github.drapostolos.typeparser.TypeParserUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class StaticFactoryMethodParser
implements Parser<Object> {
    private static final Object STATIC_METHOD = null;

    StaticFactoryMethodParser() {
    }

    @Override
    public Object parse(String input, ParserHelper helper) {
        Class targetType = (Class)helper.getTargetType();
        Method method = TypeParserUtility.getMethodNamedValueOf(targetType);
        try {
            if (targetType.isEnum()) {
                input = input.trim();
            }
            method.setAccessible(true);
            return method.invoke(STATIC_METHOD, input);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(this.makeErrorMsg(input, targetType), e.getCause());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(this.makeErrorMsg(input, targetType), t);
        }
    }

    private String makeErrorMsg(String input, Class<?> targetType) {
        String methodSignature = String.format("%s.%s('%s')", targetType.getName(), "valueOf", input);
        String message = " Exception thrown in static factory method '%s'. See underlying exception for additional information.";
        message = String.format(message, methodSignature);
        return TypeParserUtility.makeParseErrorMsg(input, targetType, message);
    }
}

